/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator;

import java.util.Properties;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.context.Flag;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.rocksdb.configuration.CompressionType;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreMigrator;
import org.infinispan.tools.store.migrator.StoreProperties;
import org.infinispan.tools.store.migrator.StoreType;
import org.infinispan.tools.store.migrator.jdbc.JdbcConfigurationUtil;
import org.infinispan.tools.store.migrator.marshaller.SerializationConfigUtil;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;

class TargetStoreFactory {
    private static final String DEFAULT_CACHE_NAME = StoreMigrator.class.getName();

    TargetStoreFactory() {
    }

    static EmbeddedCacheManager getCacheManager(Properties properties) {
        ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder();
        holder.getGlobalConfigurationBuilder().defaultCacheName(DEFAULT_CACHE_NAME);
        StoreProperties props = new StoreProperties(Element.TARGET, properties);
        SerializationConfigUtil.configureSerialization(props, holder.getGlobalConfigurationBuilder().serialization());
        holder.getNamedConfigurationBuilders().put(DEFAULT_CACHE_NAME, new ConfigurationBuilder());
        return new DefaultCacheManager(holder, true);
    }

    static AdvancedCache getTargetCache(EmbeddedCacheManager manager, Properties properties) {
        StoreProperties props = new StoreProperties(Element.TARGET, properties);
        ConfigurationBuilder configBuilder = new ConfigurationBuilder();
        String segmentCountString = props.get(Element.SEGMENT_COUNT);
        int segmentCount = 0;
        if (segmentCountString != null && (segmentCount = Integer.parseInt(segmentCountString)) < 0) {
            throw new IllegalArgumentException("Segment count must be > 0");
        }
        if (segmentCount > 0) {
            configBuilder.clustering().hash().numSegments(segmentCount);
        }
        ((StoreConfigurationBuilder)configBuilder.persistence().addStore(TargetStoreFactory.getInitializedStoreBuilder(props)).purgeOnStartup(true)).segmented(segmentCount > 0);
        configBuilder.invocationBatching().transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        String cacheName = props.cacheName();
        manager.defineConfiguration(cacheName, configBuilder.build());
        return manager.getCache(cacheName).getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
    }

    private static StoreConfigurationBuilder getInitializedStoreBuilder(StoreProperties props) {
        PersistenceConfigurationBuilder persistenceBuilder = new ConfigurationBuilder().persistence();
        StoreType storeType = StoreType.valueOf(props.get(Element.TYPE).toUpperCase());
        switch (storeType) {
            case LEVELDB: 
            case JDBC_BINARY: 
            case JDBC_MIXED: {
                throw new CacheConfigurationException(String.format("%s cannot be a target store as it no longer exists", new Object[]{storeType}));
            }
            case JDBC_STRING: {
                return JdbcConfigurationUtil.configureStore(props, new JdbcStringBasedStoreConfigurationBuilder(persistenceBuilder));
            }
            case ROCKSDB: {
                props.required(Element.LOCATION);
                String location = props.get(Element.LOCATION);
                RocksDBStoreConfigurationBuilder builder = new RocksDBStoreConfigurationBuilder(persistenceBuilder);
                builder.location(location).expiredLocation(location + "-expired-");
                String compressionType = props.get(Element.COMPRESSION);
                if (compressionType != null) {
                    builder.compressionType(CompressionType.valueOf((String)compressionType.toUpperCase()));
                }
                return builder;
            }
            case SOFT_INDEX_FILE_STORE: {
                props.required(Element.LOCATION);
                props.required(Element.INDEX_LOCATION);
                return new SoftIndexFileStoreConfigurationBuilder(persistenceBuilder).dataLocation(props.get(Element.LOCATION)).indexLocation(props.get(Element.INDEX_LOCATION));
            }
        }
        throw new CacheConfigurationException(String.format("Unknown store type '%s'", new Object[]{storeType}));
    }
}

