/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.distribution.util.ReadOnlySegmentAwareMap;
import org.infinispan.tools.store.migrator.marshaller.common.AbstractMigratorExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.Ids;

public class MapExternalizer
extends AbstractMigratorExternalizer<Map> {
    private static final int HASHMAP = 0;
    private static final int TREEMAP = 1;
    private static final int FASTCOPYHASHMAP = 2;
    private static final int EQUIVALENTHASHMAP = 3;
    private static final int CONCURRENTHASHMAP = 4;
    private static final int SINGLETONMAP = 6;
    private static final int EMPTYMAP = 7;

    public MapExternalizer() {
        super(MapExternalizer.getSupportedPrivateClasses(), Ids.MAPS);
    }

    @Override
    public Map readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int magicNumber = input.readUnsignedByte();
        return switch (magicNumber) {
            case 0 -> (HashMap)MarshallUtil.unmarshallMap((ObjectInput)input, HashMap::new);
            case 1 -> (TreeMap)MarshallUtil.unmarshallMap((ObjectInput)input, size -> new TreeMap());
            case 4 -> (ConcurrentHashMap)MarshallUtil.unmarshallMap((ObjectInput)input, ConcurrentHashMap::new);
            case 6 -> Collections.singletonMap(input.readObject(), input.readObject());
            case 7 -> Collections.emptyMap();
            default -> throw new IllegalStateException("Unknown Map type: " + magicNumber);
        };
    }

    public static Set<Class<? extends Map>> getSupportedPrivateClasses() {
        return Set.of(HashMap.class, TreeMap.class, ReadOnlySegmentAwareMap.class, ConcurrentHashMap.class, MapExternalizer.getPrivateSingletonMapClass(), MapExternalizer.getPrivateEmptyMapClass(), MapExternalizer.getPrivateImmutableMap1Class(), MapExternalizer.getPrivateImmutableMapNClass());
    }

    private static Class<? extends Map> getPrivateSingletonMapClass() {
        return MapExternalizer.getMapClass("java.util.Collections$SingletonMap");
    }

    private static Class<? extends Map> getPrivateEmptyMapClass() {
        return MapExternalizer.getMapClass("java.util.Collections$EmptyMap");
    }

    private static Class<? extends Map> getPrivateImmutableMap1Class() {
        return MapExternalizer.getMapClass("java.util.ImmutableCollections$Map1");
    }

    private static Class<? extends Map> getPrivateImmutableMapNClass() {
        return MapExternalizer.getMapClass("java.util.ImmutableCollections$MapN");
    }

    private static Class<? extends Map> getMapClass(String className) {
        return Util.loadClass((String)className, (ClassLoader)Map.class.getClassLoader());
    }
}

