/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.jdbc;

import java.util.Iterator;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.impl.table.TableManager;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.tools.store.migrator.jdbc.BinaryJdbcIterator;
import org.infinispan.tools.store.migrator.jdbc.StringJdbcIterator;

class MixedJdbcIterator
implements Iterator<MarshallableEntry>,
AutoCloseable {
    private BinaryJdbcIterator binaryIt;
    private StringJdbcIterator stringIt;

    MixedJdbcIterator(ConnectionFactory connectionFactory, TableManager binaryTm, TableManager stringTm, Marshaller marshaller, TwoWayKey2StringMapper key2StringMapper) {
        this.binaryIt = new BinaryJdbcIterator(connectionFactory, binaryTm, marshaller);
        this.stringIt = new StringJdbcIterator(connectionFactory, stringTm, marshaller, key2StringMapper);
    }

    @Override
    public boolean hasNext() {
        return this.binaryIt.hasNext() || this.stringIt.hasNext();
    }

    @Override
    public MarshallableEntry next() {
        if (this.binaryIt.hasNext()) {
            return this.binaryIt.next();
        }
        return this.stringIt.next();
    }

    @Override
    public void close() {
        this.binaryIt.close();
        this.stringIt.close();
    }
}

