/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.remote.session;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.common.session.AbstractApplicationPublisherBridge;
import org.infinispan.util.KeyValuePair;
import org.springframework.session.MapSession;
import org.springframework.session.Session;

@ClientListener(converterFactoryName="___eager-key-value-version-converter", useRawData=true)
public class RemoteApplicationPublishedBridge
extends AbstractApplicationPublisherBridge {
    private final DataFormat dataFormat;
    private final ClassAllowList allowList = new ClassAllowList(Collections.singletonList(".*"));

    public RemoteApplicationPublishedBridge(SpringCache eventSource) {
        super(eventSource);
        this.dataFormat = ((RemoteCache)eventSource.getNativeCache()).getDataFormat();
    }

    protected void registerListener() {
        ((RemoteCache)this.eventSource.getNativeCache()).addClientListener((Object)this, null, new Object[]{Boolean.TRUE});
    }

    public void unregisterListener() {
        ((RemoteCache)this.eventSource.getNativeCache()).removeClientListener((Object)this);
    }

    @ClientCacheEntryCreated
    public void processCacheEntryCreated(ClientCacheEntryCustomEvent<byte[]> event) {
        this.emitSessionCreatedEvent((Session)this.readEvent(event).getValue());
    }

    @ClientCacheEntryExpired
    public void processCacheEntryExpired(ClientCacheEntryCustomEvent<byte[]> event) {
        this.emitSessionExpiredEvent((Session)this.readEvent(event).getValue());
    }

    @ClientCacheEntryRemoved
    public void processCacheEntryDestroyed(ClientCacheEntryCustomEvent<byte[]> event) {
        this.emitSessionDestroyedEvent((Session)this.readEvent(event).getValue());
    }

    protected KeyValuePair<String, Session> readEvent(ClientCacheEntryCustomEvent<byte[]> event) {
        byte[] eventData = (byte[])event.getEventData();
        ByteBuffer rawData = ByteBuffer.wrap(eventData);
        byte[] rawKey = this.readElement(rawData);
        byte[] rawValue = this.readElement(rawData);
        String key = (String)this.dataFormat.keyToObj(rawKey, this.allowList);
        KeyValuePair keyValuePair = rawValue == null ? new KeyValuePair((Object)key, (Object)new MapSession(key)) : new KeyValuePair((Object)key, this.dataFormat.valueToObj(rawValue, this.allowList));
        return keyValuePair;
    }

    private byte[] readElement(ByteBuffer buffer) {
        if (buffer.remaining() == 0) {
            return null;
        }
        int length = UnsignedNumeric.readUnsignedInt((ByteBuffer)buffer);
        byte[] element = new byte[length];
        buffer.get(element);
        return element;
    }
}

