/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.common.session;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.protostream.BaseMarshallerDelegate;
import org.infinispan.protostream.GeneratedMarshallerBase;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.TagReader;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.ProtoAdapter;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.springframework.session.MapSession;

@ProtoAdapter(value=MapSession.class)
@ProtoTypeId(value=5901)
public class MapSessionProtoAdapter {
    @ProtoFactory
    static MapSession createSession(String id, String originalId, Collection<SessionAttribute> attributes, Instant creationTime, Instant lastAccessedTime, long maxInactiveSeconds) {
        MapSession session = new MapSession(originalId);
        session.setId(id);
        session.setCreationTime(creationTime);
        session.setLastAccessedTime(lastAccessedTime);
        session.setMaxInactiveInterval(Duration.ofSeconds(maxInactiveSeconds));
        for (SessionAttribute attribute : attributes) {
            session.setAttribute(attribute.getName(), attribute.getValue());
        }
        return session;
    }

    @ProtoField(number=1)
    String getId(MapSession session) {
        return session.getId();
    }

    @ProtoField(number=2)
    String getOriginalId(MapSession session) {
        if (Objects.equals(session.getOriginalId(), session.getId())) {
            return null;
        }
        return session.getOriginalId();
    }

    @ProtoField(number=3, defaultValue="0")
    Instant getCreationTime(MapSession session) {
        return session.getCreationTime();
    }

    @ProtoField(number=4, defaultValue="0")
    Instant getLastAccessedTime(MapSession session) {
        return session.getLastAccessedTime();
    }

    @ProtoField(number=5, defaultValue="-1")
    long getMaxInactiveSeconds(MapSession session) {
        return session.getMaxInactiveInterval().getSeconds();
    }

    @ProtoField(number=6)
    Collection<SessionAttribute> getAttributes(MapSession session) {
        return session.getAttributeNames().stream().map(name -> new SessionAttribute((String)name, session.getAttribute(name))).collect(Collectors.toList());
    }

    @ProtoTypeId(value=5902)
    public static class SessionAttribute {
        private final String name;
        private final Object value;

        @ProtoFactory
        SessionAttribute(String name, WrappedMessage wrappedMessage, byte[] serializedBytes) {
            throw new IllegalStateException("Custom marshaller not registered!");
        }

        public SessionAttribute(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        @ProtoField(number=1)
        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        @ProtoField(number=2)
        public WrappedMessage getWrappedMessage() {
            return new WrappedMessage(this.value);
        }

        @ProtoField(number=3)
        public byte[] getSerializedBytes() {
            throw new IllegalStateException("Custom marshaller not registered!");
        }
    }

    public static final class SessionAttributeRawMarshaller
    extends GeneratedMarshallerBase
    implements ProtobufTagMarshaller<SessionAttribute> {
        private final JavaSerializationMarshaller javaSerializationMarshaller;
        private BaseMarshallerDelegate<WrappedMessage> wrappedMessageDelegate;

        public SessionAttributeRawMarshaller(JavaSerializationMarshaller javaSerializationMarshaller) {
            this.javaSerializationMarshaller = javaSerializationMarshaller;
        }

        public Class<SessionAttribute> getJavaClass() {
            return SessionAttribute.class;
        }

        public String getTypeName() {
            return "org.infinispan.persistence.spring.SessionAttribute";
        }

        public SessionAttribute read(ProtobufTagMarshaller.ReadContext ctx) throws IOException {
            TagReader in = ctx.getReader();
            String name = null;
            boolean done = false;
            Object value = null;
            block6: while (!done) {
                int tag = in.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block6;
                    }
                    case 10: {
                        name = in.readString();
                        continue block6;
                    }
                    case 18: {
                        if (this.wrappedMessageDelegate == null) {
                            this.wrappedMessageDelegate = ((SerializationContextImpl)ctx.getSerializationContext()).getMarshallerDelegate(WrappedMessage.class);
                        }
                        int length = in.readUInt32();
                        int oldLimit = in.pushLimit(length);
                        WrappedMessage wrappedMessage = (WrappedMessage)this.readMessage(this.wrappedMessageDelegate, ctx);
                        value = wrappedMessage.getValue();
                        in.checkLastTagWas(0);
                        in.popLimit(oldLimit);
                        continue block6;
                    }
                    case 26: {
                        byte[] serializedBytes = in.readByteArray();
                        value = this.deserializeValue(serializedBytes);
                        continue block6;
                    }
                }
                if (in.skipField(tag)) continue;
                done = true;
            }
            return new SessionAttribute(name, value);
        }

        public void write(ProtobufTagMarshaller.WriteContext ctx, SessionAttribute attribute) throws IOException {
            Object value;
            String name = attribute.getName();
            if (name != null) {
                ctx.getWriter().writeString(1, name);
            }
            if ((value = attribute.getValue()) != null) {
                if (ctx.getSerializationContext().canMarshall(value.getClass())) {
                    WrappedMessage wrappedMessage = new WrappedMessage(value);
                    if (this.wrappedMessageDelegate == null) {
                        this.wrappedMessageDelegate = ((SerializationContextImpl)ctx.getSerializationContext()).getMarshallerDelegate(WrappedMessage.class);
                    }
                    this.writeNestedMessage(this.wrappedMessageDelegate, ctx, 2, wrappedMessage);
                } else {
                    byte[] serializedBytes = this.serializeValue(value);
                    ctx.getWriter().writeBytes(3, serializedBytes);
                }
            }
        }

        private byte[] serializeValue(Object value) throws IOException {
            byte[] serializedBytes;
            try {
                serializedBytes = this.javaSerializationMarshaller.objectToByteBuffer(value);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CacheException((Throwable)e);
            }
            return serializedBytes;
        }

        private Object deserializeValue(byte[] serializedBytes) {
            try {
                return this.javaSerializationMarshaller.objectFromByteBuffer(serializedBytes);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CacheException((Throwable)e);
            }
        }
    }
}

