/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.starter.embedded.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;

public class InfinispanCacheMeterBinder<K, V>
extends CacheMeterBinder<Cache<K, V>> {
    public InfinispanCacheMeterBinder(Cache<K, V> cache, Iterable<Tag> tags) {
        super(cache, cache.getName(), tags);
    }

    protected Long size() {
        if (this.getCache() == null) {
            return 0L;
        }
        return InfinispanCacheMeterBinder.checkNegativeStat(((Cache)this.getCache()).getAdvancedCache().getStats().getApproximateEntriesInMemory());
    }

    protected long hitCount() {
        if (this.getCache() == null) {
            return 0L;
        }
        return InfinispanCacheMeterBinder.checkNegativeStat(((Cache)this.getCache()).getAdvancedCache().getStats().getHits());
    }

    protected Long missCount() {
        if (this.getCache() == null) {
            return 0L;
        }
        return InfinispanCacheMeterBinder.checkNegativeStat(((Cache)this.getCache()).getAdvancedCache().getStats().getMisses());
    }

    protected Long evictionCount() {
        if (this.getCache() == null) {
            return 0L;
        }
        return InfinispanCacheMeterBinder.checkNegativeStat(((Cache)this.getCache()).getAdvancedCache().getStats().getEvictions());
    }

    protected long putCount() {
        if (this.getCache() == null) {
            return 0L;
        }
        return InfinispanCacheMeterBinder.checkNegativeStat(((Cache)this.getCache()).getAdvancedCache().getStats().getStores());
    }

    protected void bindImplementationSpecificMetrics(MeterRegistry registry) {
        if (this.getCache() == null) {
            return;
        }
        Gauge.builder((String)"cache.start", (Object)((Cache)this.getCache()), cache -> InfinispanCacheMeterBinder.checkNegativeStat(cache.getAdvancedCache().getStats().getTimeSinceStart())).baseUnit(TimeUnit.SECONDS.name()).tags(this.getTagsWithCacheName()).description("Time elapsed since start").register(registry);
        Gauge.builder((String)"cache.reset", (Object)((Cache)this.getCache()), cache -> InfinispanCacheMeterBinder.checkNegativeStat(cache.getAdvancedCache().getStats().getTimeSinceReset())).baseUnit(TimeUnit.SECONDS.name()).tags(this.getTagsWithCacheName()).description("Time elapsed since the last statistics reset").register(registry);
        this.memory(registry);
        this.averages(registry);
        this.averagesNanos(registry);
    }

    private void memory(MeterRegistry registry) {
        Cache cache = (Cache)this.getCache();
        Gauge.builder((String)"cache.memory.size", (Object)cache, c -> InfinispanCacheMeterBinder.checkNegativeStat(c.getAdvancedCache().getStats().getApproximateEntriesInMemory())).tags(this.getTagsWithCacheName()).description("Approximate number of entries in the cache, excluding passivated entries").register(registry);
        if (cache.getCacheConfiguration().memory().isEvictionEnabled()) {
            Gauge.builder((String)"cache.memory.used", (Object)cache, c -> InfinispanCacheMeterBinder.checkNegativeStat(c.getAdvancedCache().getStats().getDataMemoryUsed())).tags(this.getTagsWithCacheName()).description("Provides how much memory the current eviction algorithm estimates is in use for data").register(registry);
        }
        Gauge.builder((String)"cache.memory.offHeap", (Object)cache, c -> InfinispanCacheMeterBinder.checkNegativeStat(c.getAdvancedCache().getStats().getOffHeapMemoryUsed())).tags(this.getTagsWithCacheName()).description("The amount of off-heap memory used by this cache").register(registry);
    }

    private void averages(MeterRegistry registry) {
        Cache cache = (Cache)this.getCache();
        Gauge.builder((String)"cache.puts.latency", (Object)cache, c -> InfinispanCacheMeterBinder.checkNegativeStat(c.getAdvancedCache().getStats().getAverageWriteTime())).baseUnit(TimeUnit.MILLISECONDS.name()).tags(this.getTagsWithCacheName()).description("Cache puts").register(registry);
        Gauge.builder((String)"cache.gets.latency", (Object)cache, c -> InfinispanCacheMeterBinder.checkNegativeStat(c.getAdvancedCache().getStats().getAverageReadTime())).baseUnit(TimeUnit.MILLISECONDS.name()).tags(this.getTagsWithCacheName()).description("Cache gets").register(registry);
        Gauge.builder((String)"cache.removes.latency", (Object)cache, c -> InfinispanCacheMeterBinder.checkNegativeStat(c.getAdvancedCache().getStats().getAverageRemoveTime())).baseUnit(TimeUnit.MILLISECONDS.name()).tags(this.getTagsWithCacheName()).description("Cache removes").register(registry);
    }

    private void averagesNanos(MeterRegistry registry) {
        Cache cache = (Cache)this.getCache();
        Gauge.builder((String)"cache.puts.nlatency", (Object)cache, c -> InfinispanCacheMeterBinder.checkNegativeStat(c.getAdvancedCache().getStats().getAverageWriteTimeNanos())).baseUnit(TimeUnit.NANOSECONDS.name()).tags(this.getTagsWithCacheName()).description("Cache puts in nanos").register(registry);
        Gauge.builder((String)"cache.gets.nlatency", (Object)cache, c -> InfinispanCacheMeterBinder.checkNegativeStat(c.getAdvancedCache().getStats().getAverageReadTimeNanos())).baseUnit(TimeUnit.NANOSECONDS.name()).tags(this.getTagsWithCacheName()).description("Cache gets in nanos").register(registry);
        Gauge.builder((String)"cache.removes.nlatency", (Object)cache, c -> InfinispanCacheMeterBinder.checkNegativeStat(c.getAdvancedCache().getStats().getAverageRemoveTimeNanos())).baseUnit(TimeUnit.NANOSECONDS.name()).tags(this.getTagsWithCacheName()).description("Cache removes in nanos").register(registry);
    }

    private static long checkNegativeStat(long stat) {
        return stat < 0L ? 0L : stat;
    }
}

