/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.junit5;

import java.net.InetAddress;
import java.util.function.BiConsumer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.api.JmxTestClient;
import org.infinispan.server.test.api.MemcachedTestClientDriver;
import org.infinispan.server.test.api.RespTestClientDriver;
import org.infinispan.server.test.api.RestTestClientDriver;
import org.infinispan.server.test.api.TestClientDriver;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.server.test.core.TestClient;
import org.infinispan.server.test.core.TestServer;
import org.infinispan.server.test.core.rollingupgrade.CombinedInfinispanServerDriver;
import org.infinispan.server.test.core.rollingupgrade.RollingUpgradeConfiguration;
import org.infinispan.server.test.core.rollingupgrade.RollingUpgradeConfigurationBuilder;
import org.infinispan.server.test.core.rollingupgrade.RollingUpgradeHandler;
import org.infinispan.server.test.junit5.AbstractServerExtension;
import org.infinispan.server.test.junit5.InfinispanServerExtensionBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class RollingUpgradeHandlerExtension
extends AbstractServerExtension
implements BeforeEachCallback,
AfterEachCallback,
TestClientDriver {
    private final RollingUpgradeConfigurationBuilder configurationBuilder;
    private RollingUpgradeHandler handler;
    private TestServer testServer;
    private TestClient testClient;

    public RollingUpgradeHandlerExtension(RollingUpgradeConfigurationBuilder configurationBuilder) {
        this.configurationBuilder = configurationBuilder;
    }

    public static RollingUpgradeHandlerExtension from(Class<?> caller, InfinispanServerExtensionBuilder iseb, String fromVersion, String toVersion) {
        return new RollingUpgradeHandlerExtension(RollingUpgradeHandlerExtension.convertBuilder(caller, iseb, fromVersion, toVersion));
    }

    public static RollingUpgradeConfigurationBuilder convertBuilder(Class<?> caller, InfinispanServerExtensionBuilder iseb, String fromVersion, String toVersion) {
        return RollingUpgradeHandlerExtension.convertBuilder(caller.getName(), iseb, fromVersion, toVersion);
    }

    public static RollingUpgradeConfigurationBuilder convertBuilder(String name, InfinispanServerExtensionBuilder iseb, String fromVersion, String toVersion) {
        Archive[] javaArchives;
        RollingUpgradeConfigurationBuilder builder = new RollingUpgradeConfigurationBuilder(name, fromVersion, toVersion);
        InfinispanServerTestConfiguration configuration = iseb.createServerTestConfiguration();
        if (configuration.isDefaultFile()) {
            builder.useDefaultServerConfiguration(configuration.configurationFile());
        } else {
            builder.useCustomServerConfiguration(configuration.configurationFile());
        }
        String[] artifacts = configuration.mavenArtifacts();
        if (artifacts != null) {
            builder.addMavenArtifacts(artifacts);
        }
        if ((javaArchives = configuration.archives()) != null) {
            builder.addArchives(javaArchives);
        }
        builder.nodeCount(configuration.numServers());
        configuration.properties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            if (k instanceof String) {
                String ks = (String)k;
                if (v instanceof String) {
                    String vs = (String)v;
                    builder.addProperty(ks, vs);
                }
            }
        }));
        configuration.listeners().forEach(arg_0 -> ((RollingUpgradeConfigurationBuilder)builder).addListener(arg_0));
        return builder;
    }

    @Override
    protected void onTestsComplete(ExtensionContext extensionContext) {
        if (this.handler != null) {
            this.testServer.afterListeners();
            if (extensionContext.getExecutionException().isPresent()) {
                this.handler.exceptionEncountered((Throwable)extensionContext.getExecutionException().get());
            } else {
                this.handler.completeUpgrade(true);
            }
        }
    }

    @Override
    protected void onTestsStart(ExtensionContext extensionContext) {
        if (this.handler == null && !this.isSuiteClass(extensionContext)) {
            this.handler = RollingUpgradeHandler.runUntilMixed((RollingUpgradeConfiguration)this.configurationBuilder.build());
            this.testServer = new TestServer(this.handler.getFromConfig(), (InfinispanServerDriver)new CombinedInfinispanServerDriver(this.handler.getFromDriver(), this.handler.getToDriver()));
        }
    }

    public void beforeEach(ExtensionContext context) {
        this.testClient = new TestClient(this.testServer);
        this.startTestClient(context, this.testClient);
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.testClient.clearResources();
    }

    public String addScript(RemoteCacheManager remoteCacheManager, String script) {
        return this.testClient.addScript(remoteCacheManager, script);
    }

    public boolean isContainerized() {
        return true;
    }

    public HotRodTestClientDriver hotrod() {
        return this.testClient.hotrod();
    }

    public RestTestClientDriver rest() {
        return this.testClient.rest();
    }

    public RespTestClientDriver resp() {
        return this.testClient.resp();
    }

    public MemcachedTestClientDriver memcached() {
        return this.testClient.memcached();
    }

    public JmxTestClient jmx() {
        return this.testClient.jmx();
    }

    public String getMethodName() {
        return this.testClient.getMethodName();
    }

    public String getMethodName(String qualifier) {
        return this.testClient.getMethodName(new Object[]{qualifier});
    }

    public CounterManager getCounterManager() {
        return this.testClient.getCounterManager();
    }

    public InetAddress getServerAddress(int offset) {
        return this.testClient.getServerDriver().getServerAddress(offset);
    }
}

