/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.junit5;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.infinispan.server.test.core.TestClient;
import org.infinispan.server.test.core.TestServer;
import org.infinispan.server.test.junit5.InfinispanServer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.suite.api.SelectClasses;
import org.junit.platform.suite.api.Suite;

public abstract class AbstractServerExtension
implements BeforeAllCallback,
AfterAllCallback {
    private static final Log log = LogFactory.getLog(AbstractServerExtension.class);
    protected final List<Consumer<File>> configurationEnhancers = new ArrayList<Consumer<File>>();
    protected final Set<Class<?>> suiteTestClasses = new HashSet();
    protected Class<?> suite;

    protected String testName(ExtensionContext extensionContext) {
        return extensionContext.getRequiredTestClass().getName().replaceAll("\\$", "-");
    }

    protected void initSuiteClasses(ExtensionContext extensionContext) {
        if (!this.suiteTestClasses.isEmpty()) {
            return;
        }
        Class testClass = extensionContext.getRequiredTestClass();
        this.addSuiteTestClasses(testClass);
        this.addSuiteTestClasses(testClass.getDeclaringClass());
        if (this.suite == null && this.isSuiteClass(extensionContext)) {
            this.suite = testClass;
        }
    }

    private void addSuiteTestClasses(Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        SelectClasses selectClasses = clazz.getAnnotation(SelectClasses.class);
        if (selectClasses != null) {
            Collections.addAll(this.suiteTestClasses, selectClasses.value());
        }
    }

    protected boolean isSuiteClass(ExtensionContext extensionContext) {
        return extensionContext.getRequiredTestClass().isAnnotationPresent(Suite.class);
    }

    protected void cleanupSuiteClasses(ExtensionContext extensionContext) {
        this.suiteTestClasses.remove(extensionContext.getRequiredTestClass());
    }

    protected void startTestServer(ExtensionContext extensionContext, TestServer testServer) {
        boolean manageServer;
        String testName = this.testName(extensionContext);
        boolean bl = manageServer = !this.isSuiteClass(extensionContext) && !testServer.isDriverInitialized();
        if (manageServer) {
            testServer.initServerDriver();
            testServer.getDriver().prepare(testName);
            testServer.beforeListeners();
            this.configurationEnhancers.forEach(c -> c.accept(testServer.getDriver().getConfDir()));
            testServer.getDriver().start(testName);
        }
    }

    protected void startTestClient(ExtensionContext extensionContext, TestClient testClient) {
        String methodName = String.format("%s.%s.%s", extensionContext.getRequiredTestClass().getSimpleName(), extensionContext.getRequiredTestMethod(), extensionContext.getDisplayName());
        testClient.initResources();
        testClient.setMethodName(methodName);
    }

    protected void stopTestServer(ExtensionContext extensionContext, TestServer testServer) {
        String testName = this.testName(extensionContext);
        testServer.stopServerDriver(testName);
    }

    private void injectFields(Class<?> testClass, Object testInstance, Object value, Predicate<Field> predicate) {
        AnnotationSupport.findAnnotatedFields(testClass, InfinispanServer.class, predicate).forEach(field -> {
            try {
                field.setAccessible(true);
                field.set(testInstance, value);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    private void injectExtension(Class<?> testClass, Object value) {
        this.injectFields(testClass, null, value, ModifierSupport::isStatic);
    }

    public final void beforeAll(ExtensionContext context) throws Exception {
        try {
            this.initSuiteClasses(context);
            Class testClass = context.getRequiredTestClass();
            log.infof("Starting test suite: %s for test %s", this.suite, (Object)testClass);
            this.injectExtension(testClass, this);
            SelectClasses selectClasses = testClass.getAnnotation(SelectClasses.class);
            if (selectClasses != null) {
                for (Class selectClass : selectClasses.value()) {
                    this.injectExtension(selectClass, this);
                }
            }
            this.onTestsStart(context);
        }
        catch (Throwable t) {
            Assertions.fail((String)String.format("Failed during '%s#beforeAll' suite execution", this.suite.getName()), (Throwable)t);
        }
    }

    protected abstract void onTestsStart(ExtensionContext var1) throws Exception;

    public final void afterAll(ExtensionContext context) {
        try {
            log.infof("Finishing suite: %s for test %s", this.suite, context.getTestClass().orElse(null));
            this.cleanupSuiteClasses(context);
            if (this.suiteTestClasses.isEmpty()) {
                this.onTestsComplete(context);
            }
        }
        catch (Throwable t) {
            Assertions.fail((String)String.format("Failed during '%s#afterAll' suite execution", this.suite.getName()), (Throwable)t);
        }
    }

    protected abstract void onTestsComplete(ExtensionContext var1);
}

