/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.junit5;

import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.api.JmxTestClient;
import org.infinispan.server.test.api.MemcachedTestClientDriver;
import org.infinispan.server.test.api.RespTestClientDriver;
import org.infinispan.server.test.api.RestTestClientDriver;
import org.infinispan.server.test.api.TestClientDriver;
import org.infinispan.server.test.core.ContainerInfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.server.test.core.TestClient;
import org.infinispan.server.test.core.TestServer;
import org.infinispan.server.test.junit5.AbstractServerExtension;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class InfinispanServerExtension
extends AbstractServerExtension
implements TestClientDriver,
BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback,
AfterAllCallback {
    private final TestServer testServer;
    private TestClient testClient;

    public InfinispanServerExtension(InfinispanServerTestConfiguration configuration) {
        this.testServer = new TestServer(configuration);
    }

    public void beforeAll(ExtensionContext extensionContext) {
        this.initSuiteClasses(extensionContext);
        this.startTestServer(extensionContext, this.testServer);
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.testClient = new TestClient(this.testServer);
        this.startTestClient(extensionContext, this.testClient);
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.testClient.clearResources();
    }

    public void afterAll(ExtensionContext extensionContext) {
        this.cleanupSuiteClasses(extensionContext);
        if (this.suiteTestClasses.isEmpty()) {
            if (this.testServer.isDriverInitialized()) {
                this.stopTestServer(extensionContext, this.testServer);
            }
            this.testServer.afterListeners();
        }
    }

    public void assumeContainerMode() {
        Assumptions.assumeTrue((boolean)(this.getServerDriver() instanceof ContainerInfinispanServerDriver), (String)"Requires CONTAINER mode");
    }

    public HotRodTestClientDriver hotrod() {
        return this.testClient.hotrod();
    }

    public RestTestClientDriver rest() {
        return this.testClient.rest();
    }

    public RespTestClientDriver resp() {
        return this.testClient.resp();
    }

    public MemcachedTestClientDriver memcached() {
        return this.testClient.memcached();
    }

    public JmxTestClient jmx() {
        return this.testClient.jmx();
    }

    public String getMethodName() {
        return this.testClient.getMethodName();
    }

    public String getMethodName(String qualifier) {
        return this.testClient.getMethodName(new Object[]{qualifier});
    }

    public CounterManager getCounterManager() {
        return this.testClient.getCounterManager();
    }

    public TestServer getTestServer() {
        return this.testServer;
    }

    public InfinispanServerDriver getServerDriver() {
        return this.testServer.getDriver();
    }

    public String addScript(RemoteCacheManager remoteCacheManager, String script) {
        return this.testClient.addScript(remoteCacheManager, script);
    }
}

