/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.security.LdapRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.LdapUserPasswordMapperConfiguration;

public class LdapUserPasswordMapperConfigurationBuilder
implements Builder<LdapUserPasswordMapperConfiguration> {
    private final AttributeSet attributes;
    private final LdapRealmConfigurationBuilder ldapConfigurationBuilder;

    LdapUserPasswordMapperConfigurationBuilder(LdapRealmConfigurationBuilder ldapConfigurationBuilder) {
        this.ldapConfigurationBuilder = ldapConfigurationBuilder;
        this.attributes = LdapUserPasswordMapperConfiguration.attributeDefinitionSet();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public LdapUserPasswordMapperConfigurationBuilder from(String from) {
        this.attributes.attribute(LdapUserPasswordMapperConfiguration.FROM).set((Object)from);
        return this;
    }

    public LdapUserPasswordMapperConfigurationBuilder verifiable(boolean verifiable) {
        this.attributes.attribute(LdapUserPasswordMapperConfiguration.VERIFIABLE).set((Object)verifiable);
        return this;
    }

    public LdapUserPasswordMapperConfiguration create() {
        return new LdapUserPasswordMapperConfiguration(this.attributes.protect());
    }

    public LdapUserPasswordMapperConfigurationBuilder read(LdapUserPasswordMapperConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public void validate() {
        if (this.ldapConfigurationBuilder.isDirectVerificationEnabled() && this.attributes.attribute(LdapUserPasswordMapperConfiguration.FROM).isNull()) {
            throw Server.log.ldapDirectVerificationWithoutUserMapper();
        }
    }
}

