/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.Map;
import java.util.Properties;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.infinispan.server.configuration.security.SecurityConfiguration;
import org.infinispan.server.core.logging.Log;

public class RealmsConfiguration {
    private final Map<String, RealmConfiguration> realms;

    RealmsConfiguration(Map<String, RealmConfiguration> realms) {
        this.realms = realms;
    }

    public Map<String, RealmConfiguration> realms() {
        return this.realms;
    }

    public RealmConfiguration getRealm(String name) {
        RealmConfiguration realm = this.realms.get(name);
        if (realm == null) {
            throw Server.log.unknownSecurityDomain(name);
        }
        return realm;
    }

    void init(SecurityConfiguration security, Properties properties) {
        for (RealmConfiguration realm : this.realms.values()) {
            realm.initSSLContexts(properties);
        }
        for (RealmConfiguration realm : this.realms.values()) {
            realm.init(security, properties);
        }
    }

    public void flushRealmCaches() {
        for (RealmConfiguration realm : this.realms.values()) {
            realm.flushCache();
            Log.SERVER.flushRealmCache(realm.name());
        }
    }
}

