/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.List;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.security.KerberosSecurityFactoryConfiguration;
import org.infinispan.server.configuration.security.SSLConfiguration;
import org.wildfly.security.credential.source.CredentialSource;

public class ServerIdentitiesConfiguration {
    private final SSLConfiguration sslConfiguration;
    private final List<KerberosSecurityFactoryConfiguration> kerberosConfigurations;

    ServerIdentitiesConfiguration(SSLConfiguration sslConfiguration, List<KerberosSecurityFactoryConfiguration> kerberosConfigurations) {
        this.sslConfiguration = sslConfiguration;
        this.kerberosConfigurations = kerberosConfigurations;
    }

    public SSLConfiguration sslConfiguration() {
        return this.sslConfiguration;
    }

    public List<KerberosSecurityFactoryConfiguration> kerberosConfigurations() {
        return this.kerberosConfigurations;
    }

    public CredentialSource getCredentialSource(String serverPrincipal) {
        for (KerberosSecurityFactoryConfiguration configuration : this.kerberosConfigurations) {
            if (!configuration.getPrincipal().equals(serverPrincipal)) continue;
            return configuration.getCredentialSource();
        }
        throw Server.log.unknownServerIdentity(serverPrincipal);
    }
}

