/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.util.HashSet;
import java.util.Map;
import org.infinispan.commons.dataconversion.internal.Json;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.authz.Roles;

public class KeycloakRoleDecoder
implements RoleDecoder {
    private static final String CLAIM_REALM_ACCESS = "realm_access";
    private static final String CLAIM_RESOURCE_ACCESS = "resource_access";
    private static final String CLAIM_ROLES = "roles";

    public Roles decodeRoles(AuthorizationIdentity identity) {
        Attributes.Entry resourceAccess;
        String realmAccessValue;
        Json json;
        Json rolesValue;
        Attributes attributes = identity.getAttributes();
        Attributes.Entry realmAccess = attributes.get(CLAIM_REALM_ACCESS);
        HashSet<String> roleSet = new HashSet<String>();
        if (realmAccess != null && !realmAccess.isEmpty() && (rolesValue = (json = Json.read((String)(realmAccessValue = (String)realmAccess.get(0)))).at(CLAIM_ROLES)) != null) {
            for (Object role : rolesValue.asList()) {
                roleSet.add(role.toString());
            }
        }
        if ((resourceAccess = attributes.get(CLAIM_RESOURCE_ACCESS)) != null) {
            for (String resource : resourceAccess) {
                Map resources = Json.read((String)resource).asJsonMap();
                for (String resourceKey : resources.keySet()) {
                    Json roles = ((Json)resources.get(resourceKey)).at(CLAIM_ROLES);
                    if (roles == null) continue;
                    for (Object role : roles.asList()) {
                        roleSet.add(role.toString());
                    }
                }
            }
        }
        return Roles.fromSet(roleSet);
    }
}

