/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.security.DistributedRealmConfiguration;
import org.infinispan.server.configuration.security.JwtConfigurationBuilder;
import org.infinispan.server.configuration.security.OAuth2ConfigurationBuilder;
import org.infinispan.server.configuration.security.RealmProviderBuilder;
import org.infinispan.server.configuration.security.TokenRealmConfiguration;

public class TokenRealmConfigurationBuilder
implements RealmProviderBuilder<TokenRealmConfiguration> {
    private final AttributeSet attributes = TokenRealmConfiguration.attributeDefinitionSet();
    private final JwtConfigurationBuilder jwtConfiguration = new JwtConfigurationBuilder();
    private final OAuth2ConfigurationBuilder oauth2Configuration = new OAuth2ConfigurationBuilder();

    public AttributeSet attributes() {
        return this.attributes;
    }

    public JwtConfigurationBuilder jwtConfiguration() {
        return this.jwtConfiguration;
    }

    public OAuth2ConfigurationBuilder oauth2Configuration() {
        return this.oauth2Configuration;
    }

    public TokenRealmConfigurationBuilder name(String name) {
        this.attributes.attribute(TokenRealmConfiguration.NAME).set((Object)name);
        return this;
    }

    @Override
    public String name() {
        return (String)this.attributes.attribute(DistributedRealmConfiguration.NAME).get();
    }

    public TokenRealmConfigurationBuilder authServerUrl(String authServerUrl) {
        this.attributes.attribute(TokenRealmConfiguration.AUTH_SERVER_URL).set((Object)authServerUrl);
        return this;
    }

    public TokenRealmConfigurationBuilder clientId(String clientId) {
        this.attributes.attribute(TokenRealmConfiguration.CLIENT_ID).set((Object)clientId);
        return this;
    }

    public TokenRealmConfigurationBuilder principalClaim(String principalClaim) {
        this.attributes.attribute(TokenRealmConfiguration.PRINCIPAL_CLAIM).set((Object)principalClaim);
        return this;
    }

    public void validate() {
        this.jwtConfiguration.validate();
        this.oauth2Configuration.validate();
        if (this.oauth2Configuration.isModified() && this.jwtConfiguration.isModified()) {
            throw new CacheConfigurationException("Cannot have both Oauth2 and JWT as validators");
        }
    }

    public TokenRealmConfiguration create() {
        return new TokenRealmConfiguration(this.jwtConfiguration.create(), this.oauth2Configuration.create(), this.attributes.protect());
    }

    public TokenRealmConfigurationBuilder read(TokenRealmConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.jwtConfiguration.read(template.jwtConfiguration(), combine);
        this.oauth2Configuration.read(template.oauth2Configuration(), combine);
        return this;
    }

    @Override
    public int compareTo(RealmProviderBuilder o) {
        return 0;
    }
}

