/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.memcached;

import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.ServerConfigurationParser;
import org.infinispan.server.configuration.memcached.Attribute;
import org.infinispan.server.configuration.memcached.Element;
import org.infinispan.server.core.configuration.EncryptionConfigurationBuilder;
import org.infinispan.server.core.security.UsernamePasswordAuthenticator;
import org.infinispan.server.core.security.sasl.SaslAuthenticator;
import org.infinispan.server.memcached.configuration.MemcachedAuthenticationConfigurationBuilder;
import org.infinispan.server.memcached.configuration.MemcachedProtocol;
import org.infinispan.server.memcached.configuration.MemcachedServerConfigurationBuilder;
import org.infinispan.server.security.ElytronSASLAuthenticator;
import org.infinispan.server.security.ElytronUsernamePasswordAuthenticator;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Namespaces(value={@Namespace(root="memcached-connector"), @Namespace(uri="urn:infinispan:server:*", root="memcached-connector")})
public class MemcachedServerConfigurationParser
implements ConfigurationParser {
    private static final Log coreLog = LogFactory.getLog(ServerConfigurationParser.class);

    public void readElement(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        if (!holder.inScope(ServerConfigurationParser.ENDPOINTS_SCOPE)) {
            throw coreLog.invalidScope(ServerConfigurationParser.ENDPOINTS_SCOPE, holder.getScope());
        }
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case MEMCACHED_CONNECTOR: {
                ServerConfigurationBuilder serverBuilder = (ServerConfigurationBuilder)builder.module(ServerConfigurationBuilder.class);
                if (serverBuilder != null) {
                    this.parseMemcached(reader, serverBuilder, serverBuilder.endpoints().current().addConnector(MemcachedServerConfigurationBuilder.class));
                    break;
                }
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
            default: {
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    private void parseMemcached(ConfigurationReader reader, ServerConfigurationBuilder serverBuilder, MemcachedServerConfigurationBuilder builder) {
        boolean dedicatedSocketBinding = false;
        String securityRealm = null;
        block15: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case CACHE: {
                    builder.defaultCacheName(value);
                    continue block15;
                }
                case CACHE_CONTAINER: {
                    continue block15;
                }
                case CLIENT_ENCODING: {
                    builder.clientEncoding(MediaType.fromString((String)value));
                    continue block15;
                }
                case IDLE_TIMEOUT: {
                    builder.idleTimeout(Integer.parseInt(value));
                    continue block15;
                }
                case IO_THREADS: {
                    builder.ioThreads(Integer.parseInt(value));
                    continue block15;
                }
                case NAME: {
                    builder.name(value);
                    continue block15;
                }
                case PROTOCOL: {
                    builder.protocol((MemcachedProtocol)ParseUtils.parseEnum((ConfigurationReader)reader, (int)i, MemcachedProtocol.class, (String)value));
                    continue block15;
                }
                case SECURITY_REALM: {
                    builder.authentication().securityRealm(value);
                    continue block15;
                }
                case SOCKET_BINDING: {
                    builder.socketBinding(value);
                    builder.startTransport(true);
                    dedicatedSocketBinding = true;
                    continue block15;
                }
                default: {
                    ServerConfigurationParser.parseCommonConnectorAttributes(reader, i, serverBuilder, builder);
                }
            }
        }
        if (!dedicatedSocketBinding) {
            ((MemcachedServerConfigurationBuilder)builder.socketBinding(serverBuilder.endpoints().current().singlePort().socketBinding())).startTransport(false);
        }
        block16: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHENTICATION: {
                    this.parseAuthentication(reader, serverBuilder, builder.authentication().enable(), securityRealm);
                    continue block16;
                }
                case ENCRYPTION: {
                    if (!dedicatedSocketBinding) {
                        throw Server.log.cannotConfigureProtocolEncryptionUnderSinglePort();
                    }
                    this.parseEncryption(reader, serverBuilder, builder.encryption(), securityRealm);
                    continue block16;
                }
            }
            ServerConfigurationParser.parseCommonConnectorElements(reader, builder);
        }
    }

    private void parseAuthentication(ConfigurationReader reader, ServerConfigurationBuilder serverBuilder, MemcachedAuthenticationConfigurationBuilder builder, String securityRealm) {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            org.infinispan.server.hotrod.configuration.Attribute attribute = org.infinispan.server.hotrod.configuration.Attribute.forName((String)reader.getAttributeName(i));
            switch (attribute) {
                case SECURITY_REALM: {
                    securityRealm = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        if (securityRealm == null) {
            securityRealm = serverBuilder.endpoints().current().securityRealm();
        }
        if (securityRealm == null) {
            throw Server.log.authenticationWithoutSecurityRealm();
        }
        builder.sasl().addMechProperty("com.sun.security.sasl.digest.realm", securityRealm);
        String serverPrincipal = null;
        block7: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SASL: {
                    serverPrincipal = ServerConfigurationParser.parseSasl(reader, builder.sasl());
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
        builder.securityRealm(securityRealm);
        builder.sasl().authenticator((SaslAuthenticator)new ElytronSASLAuthenticator(securityRealm, serverPrincipal, builder.sasl().mechanisms()));
        builder.text().authenticator((UsernamePasswordAuthenticator)new ElytronUsernamePasswordAuthenticator(securityRealm));
    }

    private void parseEncryption(ConfigurationReader reader, ServerConfigurationBuilder serverBuilder, EncryptionConfigurationBuilder encryption, String securityRealmName) {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            org.infinispan.server.configuration.rest.Attribute attribute = org.infinispan.server.configuration.rest.Attribute.forName(reader.getAttributeName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case REQUIRE_SSL_CLIENT_AUTH: {
                    encryption.requireClientAuth(Boolean.parseBoolean(value));
                    continue block4;
                }
                case SECURITY_REALM: {
                    securityRealmName = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        if (securityRealmName == null) {
            throw Server.log.encryptionWithoutSecurityRealm();
        }
        encryption.realm(securityRealmName).sslContext(serverBuilder.serverSSLContextSupplier(securityRealmName));
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }
}

