/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.datasource;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.configuration.supplier.AgroalConnectionFactoryConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalConnectionPoolConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import io.agroal.api.exceptionsorter.DB2ExceptionSorter;
import io.agroal.api.exceptionsorter.MSSQLExceptionSorter;
import io.agroal.api.exceptionsorter.MySQLExceptionSorter;
import io.agroal.api.exceptionsorter.OracleExceptionSorter;
import io.agroal.api.exceptionsorter.PostgreSQLExceptionSorter;
import io.agroal.api.exceptionsorter.SybaseExceptionSorter;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import java.security.Principal;
import java.sql.SQLException;
import java.time.Duration;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.DataSourceConfiguration;

public class DataSourceFactory {
    public static DataSource create(DataSourceConfiguration configuration) throws SQLException, ClassNotFoundException {
        AgroalConnectionFactoryConfigurationSupplier factory = new AgroalConnectionFactoryConfigurationSupplier();
        String driver = configuration.driver();
        Class driverClass = ReflectionUtil.getClassForName((String)driver, (ClassLoader)Thread.currentThread().getContextClassLoader());
        factory.connectionProviderClass(driverClass).jdbcTransactionIsolation(configuration.transactionIsolation()).jdbcUrl(configuration.url()).principal((Principal)new NamePrincipal(configuration.username())).credential((Object)new SimplePassword(configuration.password())).initialSql(configuration.initialSql());
        configuration.connectionProperties().forEach((arg_0, arg_1) -> ((AgroalConnectionFactoryConfigurationSupplier)factory).jdbcProperty(arg_0, arg_1));
        AgroalConnectionPoolConfigurationSupplier pool = new AgroalConnectionPoolConfigurationSupplier();
        pool.connectionFactoryConfiguration((Supplier)factory).maxSize(configuration.maxSize()).minSize(configuration.minSize()).initialSize(configuration.initialSize()).connectionValidator(AgroalConnectionPoolConfiguration.ConnectionValidator.defaultValidator()).idleValidationTimeout(Duration.ofMillis(configuration.validateOnAcquisition())).acquisitionTimeout(Duration.ofMillis(configuration.blockingTimeout())).validationTimeout(Duration.ofMillis(configuration.backgroundValidation())).leakTimeout(Duration.ofMillis(configuration.leakDetection())).reapTimeout(Duration.ofMinutes(configuration.idleRemoval()));
        if (driver.contains("postgresql")) {
            pool.exceptionSorter((AgroalConnectionPoolConfiguration.ExceptionSorter)new PostgreSQLExceptionSorter());
        } else if (driver.contains("mysql") || driver.contains("mariadb")) {
            pool.exceptionSorter((AgroalConnectionPoolConfiguration.ExceptionSorter)new MySQLExceptionSorter());
        } else if (driver.contains("oracle")) {
            pool.exceptionSorter((AgroalConnectionPoolConfiguration.ExceptionSorter)new OracleExceptionSorter());
        } else if (driver.contains("sqlserver")) {
            pool.exceptionSorter((AgroalConnectionPoolConfiguration.ExceptionSorter)new MSSQLExceptionSorter());
        } else if (driver.contains("db2")) {
            pool.exceptionSorter((AgroalConnectionPoolConfiguration.ExceptionSorter)new DB2ExceptionSorter());
        } else if (driver.contains("sybase")) {
            pool.exceptionSorter((AgroalConnectionPoolConfiguration.ExceptionSorter)new SybaseExceptionSorter());
        }
        AgroalDataSourceConfigurationSupplier cs = new AgroalDataSourceConfigurationSupplier();
        cs.metricsEnabled(configuration.statistics().booleanValue()).connectionPoolConfiguration((Supplier)pool);
        Server.log.dataSourceCreated(configuration.name(), configuration.jndiName());
        return AgroalDataSource.from((Supplier)cs, (AgroalDataSourceListener[])new AgroalDataSourceListener[0]);
    }
}

