/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.logging;

import java.io.IOException;
import java.io.Serializable;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.naming.NamingException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.OS;
import org.infinispan.server.core.transport.IpSubnetFilterRule;
import org.infinispan.server.logging.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.auth.server.RealmUnavailableException;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void serverStarting(String name, String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStarting$str(), (Object)name, (Object)version);
    }

    protected String serverStarting$str() {
        return "ISPN080000: %s Server %s starting";
    }

    @Override
    public final void serverStarted(String name, String version, long ms) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStarted$str(), (Object)name, (Object)version, (Object)ms);
    }

    protected String serverStarted$str() {
        return "ISPN080001: %s Server %s started in %dms";
    }

    @Override
    public final void serverStopping(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStopping$str(), (Object)name);
    }

    protected String serverStopping$str() {
        return "ISPN080002: %s Server stopping";
    }

    @Override
    public final void serverStopped(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStopped$str(), (Object)name);
    }

    protected String serverStopped$str() {
        return "ISPN080003: %s Server stopped";
    }

    @Override
    public final void protocolStarted(String name, String socketBinding, String host, int port) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.protocolStarted4$str(), new Object[]{name, socketBinding, host, port});
    }

    protected String protocolStarted4$str() {
        return "ISPN080004: Connector %s (%s) listening on %s:%d";
    }

    protected String cannotInstantiateProtocolServerConfigurationBuilder$str() {
        return "ISPN080008: Cannot instantiate protocol server configuration '%s'";
    }

    @Override
    public final CacheConfigurationException cannotInstantiateProtocolServerConfigurationBuilder(Class<?> klass, Exception e) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.cannotInstantiateProtocolServerConfigurationBuilder$str(), klass), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String unknownInterface$str() {
        return "ISPN080009: Unknown interface '%s'";
    }

    @Override
    public final CacheConfigurationException unknownInterface(String interfaceName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unknownInterface$str(), interfaceName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownSocketBinding$str() {
        return "ISPN080010: Unknown socket binding '%s'";
    }

    @Override
    public final CacheConfigurationException unknownSocketBinding(String value) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unknownSocketBinding$str(), value));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownSecurityDomain$str() {
        return "ISPN080014: Unknown security domain '%s'";
    }

    @Override
    public final CacheConfigurationException unknownSecurityDomain(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unknownSecurityDomain$str(), name));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToLoadRealmPropertyFiles$str() {
        return "ISPN080015: Unable to load realm property files";
    }

    @Override
    public final CacheConfigurationException unableToLoadRealmPropertyFiles(IOException e) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unableToLoadRealmPropertyFiles$str(), new Object[0]), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noDefaultKeyManager$str() {
        return "ISPN080016: No default key manager available";
    }

    @Override
    public final NoSuchAlgorithmException noDefaultKeyManager() {
        NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(this.getLoggingLocale(), this.noDefaultKeyManager$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void serverConfiguration(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverConfiguration$str(), (Object)name);
    }

    protected String serverConfiguration$str() {
        return "ISPN080017: Server configuration: %s";
    }

    @Override
    public final void protocolStarted(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.protocolStarted1$str(), (Object)name);
    }

    protected String protocolStarted1$str() {
        return "ISPN080018: Started connector %s (internal)";
    }

    protected String authenticationWithoutSecurityRealm$str() {
        return "ISPN080021: Authentication cannot be configured without a security realm";
    }

    @Override
    public final CacheConfigurationException authenticationWithoutSecurityRealm() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.authenticationWithoutSecurityRealm$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotConfigureProtocolEncryptionUnderSinglePort$str() {
        return "ISPN080022: Cannot configure protocol encryption under a single port endpoint. Use a dedicated socket binding.";
    }

    @Override
    public final CacheConfigurationException cannotConfigureProtocolEncryptionUnderSinglePort() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.cannotConfigureProtocolEncryptionUnderSinglePort$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String protocolCannotUseSameSocketBindingAsEndpoint$str() {
        return "ISPN080023: Cannot configure a protocol with the same socket binding used by the endpoint. Use a dedicated socket binding.";
    }

    @Override
    public final CacheConfigurationException protocolCannotUseSameSocketBindingAsEndpoint() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.protocolCannotUseSameSocketBindingAsEndpoint$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidUrl$str() {
        return "ISPN080024: Invalid URL: '%s'";
    }

    @Override
    public final CacheConfigurationException invalidUrl(String url) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidUrl$str(), url));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multipleEndpointsSameTypeFound$str() {
        return "ISPN080025: Cannot have multiple connectors of the same type: found [%s]";
    }

    @Override
    public final CacheConfigurationException multipleEndpointsSameTypeFound(String names) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.multipleEndpointsSameTypeFound$str(), names));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void unnamedFactoryClass(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unnamedFactoryClass$str(), (Object)name);
    }

    protected String unnamedFactoryClass$str() {
        return "ISPN080026: Extension factory '%s' is lacking a @NamedFactory annotation";
    }

    @Override
    public final void loadedExtension(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.loadedExtension$str(), (Object)name);
    }

    protected String loadedExtension$str() {
        return "ISPN080027: Loaded extension '%s'";
    }

    @Override
    public final void serverFailedToStart(String name, Throwable t) {
        this.log.logf(FQCN, Logger.Level.FATAL, t, this.serverFailedToStart$str(), (Object)name);
    }

    protected String serverFailedToStart$str() {
        return "ISPN080028: %s Server failed to start";
    }

    @Override
    public final void clusterShutdown() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.clusterShutdown$str(), new Object[0]);
    }

    protected String clusterShutdown$str() {
        return "ISPN080029: Cluster shutdown";
    }

    @Override
    public final void clusteredTaskError(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.clusteredTaskError$str(), new Object[0]);
    }

    protected String clusteredTaskError$str() {
        return "ISPN080030: Clustered task error";
    }

    protected String unknownServerIdentity$str() {
        return "ISPN080031: Unknown server identity '%s'";
    }

    @Override
    public final IllegalArgumentException unknownServerIdentity(String serverPrincipal) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownServerIdentity$str(), serverPrincipal));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void loggingConfiguration(String absolutePath) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.loggingConfiguration$str(), (Object)absolutePath);
    }

    protected String loggingConfiguration$str() {
        return "ISPN080032: Logging configuration: %s";
    }

    protected String invalidNetworkConfiguration$str() {
        return "ISPN080033: Cannot find a network address which matches the supplied configuration";
    }

    @Override
    public final CacheConfigurationException invalidNetworkConfiguration() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidNetworkConfiguration$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void endpointUrl(Object name, String proto, String host, int port) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.endpointUrl$str(), new Object[]{name, proto, host, port});
    }

    protected String endpointUrl$str() {
        return "ISPN080034: Server '%s' listening on %s://%s:%d";
    }

    protected String unknownAppender$str() {
        return "ISPN080035: Unknown appender `%s`";
    }

    @Override
    public final IllegalArgumentException unknownAppender(String appender) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownAppender$str(), appender));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidLevel$str() {
        return "ISPN080036: Invalid level `%s`";
    }

    @Override
    public final IllegalArgumentException invalidLevel(String level) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidLevel$str(), level));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nameAlreadyBound$str() {
        return "ISPN080037: The name '%s' is already bound";
    }

    @Override
    public final NamingException nameAlreadyBound(String name) {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.nameAlreadyBound$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void dataSourceCreated(String name, String jndiName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.dataSourceCreated$str(), (Object)name, (Object)jndiName);
    }

    protected String dataSourceCreated$str() {
        return "ISPN080038: Created datasource '%s' bound to JNDI '%s'";
    }

    protected String noRealmFoundInProperties$str() {
        return "ISPN080040: No realm name found in users property file - non-plain-text users file must contain \"#$REALM_NAME=RealmName$\" line";
    }

    @Override
    public final RealmUnavailableException noRealmFoundInProperties() {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.noRealmFoundInProperties$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String duplicateDataSource$str() {
        return "ISPN080041: Duplicate data source '%s'";
    }

    @Override
    public final CacheConfigurationException duplicateDataSource(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateDataSource$str(), name));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String duplicateJndiName$str() {
        return "ISPN080042: Duplicate JNDI name '%s'";
    }

    @Override
    public final CacheConfigurationException duplicateJndiName(String jndiName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateJndiName$str(), jndiName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String serverReportUnavailable$str() {
        return "ISPN080043: Cannot generate the server report on %s";
    }

    @Override
    public final IllegalStateException serverReportUnavailable(OS os) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serverReportUnavailable$str(), os));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void warnHotRodLazyRetrievalDeprecated() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnHotRodLazyRetrievalDeprecated$str(), new Object[0]);
    }

    protected String warnHotRodLazyRetrievalDeprecated$str() {
        return "ISPN080044: HotRod lazy-retrieval has been deprecated and will be removed in a future version with no direct replacement";
    }

    @Override
    public final void endpointSocketBindingOverride(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.endpointSocketBindingOverride$str(), (Object)name);
    }

    protected String endpointSocketBindingOverride$str() {
        return "ISPN080045: Overriding existing endpoint on socket-binding '%s'";
    }

    protected String unknownCredentialStore$str() {
        return "ISPN080046: Unknown credential store '%s'";
    }

    @Override
    public final IllegalArgumentException unknownCredentialStore(String store) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownCredentialStore$str(), store));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownCredential$str() {
        return "ISPN080047: Unknown credential '%s' in store '%s'";
    }

    @Override
    public final IllegalArgumentException unknownCredential(String alias, String store) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownCredential$str(), alias, store));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingCredentialStoreName$str() {
        return "ISPN080048: A credential store name is missing";
    }

    @Override
    public final IllegalArgumentException missingCredentialStoreName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.missingCredentialStoreName$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unspecifiedCredentialAlias$str() {
        return "ISPN080049: A credential alias must be specified if the store doesn't contain a single alias";
    }

    @Override
    public final CacheConfigurationException unspecifiedCredentialAlias() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unspecifiedCredentialAlias$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotOverrideCredential$str() {
        return "ISPN080050: Credential reference in element '%s' would override value specified in attribute '%s'";
    }

    @Override
    public final CacheConfigurationException cannotOverrideCredential(String element, String attribute) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.cannotOverrideCredential$str(), element, attribute));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingCredential$str() {
        return "ISPN080051: Element '%s' is missing a credential attribute '%s' or a credential reference";
    }

    @Override
    public final CacheConfigurationException missingCredential(String element, String attribute) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingCredential$str(), element, attribute));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedMechanism$str() {
        return "ISPN080052: The request authentication mechanism '%s' is not supported";
    }

    @Override
    public final SecurityException unsupportedMechanism(String mechName) {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.unsupportedMechanism$str(), mechName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String encryptionWithoutSecurityRealm$str() {
        return "ISPN080053: Encryption cannot be configured without a security realm";
    }

    @Override
    public final CacheConfigurationException encryptionWithoutSecurityRealm() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.encryptionWithoutSecurityRealm$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noDefaultTrustManager$str() {
        return "ISPN080054: No default trust manager available";
    }

    @Override
    public final CacheConfigurationException noDefaultTrustManager() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.noDefaultTrustManager$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void connectorIpFilterSet(String connector, List<IpSubnetFilterRule> rules) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.connectorIpFilterSet$str(), (Object)connector, rules);
    }

    protected String connectorIpFilterSet$str() {
        return "ISPN080055: Connector '%s': IP filter set: %s";
    }

    @Override
    public final void connectorIpFilterCleared(String connector) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.connectorIpFilterCleared$str(), (Object)connector);
    }

    protected String connectorIpFilterCleared$str() {
        return "ISPN080056: Connector '%s': IP filter cleared";
    }

    @Override
    public final void connectorStopped(String connector) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.connectorStopped$str(), (Object)connector);
    }

    protected String connectorStopped$str() {
        return "ISPN080057: Connector '%s': stopped";
    }

    @Override
    public final void connectorStarted(String connector) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.connectorStarted$str(), (Object)connector);
    }

    protected String connectorStarted$str() {
        return "ISPN080058: Connector '%s': started";
    }

    @Override
    public final void noScriptEngines() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noScriptEngines$str(), new Object[0]);
    }

    protected String noScriptEngines$str() {
        return "ISPN080059: No script engines are available";
    }

    @Override
    public final void sslTransport(String value) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.sslTransport$str(), (Object)value);
    }

    protected String sslTransport$str() {
        return "ISPN080060: SSL Transport using realm '%s`";
    }

    protected String noSSLContext$str() {
        return "ISPN080061: Realm '%s' does not provide an SSL context";
    }

    @Override
    public final IllegalStateException noSSLContext(String realm) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noSSLContext$str(), realm));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateRealmType$str() {
        return "ISPN080062: Cannot add multiple realms of type '%s' to security realm '%s'";
    }

    @Override
    public final CacheConfigurationException duplicateRealmType(String type, String realm) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateRealmType$str(), type, realm));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String duplicateRealm$str() {
        return "ISPN080063: Duplicate realm '%s'";
    }

    @Override
    public final CacheConfigurationException duplicateRealm(String realmName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateRealm$str(), realmName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownRealm$str() {
        return "ISPN080064: Unknown realm '%s'";
    }

    @Override
    public final CacheConfigurationException unknownRealm(String realmName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unknownRealm$str(), realmName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidKeyStore$str() {
        return "ISPN080065: Invalid keystore '%s'";
    }

    @Override
    public final KeyStoreException invalidKeyStore(String filename) {
        KeyStoreException result = new KeyStoreException(String.format(this.getLoggingLocale(), this.invalidKeyStore$str(), filename));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String filelessKeyStoreRequiresType$str() {
        return "ISPN080066: KeyStore definitions without a path must specify a type.";
    }

    @Override
    public final CacheConfigurationException filelessKeyStoreRequiresType() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.filelessKeyStoreRequiresType$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String respEndpointRequiresRealmWithPasswordOrTrustore$str() {
        return "ISPN080067: The RESP endpoint requires a security realm which supports passwords or a trustore realm.";
    }

    @Override
    public final CacheConfigurationException respEndpointRequiresRealmWithPasswordOrTrustore() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.respEndpointRequiresRealmWithPasswordOrTrustore$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String wrongMaskedPasswordFormat$str() {
        return "ISPN080068: Wrong masked password format";
    }

    @Override
    public final CacheConfigurationException wrongMaskedPasswordFormat() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.wrongMaskedPasswordFormat$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String aliasNotInKeystore$str() {
        return "ISPN080069: Alias '%s' not in keystore '%s'";
    }

    @Override
    public final CacheConfigurationException aliasNotInKeystore(String alias, String keystore) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.aliasNotInKeystore$str(), alias, keystore));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String authorizationWithoutAuthentication$str() {
        return "ISPN080070: The cache container requires authorization, but none of the connectors enable authentication";
    }

    @Override
    public final CacheConfigurationException authorizationWithoutAuthentication() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.authorizationWithoutAuthentication$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String ldapDirectVerificationWithoutUserMapper$str() {
        return "ISPN080071: A user mapper must be configured in order to use LDAP direct verification";
    }

    @Override
    public final CacheConfigurationException ldapDirectVerificationWithoutUserMapper() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.ldapDirectVerificationWithoutUserMapper$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void jmxNoDefaultSecurityRealm() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.jmxNoDefaultSecurityRealm$str(), new Object[0]);
    }

    protected String jmxNoDefaultSecurityRealm$str() {
        return "ISPN080072: JMX remoting enabled without a default security realm. All connections will be rejected.";
    }

    @Override
    public final void jmxAuthenticationError(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.jmxAuthenticationError$str(), new Object[0]);
    }

    protected String jmxAuthenticationError$str() {
        return "ISPN080073: JMX authentication error";
    }

    protected String memcachedTextEndpointRequiresRealmWithPassword$str() {
        return "ISPN080074: The Memcached endpoint text protocol requires a security realm which supports passwords.";
    }

    @Override
    public final CacheConfigurationException memcachedTextEndpointRequiresRealmWithPassword() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.memcachedTextEndpointRequiresRealmWithPassword$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void serverCertificateWithoutSAN(String keyStoreFileName, String alias) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.serverCertificateWithoutSAN$str(), (Object)keyStoreFileName, (Object)alias);
    }

    protected String serverCertificateWithoutSAN$str() {
        return "ISPN080075: The '%2$s' certificate in keystore '%1$s' does not have the subjectAltName extension as recommended by RFC2818.";
    }

    protected String malformedUserProperties$str() {
        return "ISPN080076: Malformed entry in user properties file at line %d";
    }

    @Override
    public final IllegalStateException malformedUserProperties(int line) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.malformedUserProperties$str(), line));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

