/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.datasource;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.configuration.supplier.AgroalConnectionFactoryConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalConnectionPoolConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import java.security.Principal;
import java.sql.SQLException;
import java.time.Duration;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.DataSourceConfiguration;

public class DataSourceFactory {
    public static DataSource create(DataSourceConfiguration configuration) throws SQLException, ClassNotFoundException {
        AgroalConnectionFactoryConfigurationSupplier factory = new AgroalConnectionFactoryConfigurationSupplier();
        Class driverClass = ReflectionUtil.getClassForName((String)configuration.driver(), (ClassLoader)Thread.currentThread().getContextClassLoader());
        factory.connectionProviderClass(driverClass).jdbcTransactionIsolation(configuration.transactionIsolation()).jdbcUrl(configuration.url()).principal((Principal)new NamePrincipal(configuration.username())).credential((Object)new SimplePassword(configuration.password())).initialSql(configuration.initialSql());
        configuration.connectionProperties().forEach((arg_0, arg_1) -> ((AgroalConnectionFactoryConfigurationSupplier)factory).jdbcProperty(arg_0, arg_1));
        AgroalConnectionPoolConfigurationSupplier pool = new AgroalConnectionPoolConfigurationSupplier();
        pool.connectionFactoryConfiguration((Supplier)factory).maxSize(configuration.maxSize()).minSize(configuration.minSize()).initialSize(configuration.initialSize()).acquisitionTimeout(Duration.ofMillis(configuration.blockingTimeout())).validationTimeout(Duration.ofMillis(configuration.backgroundValidation())).leakTimeout(Duration.ofMillis(configuration.leakDetection())).reapTimeout(Duration.ofMinutes(configuration.idleRemoval()));
        AgroalDataSourceConfigurationSupplier cs = new AgroalDataSourceConfigurationSupplier();
        cs.metricsEnabled(configuration.statistics().booleanValue()).connectionPoolConfiguration((Supplier)pool);
        Server.log.dataSourceCreated(configuration.name(), configuration.jndiName());
        return AgroalDataSource.from((Supplier)cs, (AgroalDataSourceListener[])new AgroalDataSourceListener[0]);
    }
}

