/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.server.configuration.AddressType;

class AddressConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<String> VALUE = AttributeDefinition.builder((String)"value", null, String.class).build();
    private final ElementDefinition<ConfigurationInfo> elementDefinition;
    private final AttributeSet attributes;
    private final AddressType addressType;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AddressConfiguration.class, new AttributeDefinition[]{VALUE});
    }

    AddressConfiguration(AttributeSet attributes, AddressType addressType) {
        this.attributes = attributes.checkProtection();
        this.addressType = addressType;
        this.elementDefinition = new DefaultElementDefinition(addressType.displayName(), true, false);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return this.elementDefinition;
    }

    AddressType addressType() {
        return this.addressType;
    }

    public String value() {
        return (String)this.attributes.attribute(VALUE).get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressConfiguration that = (AddressConfiguration)o;
        if (!this.attributes.equals((Object)that.attributes)) {
            return false;
        }
        return this.addressType == that.addressType;
    }

    public int hashCode() {
        int result = this.attributes.hashCode();
        result = 31 * result + this.addressType.hashCode();
        return result;
    }

    public String toString() {
        return "AddressConfiguration{attributes=" + this.attributes + ", addressType=" + (Object)((Object)this.addressType) + '}';
    }
}

