/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.logging;

import java.lang.invoke.MethodHandles;
import org.infinispan.server.router.RoutingTable;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="ISPN")
@ValidIdRange(min=15001, max=16000)
public interface Log
extends BasicLogger {
    public static final Log SERVER = (Log)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), Log.class, (String)"org.infinispan.SERVER");

    public static Log getLog(Class<?> clazz) {
        return (Log)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), Log.class, (String)clazz.getName());
    }

    @Message(value="Could not find matching route", id=15002)
    public IllegalArgumentException noRouteFound();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Routing table: %s", id=15005)
    public void printOutRoutingTable(RoutingTable var1);

    @Message(value="Configuration validation error", id=15007)
    public IllegalStateException configurationValidationError(@Cause Exception var1);

    @Message(value="Unable to start HotRod router", id=15008)
    public IllegalStateException hotrodRouterStartFailed(@Cause Exception var1);

    @Message(value="Unable to start REST router", id=15009)
    public IllegalStateException restRouterStartFailed(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while shutting down the router", id=15010)
    public void errorWhileShuttingDown(@Cause Exception var1);
}

