package org.infinispan.server.router.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.infinispan.server.router.RoutingTable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.lang.Exception;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String noRouteFound$str() {
        return "ISPN015002: Could not find matching route";
    }
    @Override
    public final IllegalArgumentException noRouteFound() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noRouteFound$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void printOutRoutingTable(final RoutingTable routingTable) {
        super.log.logf(FQCN, INFO, null, printOutRoutingTable$str(), routingTable);
    }
    protected String printOutRoutingTable$str() {
        return "ISPN015005: Routing table: %s";
    }
    protected String configurationValidationError$str() {
        return "ISPN015007: Configuration validation error";
    }
    @Override
    public final IllegalStateException configurationValidationError(final Exception e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), configurationValidationError$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String hotrodRouterStartFailed$str() {
        return "ISPN015008: Unable to start HotRod router";
    }
    @Override
    public final IllegalStateException hotrodRouterStartFailed(final Exception e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), hotrodRouterStartFailed$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String restRouterStartFailed$str() {
        return "ISPN015009: Unable to start REST router";
    }
    @Override
    public final IllegalStateException restRouterStartFailed(final Exception e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), restRouterStartFailed$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void errorWhileShuttingDown(final Exception e) {
        super.log.logf(FQCN, ERROR, e, errorWhileShuttingDown$str());
    }
    protected String errorWhileShuttingDown$str() {
        return "ISPN015010: Error while shutting down the router";
    }
}
