/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.operations.mediatypes;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.rest.operations.mediatypes.OutputPrinter;
import org.infinispan.rest.operations.mediatypes.impl.BinaryOutputPrinter;
import org.infinispan.rest.operations.mediatypes.impl.JSONOutputPrinter;
import org.infinispan.rest.operations.mediatypes.impl.TextOutputPrinter;
import org.infinispan.rest.operations.mediatypes.impl.XMLOutputPrinter;

public class EntrySetFormatter {
    private static Map<String, OutputPrinter> printerByMediaType = new HashMap<String, OutputPrinter>(10);

    public static OutputPrinter forMediaType(MediaType mediaType) {
        return printerByMediaType.get(mediaType.getTypeSubtype());
    }

    static {
        TextOutputPrinter textOutputPrinter = new TextOutputPrinter();
        XMLOutputPrinter xmlOutputPrinter = new XMLOutputPrinter();
        JSONOutputPrinter jsonOutputPrinter = new JSONOutputPrinter();
        BinaryOutputPrinter binaryOutputPrinter = new BinaryOutputPrinter();
        printerByMediaType.put("text/plain", textOutputPrinter);
        printerByMediaType.put("application/xml", xmlOutputPrinter);
        printerByMediaType.put("application/json", jsonOutputPrinter);
        printerByMediaType.put("application/octet-stream", binaryOutputPrinter);
        printerByMediaType.put("image/png", binaryOutputPrinter);
        printerByMediaType.put("application/x-java-serialized-object", binaryOutputPrinter);
        printerByMediaType.put("*/*", textOutputPrinter);
    }
}

