/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.security.auth.Subject;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalAuthorizationConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.resources.ResourceUtil;
import org.infinispan.security.AuditContext;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.MutablePrincipalRoleMapper;
import org.infinispan.security.MutableRolePermissionMapper;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Role;
import org.infinispan.security.RolePermissionMapper;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.security.impl.Authorizer;
import org.infinispan.security.impl.CacheRoleImpl;
import org.infinispan.security.impl.SubjectACL;
import org.infinispan.security.mappers.ClusterRoleMapper;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.ServerManagement;

public class SecurityResource
implements ResourceHandler {
    private final InvocationHelper invocationHelper;
    private final String accessGrantedPath;
    private final MutablePrincipalRoleMapper principalRoleMapper;
    private final MutableRolePermissionMapper rolePermissionMapper;

    public SecurityResource(InvocationHelper invocationHelper, String accessGrantedPath, String accessDeniedPath) {
        this.invocationHelper = invocationHelper;
        this.accessGrantedPath = accessGrantedPath;
        GlobalConfiguration globalConfiguration = SecurityActions.getCacheManagerConfiguration((EmbeddedCacheManager)invocationHelper.getRestCacheManager().getInstance());
        PrincipalRoleMapper mapper = globalConfiguration.security().authorization().principalRoleMapper();
        this.principalRoleMapper = mapper instanceof MutablePrincipalRoleMapper ? (MutablePrincipalRoleMapper)mapper : null;
        RolePermissionMapper permissionMapper = globalConfiguration.security().authorization().rolePermissionMapper();
        this.rolePermissionMapper = permissionMapper instanceof MutableRolePermissionMapper ? (MutableRolePermissionMapper)permissionMapper : null;
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET).path("/v2/login").withAction("config").anonymous().handleWith(this::loginConfiguration).invocation().methods(Method.GET, Method.POST).deprecated().path("/v2/login").withAction("login").permission(AuthorizationPermission.NONE).name("USER LOGIN").auditContext(AuditContext.SERVER).handleWith(this::login).invocation().methods(Method.GET).deprecated().path("/v2/login").permission(AuthorizationPermission.NONE).name("USER LOGIN").auditContext(AuditContext.SERVER).handleWith(this::login).invocation().methods(Method.GET).path("/v2/security/user/acl").handleWith(this::acl).invocation().method(Method.GET).path("/v2/security/roles").permission(AuthorizationPermission.ADMIN).name("ROLES").auditContext(AuditContext.SERVER).handleWith(r -> this.listAllRoles((RestRequest)r, false)).invocation().method(Method.GET).path("/v2/security/roles").withAction("detailed").permission(AuthorizationPermission.ADMIN).name("ROLES DESCRIBE").auditContext(AuditContext.SERVER).handleWith(r -> this.listAllRoles((RestRequest)r, true)).invocation().method(Method.GET).path("/v2/security/roles/{principal}").permission(AuthorizationPermission.ADMIN).name("ROLES PRINCIPAL").auditContext(AuditContext.SERVER).handleWith(this::listPrincipalRoles).invocation().method(Method.POST).path("/v2/security/roles/{principal}").withAction("grant").permission(AuthorizationPermission.ADMIN).name("ROLES GRANT NEW").auditContext(AuditContext.SERVER).handleWith(r -> this.grant((RestRequest)r, true)).invocation().method(Method.PUT).path("/v2/security/roles/{principal}").withAction("grant").permission(AuthorizationPermission.ADMIN).name("ROLES GRANT").auditContext(AuditContext.SERVER).handleWith(r -> this.grant((RestRequest)r, false)).invocation().method(Method.PUT).path("/v2/security/roles/{principal}").withAction("deny").permission(AuthorizationPermission.ADMIN).name("ROLES DENY").auditContext(AuditContext.SERVER).handleWith(r -> this.deny((RestRequest)r, false)).invocation().method(Method.DELETE).path("/v2/security/roles/{principal}").withAction("grant").permission(AuthorizationPermission.ADMIN).name("ROLES DENY ALL").auditContext(AuditContext.SERVER).handleWith(r -> this.deny((RestRequest)r, true)).invocation().methods(Method.GET).path("/v2/security/users").permission(AuthorizationPermission.ADMIN).name("USERS LIST").auditContext(AuditContext.SERVER).handleWith(this::listUsers).invocation().method(Method.GET).path("/v2/security/principals").withAction("detailed").permission(AuthorizationPermission.ADMIN).name("ACCESS PRINCIPALS").auditContext(AuditContext.SERVER).handleWith(r -> this.listAllPrincipals((RestRequest)r, true)).invocation().method(Method.GET).path("/v2/security/principals").permission(AuthorizationPermission.ADMIN).name("ACCESS PRINCIPALS").auditContext(AuditContext.SERVER).handleWith(r -> this.listAllPrincipals((RestRequest)r, false)).invocation().methods(Method.POST).path("/v2/security/permissions/{role}").permission(AuthorizationPermission.ADMIN).name("ROLES CREATE").auditContext(AuditContext.SERVER).handleWith(this::createRole).invocation().methods(Method.PUT).path("/v2/security/permissions/{role}").permission(AuthorizationPermission.ADMIN).name("ROLES UPDATE").auditContext(AuditContext.SERVER).handleWith(this::updateRole).invocation().methods(Method.GET).path("/v2/security/permissions/{role}").permission(AuthorizationPermission.ADMIN).name("ROLES DESCRIBE").auditContext(AuditContext.SERVER).handleWith(this::describeRole).invocation().method(Method.DELETE).path("/v2/security/permissions/{role}").permission(AuthorizationPermission.ADMIN).name("ROLES DELETE").auditContext(AuditContext.SERVER).handleWith(this::deleteRole).invocation().method(Method.POST).path("/v2/security/cache").withAction("flush").permission(AuthorizationPermission.ADMIN).name("ACL CACHE FLUSH").auditContext(AuditContext.SERVER).handleWith(this::aclCacheFlush).create();
    }

    private CompletionStage<RestResponse> listUsers(RestRequest request) {
        Json principals = Json.make((Object)this.invocationHelper.getServer().getUsers());
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), principals, ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> createRole(RestRequest request) {
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
        if (this.rolePermissionMapper == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.CONFLICT).entity(Log.REST.rolePermissionMapperNotMutable()).build());
        }
        String name = request.variables().get("role");
        if (this.rolePermissionMapper.getAllRoles().containsKey(name)) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.CONFLICT).entity(Log.REST.roleAlreadyExists()).build());
        }
        List<String> perms = request.parameters().get("permission");
        if (perms == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.BAD_REQUEST).build());
        }
        Set permissions = perms.stream().map(p -> AuthorizationPermission.valueOf((String)p.toUpperCase())).collect(Collectors.toSet());
        CacheRoleImpl role = new CacheRoleImpl(name, request.contents().asString(), false, true, permissions);
        return this.rolePermissionMapper.addRole((Role)role).thenCompose(ignore -> this.aclCacheFlush(request));
    }

    private CompletionStage<RestResponse> updateRole(RestRequest request) {
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
        if (this.rolePermissionMapper == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.CONFLICT).entity(Log.REST.rolePermissionMapperNotMutable()).build());
        }
        String name = request.variables().get("role");
        Role existingRole = (Role)this.rolePermissionMapper.getAllRoles().get(name);
        if (existingRole == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.NOT_FOUND).build());
        }
        if (existingRole.isImplicit()) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.BAD_REQUEST).entity(Log.REST.predefinedRolesAreNotMutable()).build());
        }
        List<String> perms = request.parameters().get("permission");
        Set<Object> rolePermissions = perms != null ? perms.stream().map(p -> AuthorizationPermission.valueOf((String)p.toUpperCase())).collect(Collectors.toSet()) : new HashSet(existingRole.getPermissions());
        String description = existingRole.getDescription();
        String requestDescription = request.contents().asString();
        if (requestDescription != null && !requestDescription.isEmpty()) {
            description = requestDescription;
        }
        CacheRoleImpl role = new CacheRoleImpl(existingRole.getName(), description, false, true, rolePermissions);
        return this.rolePermissionMapper.addRole((Role)role).thenCompose(ignore -> this.aclCacheFlush(request));
    }

    private CompletionStage<RestResponse> describeRole(RestRequest request) {
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
        if (this.rolePermissionMapper == null) {
            return CompletableFuture.completedFuture(this.invocationHelper.newResponse(request).status(HttpResponseStatus.CONFLICT).entity(Log.REST.rolePermissionMapperNotMutable()).build());
        }
        String name = request.variables().get("role");
        GlobalAuthorizationConfiguration authorization = this.invocationHelper.getRestCacheManager().getInstance().getCacheManagerConfiguration().security().authorization();
        Role role = authorization.getRole(name);
        if (role == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.NOT_FOUND).build());
        }
        Json json = new RoleJson(role).toJson();
        json.set("name", (Object)name);
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), json, ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> listAllPrincipals(RestRequest request, boolean detailed) {
        if (!detailed) {
            return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), Json.make((Object)this.principalRoleMapper.listPrincipals()), ResourceUtil.isPretty(request));
        }
        Set entries = this.principalRoleMapper.listPrincipalsAndRoleSet();
        Json json = Json.object();
        entries.stream().forEach(e -> json.set((String)e.getKey(), (Object)((ClusterRoleMapper.RoleSet)e.getValue()).getRoles()));
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), json, ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> deleteRole(RestRequest request) {
        if (this.rolePermissionMapper == null) {
            return CompletableFuture.completedFuture(this.invocationHelper.newResponse(request).status(HttpResponseStatus.CONFLICT).entity(Log.REST.rolePermissionMapperNotMutable()).build());
        }
        String role = request.variables().get("role");
        return this.rolePermissionMapper.removeRole(role).thenCompose(ignore -> this.aclCacheFlush(request));
    }

    private CompletionStage<RestResponse> aclCacheFlush(RestRequest request) {
        ServerManagement server = this.invocationHelper.getServer();
        return server.flushSecurityCaches().thenApply(v -> this.invocationHelper.newResponse(request).status(HttpResponseStatus.NO_CONTENT).build());
    }

    private CompletionStage<RestResponse> deny(RestRequest request, boolean all) {
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
        if (this.principalRoleMapper == null) {
            return CompletableFuture.completedFuture(this.invocationHelper.newResponse(request).status(HttpResponseStatus.CONFLICT).entity(Log.REST.principalRoleMapperNotMutable()).build());
        }
        String principal = request.variables().get("principal");
        if (all) {
            this.principalRoleMapper.denyAll(principal);
            return this.aclCacheFlush(request);
        }
        List<String> roles = request.parameters().get("role");
        if (roles == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.BAD_REQUEST).build());
        }
        return CompletionStages.performSequentially(roles.iterator(), r -> CompletableFuture.runAsync(() -> this.principalRoleMapper.deny(r, principal), this.invocationHelper.getExecutor())).thenCompose(ignore -> this.aclCacheFlush(request));
    }

    private CompletionStage<RestResponse> grant(RestRequest request, boolean newAccess) {
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
        if (this.principalRoleMapper == null) {
            return CompletableFuture.completedFuture(this.invocationHelper.newResponse(request).status(HttpResponseStatus.CONFLICT).entity(Log.REST.principalRoleMapperNotMutable()).build());
        }
        String principal = request.variables().get("principal");
        List<String> roles = request.parameters().get("role");
        if (roles == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.BAD_REQUEST).build());
        }
        if (newAccess && this.principalRoleMapper.listPrincipalsAndRoleSet().contains(principal)) {
            return CompletableFuture.completedFuture(this.invocationHelper.newResponse(request).status(HttpResponseStatus.CONFLICT).build());
        }
        if (newAccess && this.containsPrincipalName(principal)) {
            return CompletableFuture.completedFuture(this.invocationHelper.newResponse(request).status(HttpResponseStatus.CONFLICT).build());
        }
        return CompletionStages.performSequentially(roles.iterator(), r -> CompletableFuture.runAsync(() -> this.principalRoleMapper.grant(r, principal), this.invocationHelper.getExecutor())).thenCompose(ignore -> this.aclCacheFlush(request));
    }

    private boolean containsPrincipalName(String principal) {
        Map users = this.invocationHelper.getServer().getUsers();
        for (List principals : users.values()) {
            for (Principal p : principals) {
                if (!p.getName().equals(principal)) continue;
                return true;
            }
        }
        return false;
    }

    private CompletionStage<RestResponse> listAllRoles(RestRequest request, boolean detailed) {
        Json roles;
        GlobalAuthorizationConfiguration authorization = this.invocationHelper.getRestCacheManager().getInstance().getCacheManagerConfiguration().security().authorization();
        if (!authorization.enabled()) {
            throw Log.REST.authorizationNotEnabled();
        }
        Stream<Map.Entry> rolesStream = authorization.roles().entrySet().stream().filter(e -> ((Role)e.getValue()).isInheritable());
        if (detailed) {
            roles = Json.object();
            rolesStream.forEach(e -> roles.set((String)e.getKey(), new RoleJson((Role)e.getValue()).toJson()));
        } else {
            roles = Json.array();
            rolesStream.forEach(e -> roles.add(e.getKey()));
        }
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), roles, ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> listPrincipalRoles(RestRequest request) {
        String principal = request.variables().get("principal");
        if (this.principalRoleMapper == null) {
            return CompletableFuture.completedFuture(this.invocationHelper.newResponse(request).status(HttpResponseStatus.CONFLICT).entity(Log.REST.principalRoleMapperNotMutable()).build());
        }
        Json roles = Json.array();
        this.principalRoleMapper.list(principal).forEach(arg_0 -> ((Json)roles).add(arg_0));
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), roles, ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> acl(RestRequest request) {
        Subject subject = request.getSubject();
        RestCacheManager<Object> rcm = this.invocationHelper.getRestCacheManager();
        Collection<String> cacheNames = rcm.getCacheNames();
        Json acl = Json.object();
        if (subject == null) {
            acl.set("subject", Json.array());
        } else {
            Json jsonSubjects = Json.array();
            subject.getPrincipals().forEach(principal -> jsonSubjects.add(Json.object().set("name", (Object)principal.getName()).set("type", (Object)principal.getClass().getSimpleName())));
            acl.set("subject", jsonSubjects);
            Authorizer authorizer = rcm.getAuthorizer();
            SubjectACL globalACL = authorizer.getACL(subject);
            acl.set("global", this.aclToJson(globalACL));
            Json caches = Json.object();
            acl.set("caches", caches);
            for (String cacheName : cacheNames) {
                Configuration cacheConfiguration = SecurityActions.getCacheConfiguration((EmbeddedCacheManager)rcm.getInstance(), (String)cacheName);
                SubjectACL cacheACL = authorizer.getACL(subject, cacheConfiguration.security().authorization());
                caches.set(cacheName, this.aclToJson(cacheACL));
            }
        }
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), acl, ResourceUtil.isPretty(request));
    }

    private Json aclToJson(SubjectACL acl) {
        Json array = Json.array();
        for (AuthorizationPermission permission : acl.getPermissions()) {
            array.add((Object)permission.name());
        }
        return array;
    }

    private CompletionStage<RestResponse> loginConfiguration(RestRequest request) {
        Map loginConfiguration = this.invocationHelper.getServer().getLoginConfiguration((ProtocolServer)this.invocationHelper.getProtocolServer());
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), Json.make((Object)loginConfiguration), ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> login(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        responseBuilder.status(HttpResponseStatus.TEMPORARY_REDIRECT).header("Location", this.accessGrantedPath);
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private static class RoleJson
    implements JsonSerialization {
        private final Role role;

        public RoleJson(Role role) {
            this.role = role;
        }

        public Json toJson() {
            Json json = Json.object();
            Json permissions = Json.array();
            json.set("inheritable", (Object)this.role.isInheritable());
            this.role.getPermissions().forEach(p -> permissions.add((Object)p.getSecurityPermission().getName()));
            json.set("permissions", permissions);
            json.set("implicit", (Object)this.role.isImplicit());
            json.set("description", (Object)this.role.getDescription());
            return json;
        }
    }
}

