/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.io.StringBuilderWriter;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.ConvertUtil;
import org.infinispan.counter.configuration.CounterConfigurationSerializer;
import org.infinispan.counter.configuration.CounterManagerConfiguration;
import org.infinispan.counter.configuration.CounterManagerConfigurationBuilder;
import org.infinispan.counter.exception.CounterNotFoundException;
import org.infinispan.counter.impl.manager.EmbeddedCounterManager;
import org.infinispan.rest.CacheControl;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.RestResponseException;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.resources.ResourceUtil;

public class CounterResource
implements ResourceHandler {
    private final InvocationHelper invocationHelper;

    public CounterResource(InvocationHelper invocationHelper) {
        this.invocationHelper = invocationHelper;
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.POST).path("/v2/counters/{counterName}").handleWith(this::createCounter).invocation().methods(Method.DELETE).path("/v2/counters/{counterName}").handleWith(this::deleteCounter).invocation().methods(Method.GET).path("/v2/counters/{counterName}/config").handleWith(this::getConfig).invocation().methods(Method.GET).path("/v2/counters/").handleWith(this::getCounterNames).invocation().methods(Method.GET).path("/v2/counters/{counterName}").handleWith(this::getCounter).invocation().methods(Method.POST).path("/v2/counters/{counterName}").withAction("reset").handleWith(this::resetCounter).invocation().methods(Method.POST).path("/v2/counters/{counterName}").withAction("increment").handleWith(this::incrementCounter).invocation().methods(Method.POST).path("/v2/counters/{counterName}").withAction("decrement").handleWith(this::decrementCounter).invocation().methods(Method.POST).path("/v2/counters/{counterName}").withAction("add").handleWith(this::addValue).invocation().methods(Method.POST).path("/v2/counters/{counterName}").withAction("compareAndSet").handleWith(this::compareSet).invocation().methods(Method.POST).path("/v2/counters/{counterName}").withAction("compareAndSwap").handleWith(this::compareSwap).invocation().methods(Method.POST).path("/v2/counters/{counterName}").withAction("getAndSet").handleWith(this::getAndSet).create();
    }

    private CompletionStage<RestResponse> createCounter(RestRequest request) throws RestResponseException {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        String counterName = request.variables().get("counterName");
        String contents = request.contents().asString();
        if (contents == null || contents.isEmpty()) {
            throw Log.REST.missingContent();
        }
        CounterConfiguration configuration = this.createCounterConfiguration(contents);
        if (configuration == null) {
            throw Log.REST.invalidContent();
        }
        return this.invocationHelper.getCounterManager().defineCounterAsync(counterName, configuration).thenApply(created -> created != false ? responseBuilder.build() : responseBuilder.status(HttpResponseStatus.NOT_MODIFIED).entity("Unable to create counter: " + counterName).build());
    }

    private CompletionStage<RestResponse> deleteCounter(RestRequest request) {
        String counterName = request.variables().get("counterName");
        EmbeddedCounterManager counterManager = this.invocationHelper.getCounterManager();
        return counterManager.getConfigurationAsync(counterName).thenCompose(configuration -> {
            if (configuration == null) {
                return this.invocationHelper.newResponse(request, HttpResponseStatus.NOT_FOUND).toFuture();
            }
            return counterManager.removeAsync(counterName, false).thenApply(ignore -> this.invocationHelper.newResponse(request).status(HttpResponseStatus.NO_CONTENT).build());
        });
    }

    private CompletionStage<RestResponse> getConfig(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        String counterName = request.variables().get("counterName");
        boolean pretty = Boolean.parseBoolean(request.getParameter("pretty"));
        return this.invocationHelper.getCounterManager().getConfigurationAsync(counterName).thenApply(cfg -> {
            if (cfg == null) {
                return responseBuilder.status(HttpResponseStatus.NOT_FOUND).build();
            }
            AbstractCounterConfiguration parsedConfig = ConvertUtil.configToParsedConfig((String)counterName, (CounterConfiguration)cfg);
            CounterConfigurationSerializer ccs = new CounterConfigurationSerializer();
            StringBuilderWriter sw = new StringBuilderWriter();
            try (ConfigurationWriter w = ConfigurationWriter.to((Writer)sw).withType(MediaType.APPLICATION_JSON).prettyPrint(pretty).build();){
                ccs.serializeConfiguration(w, parsedConfig);
            }
            return responseBuilder.entity(sw.toString()).contentType(MediaType.APPLICATION_JSON).build();
        });
    }

    private CompletionStage<RestResponse> getCounter(RestRequest request) throws RestResponseException {
        String counterName = request.variables().get("counterName");
        String accept = request.getAcceptHeader();
        MediaType contentType = accept == null ? MediaType.TEXT_PLAIN : this.negotiateMediaType(accept);
        EmbeddedCounterManager counterManager = this.invocationHelper.getCounterManager();
        CompletionStage stage = counterManager.getOrCreateAsync(counterName);
        return CompletionStages.handleAndCompose((CompletionStage)stage, (counter, throwable) -> {
            if (throwable != null) {
                return this.handleThrowable(request, (Throwable)throwable);
            }
            return counter.value().thenApply(v -> this.invocationHelper.newResponse(request).contentType(contentType).header(HttpHeaderNames.CACHE_CONTROL.toString(), CacheControl.noCache()).entity(Long.toString(v)).build());
        });
    }

    private CompletionStage<RestResponse> resetCounter(RestRequest request) throws RestResponseException {
        String counterName = request.variables().get("counterName");
        EmbeddedCounterManager counterManager = this.invocationHelper.getCounterManager();
        CompletionStage stage = counterManager.getOrCreateAsync(counterName);
        return CompletionStages.handleAndCompose((CompletionStage)stage, (counter, throwable) -> {
            if (throwable != null) {
                return this.handleThrowable(request, (Throwable)throwable);
            }
            return counter.reset().thenCompose(unused -> this.invocationHelper.newResponse(request, HttpResponseStatus.NO_CONTENT).toFuture());
        });
    }

    private CompletionStage<RestResponse> getCounterNames(RestRequest request) throws RestResponseException {
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), Json.make((Object)this.invocationHelper.getCounterManager().getCounterNames()), ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> incrementCounter(RestRequest request) {
        return this.executeCommonCounterOp(request, WeakCounter::increment, StrongCounter::incrementAndGet);
    }

    private CompletionStage<RestResponse> decrementCounter(RestRequest request) {
        return this.executeCommonCounterOp(request, WeakCounter::decrement, StrongCounter::decrementAndGet);
    }

    private CompletionStage<RestResponse> addValue(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        Long delta = this.checkForNumericParam("delta", request, responseBuilder);
        if (delta == null) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        return this.executeCommonCounterOp(request, weakCounter -> weakCounter.add(delta.longValue()), strongCounter -> strongCounter.addAndGet(delta.longValue()));
    }

    private CompletionStage<RestResponse> compareSet(RestRequest request) {
        return this.executeCounterCAS(request, StrongCounter::compareAndSet);
    }

    private CompletionStage<RestResponse> compareSwap(RestRequest request) {
        return this.executeCounterCAS(request, StrongCounter::compareAndSwap);
    }

    private CompletionStage<RestResponse> getAndSet(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String counterName = request.variables().get("counterName");
        Long value = this.checkForNumericParam("value", request, responseBuilder);
        if (value == null) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        CompletionStage stage = this.invocationHelper.getCounterManager().getStrongCounterAsync(counterName);
        return CompletionStages.handleAndCompose((CompletionStage)stage, (counter, throwable) -> {
            if (throwable != null) {
                return this.handleThrowable(request, (Throwable)throwable);
            }
            return counter.getAndSet(value.longValue()).thenApply(v -> new NettyRestResponse.Builder().status(HttpResponseStatus.OK).entity(String.valueOf(v)).build());
        });
    }

    private CounterConfiguration createCounterConfiguration(String json) {
        try (ConfigurationReader reader = ConfigurationReader.from((String)json).withType(MediaType.APPLICATION_JSON).build();){
            ConfigurationBuilderHolder holder = this.invocationHelper.getParserRegistry().parse(reader, new ConfigurationBuilderHolder());
            CounterManagerConfigurationBuilder counterModule = (CounterManagerConfigurationBuilder)holder.getGlobalConfigurationBuilder().module(CounterManagerConfigurationBuilder.class);
            CounterManagerConfiguration configuration = counterModule.create();
            CounterConfiguration counterConfiguration = ConvertUtil.parsedConfigToConfig((AbstractCounterConfiguration)((AbstractCounterConfiguration)configuration.counters().values().iterator().next()));
            return counterConfiguration;
        }
    }

    private CompletionStage<RestResponse> executeCommonCounterOp(RestRequest request, Function<WeakCounter, CompletionStage<Void>> weakOp, Function<StrongCounter, CompletableFuture<Long>> strongOp) {
        String counterName = request.variables().get("counterName");
        boolean pretty = ResourceUtil.isPretty(request);
        CompletionStage stage = this.invocationHelper.getCounterManager().getOrCreateAsync(counterName);
        return CompletionStages.handleAndCompose((CompletionStage)stage, (counter, throwable) -> {
            if (throwable != null) {
                return this.handleThrowable(request, (Throwable)throwable);
            }
            CompletableFuture rsp = new CompletableFuture();
            if (counter.isWeakCounter()) {
                ((CompletionStage)weakOp.apply(counter.asWeakCounter())).whenComplete((___, t) -> {
                    if (t != null) {
                        rsp.completeExceptionally((Throwable)t);
                    } else {
                        rsp.complete(this.invocationHelper.newResponse(request, HttpResponseStatus.NO_CONTENT));
                    }
                });
            } else {
                ((CompletableFuture)strongOp.apply(counter.asStrongCounter())).whenComplete((rv, t) -> {
                    if (t != null) {
                        rsp.completeExceptionally((Throwable)t);
                    } else {
                        rsp.complete(ResourceUtil.asJsonResponse(this.invocationHelper.newResponse(request), Json.make((Object)rv), pretty));
                    }
                });
            }
            return rsp;
        });
    }

    private <T> CompletionStage<RestResponse> executeCounterCAS(RestRequest request, CASInvocation<StrongCounter, Long, Long, CompletableFuture<T>> invocation) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        String counterName = request.variables().get("counterName");
        boolean pretty = ResourceUtil.isPretty(request);
        Long expect = this.checkForNumericParam("expect", request, responseBuilder);
        if (expect == null) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        Long update = this.checkForNumericParam("update", request, responseBuilder);
        if (update == null) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        CompletionStage stage = this.invocationHelper.getCounterManager().getStrongCounterAsync(counterName);
        return CompletionStages.handleAndCompose((CompletionStage)stage, (counter, throwable) -> {
            if (throwable != null) {
                return this.handleThrowable(request, (Throwable)throwable);
            }
            return ((CompletableFuture)invocation.apply((StrongCounter)counter, expect, update)).thenCompose(value -> ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), Json.make((Object)value), pretty));
        });
    }

    private Long checkForNumericParam(String name, RestRequest request, NettyRestResponse.Builder builder) {
        List<String> params = request.parameters().get(name);
        if (params == null || params.size() != 1) {
            throw Log.REST.missingArgument(name);
        }
        String value = params.iterator().next();
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw Log.REST.illegalArgument(name, value);
        }
    }

    private MediaType negotiateMediaType(String accept) {
        return MediaType.parseList((String)accept).filter(t -> t.match(MediaType.TEXT_PLAIN)).findFirst().orElseThrow(() -> Log.REST.unsupportedDataFormat(accept));
    }

    private CompletionStage<RestResponse> handleThrowable(RestRequest request, Throwable throwable) {
        Throwable cause = CompletableFutures.extractException((Throwable)throwable);
        if (cause instanceof CounterNotFoundException) {
            return this.invocationHelper.newResponse(request, HttpResponseStatus.NOT_FOUND).toFuture();
        }
        return CompletableFuture.failedFuture(cause);
    }

    @FunctionalInterface
    static interface CASInvocation<C, A, B, R> {
        public R apply(C var1, A var2, B var3);
    }
}

