/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.cachemanager;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.encoding.impl.StorageConfigurationManager;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.notifications.Listenable;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.annotation.ConfigurationChanged;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.ConfigurationChangedEvent;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.rest.distribution.CacheDistributionInfo;
import org.infinispan.rest.distribution.CompleteKeyDistribution;
import org.infinispan.rest.distribution.KeyDistributionInfo;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.logging.Log;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.Security;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.security.impl.Authorizer;
import org.infinispan.server.core.CacheInfo;
import org.infinispan.telemetry.InfinispanSpanAttributes;
import org.infinispan.telemetry.SpanCategory;
import org.infinispan.telemetry.impl.CacheSpanAttribute;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.function.SerializableFunction;

public class RestCacheManager<V> {
    protected static final Log logger = Log.getLog(RestCacheManager.class);
    private final EmbeddedCacheManager instance;
    private final InternalCacheRegistry icr;
    private final Predicate<? super String> isCacheIgnored;
    private final boolean allowInternalCacheAccess;
    private final Map<String, CacheInfo<Object, V>> knownCaches = new ConcurrentHashMap<String, CacheInfo<Object, V>>(4, 0.9f, 16);
    private final RemoveCacheListener removeCacheListener;
    private final Authorizer authorizer;

    public RestCacheManager(EmbeddedCacheManager instance, Predicate<? super String> isCacheIgnored) {
        this.instance = instance;
        this.isCacheIgnored = isCacheIgnored;
        this.icr = (InternalCacheRegistry)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)instance).getComponent(InternalCacheRegistry.class);
        this.authorizer = (Authorizer)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)instance).getComponent(Authorizer.class);
        this.allowInternalCacheAccess = SecurityActions.getCacheManagerConfiguration((EmbeddedCacheManager)instance).security().authorization().enabled();
        this.removeCacheListener = new RemoveCacheListener();
        SecurityActions.addListener((EmbeddedCacheManager)instance, (Object)this.removeCacheListener);
    }

    public AdvancedCache<Object, V> getCache(String name, MediaType keyContentType, MediaType valueContentType, RestRequest request) {
        AdvancedCache cache;
        Subject subject = request.getSubject();
        Flag[] flags = request.getFlags();
        if (this.isCacheIgnored.test(name)) {
            throw logger.cacheUnavailable(name);
        }
        if (keyContentType == null || valueContentType == null) {
            throw logger.missingRequiredMediaType(name);
        }
        this.checkCacheAvailable(name);
        CacheInfo cacheInfo = this.knownCaches.get(name);
        if (cacheInfo == null) {
            cache = this.instance.getCache(name).getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES);
            cacheInfo = new CacheInfo(cache);
            this.knownCaches.putIfAbsent(name, cacheInfo);
        }
        cache = cacheInfo.getCache(new KeyValuePair((Object)keyContentType, (Object)valueContentType), subject);
        if (flags != null && flags.length > 0) {
            cache = cache.withFlags(flags);
        }
        return cache;
    }

    public AdvancedCache<Object, V> getCache(String name, MediaType keyContentType, RestRequest request) {
        if (keyContentType == null) {
            return this.getCache(name, request);
        }
        return this.getCache(name, keyContentType, MediaType.MATCH_ALL, request);
    }

    public AdvancedCache<Object, V> getCache(String name, RestRequest restRequest) {
        return this.getCache(name, MediaType.MATCH_ALL, MediaType.MATCH_ALL, restRequest);
    }

    public boolean cacheExists(String name) {
        return this.instance.cacheExists(name);
    }

    private void checkCacheAvailable(String cacheName) {
        if (!this.instance.isRunning(cacheName)) {
            GlobalComponentRegistry gcr = SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)this.instance);
            LocalTopologyManager ltm = gcr.getLocalTopologyManager();
            if (ltm != null) {
                ltm.assertTopologyStable(cacheName);
            }
            throw logger.cacheNotFound(cacheName);
        }
        if (this.icr.isInternalCache(cacheName)) {
            if (this.icr.isPrivateCache(cacheName)) {
                throw logger.requestNotAllowedToInternalCaches(cacheName);
            }
            if (!this.allowInternalCacheAccess && !this.icr.internalCacheHasFlag(cacheName, InternalCacheRegistry.Flag.USER)) {
                throw logger.requestNotAllowedToInternalCachesWithoutAuthz(cacheName);
            }
        }
    }

    public boolean isCacheQueryable(Cache<?, ?> cache) {
        return ((StorageConfigurationManager)SecurityActions.getCacheComponentRegistry((AdvancedCache)cache.getAdvancedCache()).getComponent(StorageConfigurationManager.class)).isQueryable();
    }

    public Collection<String> getCacheNames() {
        return this.instance.getCacheNames().stream().filter(arg_0 -> ((EmbeddedCacheManager)this.instance).cacheExists(arg_0)).toList();
    }

    public Collection<String> getAccessibleCacheNames() {
        return this.instance.getAccessibleCacheNames().stream().filter(arg_0 -> ((EmbeddedCacheManager)this.instance).cacheExists(arg_0)).toList();
    }

    public CompletionStage<CacheEntry<Object, V>> getInternalEntry(String cacheName, Object key, MediaType keyContentType, MediaType mediaType, RestRequest request) {
        return this.getInternalEntry(cacheName, key, false, keyContentType, mediaType, request);
    }

    public CompletionStage<V> remove(String cacheName, Object key, MediaType keyContentType, RestRequest restRequest) {
        AdvancedCache<Object, V> cache = this.getCache(cacheName, keyContentType, MediaType.MATCH_ALL, restRequest);
        return cache.removeAsync(key);
    }

    public CompletionStage<CacheEntry<Object, V>> getPrivilegedInternalEntry(AdvancedCache<Object, V> cache, Object key, boolean skipListener) {
        AdvancedCache cacheSkip = skipListener ? cache.withFlags(Flag.SKIP_LISTENER_NOTIFICATION) : cache;
        return SecurityActions.getCacheEntryAsync((AdvancedCache)cacheSkip, (Object)key);
    }

    private CompletionStage<CacheEntry<Object, V>> getInternalEntry(AdvancedCache<Object, V> cache, Object key, boolean skipListener) {
        return skipListener ? cache.withFlags(Flag.SKIP_LISTENER_NOTIFICATION).getCacheEntryAsync(key) : cache.getCacheEntryAsync(key);
    }

    public MediaType getValueConfiguredFormat(String cacheName, RestRequest restRequest) {
        return SecurityActions.getCacheConfiguration(this.getCache(cacheName, restRequest)).encoding().valueDataType().mediaType();
    }

    private CompletionStage<CacheEntry<Object, V>> getInternalEntry(String cacheName, Object key, boolean skipListener, MediaType keyContentType, MediaType mediaType, RestRequest restRequest) {
        return this.getInternalEntry(this.getCache(cacheName, keyContentType, mediaType, restRequest), key, skipListener);
    }

    public String getNodeName() {
        Address addressToBeReturned = this.instance.getAddress();
        if (addressToBeReturned == null) {
            return "0.0.0.0";
        }
        return addressToBeReturned.toString();
    }

    public String getServerAddress() {
        Transport transport = (Transport)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)this.instance).getComponent(Transport.class);
        if (transport instanceof JGroupsTransport) {
            return transport.getPhysicalAddresses().toString();
        }
        return "0.0.0.0";
    }

    public String getPrimaryOwner(String cacheName, Object key, RestRequest restRequest) {
        DistributionManager dm = SecurityActions.getDistributionManager(this.getCache(cacheName, restRequest));
        if (dm == null) {
            return "0.0.0.0";
        }
        return dm.getCacheTopology().getDistribution(key).primary().toString();
    }

    public String getBackupOwners(String cacheName, Object key, RestRequest restRequest) {
        DistributionManager dm = SecurityActions.getDistributionManager(this.getCache(cacheName, restRequest));
        if (dm == null) {
            return "0.0.0.0";
        }
        return dm.getCacheTopology().getDistribution(key).writeBackups().stream().map(a -> a.toString()).collect(Collectors.joining(" "));
    }

    public EmbeddedCacheManager getInstance() {
        return this.instance;
    }

    public Authorizer getAuthorizer() {
        return this.authorizer;
    }

    public EmbeddedCacheManagerAdmin getCacheManagerAdmin(RestRequest restRequest) {
        Subject subject = restRequest.getSubject();
        if (subject == null) {
            return this.instance.administration();
        }
        return (EmbeddedCacheManagerAdmin)Security.doAs((Subject)subject, () -> this.instance.administration().withSubject(subject));
    }

    public void stop() {
        if (this.removeCacheListener != null) {
            CompletionStages.join((CompletionStage)SecurityActions.removeListenerAsync((Listenable)this.instance, (Object)this.removeCacheListener));
        }
    }

    public void resetCacheInfo(String cacheName) {
        this.knownCaches.remove(cacheName);
    }

    public CompletionStage<List<CacheDistributionInfo>> cacheDistribution(String cacheName, RestRequest request) {
        AdvancedCache<Object, V> ac = this.getCache(cacheName, request);
        this.checkCachePermission(ac, request.getSubject(), AuthorizationPermission.MONITOR);
        DistributionManager dm = SecurityActions.getDistributionManager(ac);
        if (dm == null) {
            CacheDistributionInfo local = CacheDistributionInfo.resolve(ac, this.instance.getCacheManagerInfo());
            return CompletableFuture.completedFuture(Collections.singletonList(local));
        }
        return this.requestMembers(dm.getCacheTopology().getMembers(), (SerializableFunction & Serializable)ecm -> {
            Cache c = SecurityActions.getCache((EmbeddedCacheManager)ecm, (String)cacheName);
            return CacheDistributionInfo.resolve(c.getAdvancedCache());
        });
    }

    public CompletionStage<CompleteKeyDistribution> getKeyDistribution(String cacheName, Object key, RestRequest request) {
        AdvancedCache<Object, V> cache = this.getCache(cacheName, request.keyContentType(), request);
        this.checkCachePermission(cache, request.getSubject(), AuthorizationPermission.MONITOR);
        return SecurityActions.cacheContainsKeyAsync(cache, (Object)key).thenCompose(contains -> {
            DistributionManager dm = SecurityActions.getDistributionManager((AdvancedCache)cache);
            if (dm == null) {
                KeyDistributionInfo local = KeyDistributionInfo.resolve(cache, true);
                return CompletableFuture.completedFuture(new CompleteKeyDistribution(Collections.singletonList(local), (boolean)contains));
            }
            LocalizedCacheTopology topology = dm.getCacheTopology();
            List members = topology.getMembers();
            Address primary = null;
            if (contains.booleanValue()) {
                DistributionInfo distribution = topology.getDistribution(key);
                members = distribution.readOwners();
                primary = distribution.primary();
            }
            Address p = primary;
            return this.requestMembers(members, (SerializableFunction & Serializable)ecm -> {
                Cache c = SecurityActions.getCache((EmbeddedCacheManager)ecm, (String)cacheName);
                boolean isPrimary = p != null && ecm.getAddress().equals((Object)p);
                return KeyDistributionInfo.resolve(c.getAdvancedCache(), isPrimary);
            }).thenApply(d -> new CompleteKeyDistribution((List<KeyDistributionInfo>)d, (boolean)contains));
        });
    }

    private <T> CompletionStage<List<T>> requestMembers(List<Address> addresses, SerializableFunction<EmbeddedCacheManager, T> function) {
        ConcurrentHashMap responses = new ConcurrentHashMap();
        ClusterExecutor executor = SecurityActions.getClusterExecutor((EmbeddedCacheManager)this.instance);
        return executor.filterTargets(addresses).submitConsumer(function, (address, res, t) -> {
            if (t != null) {
                throw CompletableFutures.asCompletionException((Throwable)t);
            }
            responses.put(address, res);
        }).thenApply(ignore -> Immutables.immutableListConvert(responses.values()));
    }

    private void checkCachePermission(AdvancedCache<?, ?> ac, Subject subject, AuthorizationPermission permission) {
        AuthorizationManager am = SecurityActions.getCacheAuthorizationManager(ac);
        if (am != null) {
            am.checkPermission(subject, permission);
        }
    }

    public InfinispanSpanAttributes getInfinispanSpanAttributes(String cacheName, RestRequest request) {
        CacheInfo<Object, V> cacheInfo = this.knownCaches.get(cacheName);
        if (cacheInfo != null) {
            return cacheInfo.getInfinispanSpanAttributes();
        }
        return ((CacheSpanAttribute)SecurityActions.getCacheComponentRegistry(this.getCache(cacheName, request)).getComponent(CacheSpanAttribute.class)).getAttributes(SpanCategory.CONTAINER);
    }

    @Listener
    class RemoveCacheListener {
        RemoveCacheListener() {
        }

        @CacheStopped
        public void cacheStopped(CacheStoppedEvent event) {
            RestCacheManager.this.resetCacheInfo(event.getCacheName());
        }

        @ConfigurationChanged
        public void configurationChanged(ConfigurationChangedEvent event) {
            RestCacheManager.this.knownCaches.clear();
        }
    }
}

