/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.configuration;

import io.netty.handler.codec.http.cors.CorsConfig;
import java.nio.file.Path;
import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.rest.configuration.CorsConfigurationBuilder;
import org.infinispan.rest.configuration.ExtendedHeaders;
import org.infinispan.rest.configuration.RestAuthenticationConfiguration;
import org.infinispan.rest.configuration.RestAuthenticationConfigurationBuilder;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.logging.Log;
import org.infinispan.server.core.configuration.EncryptionConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;

public class RestServerConfigurationBuilder
extends ProtocolServerConfigurationBuilder<RestServerConfiguration, RestServerConfigurationBuilder, RestAuthenticationConfiguration>
implements Builder<RestServerConfiguration> {
    static final Log logger = Log.getLog(RestServerConfigurationBuilder.class);
    private final RestAuthenticationConfigurationBuilder authentication;
    private final CorsConfigurationBuilder cors;
    private Path staticResources;
    private final EncryptionConfigurationBuilder encryption = new EncryptionConfigurationBuilder(this.ssl());
    private static final int DEFAULT_PORT = 8080;
    private static final String DEFAULT_NAME = "rest";

    public RestServerConfigurationBuilder() {
        super(8080, RestServerConfiguration.attributeDefinitionSet());
        this.authentication = new RestAuthenticationConfigurationBuilder(this);
        this.cors = new CorsConfigurationBuilder();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public RestServerConfigurationBuilder extendedHeaders(ExtendedHeaders extendedHeaders) {
        this.attributes.attribute(RestServerConfiguration.EXTENDED_HEADERS).set((Object)extendedHeaders);
        return this;
    }

    public RestServerConfigurationBuilder contextPath(String contextPath) {
        this.attributes.attribute(RestServerConfiguration.CONTEXT_PATH).set((Object)contextPath);
        return this;
    }

    public RestServerConfigurationBuilder maxContentLength(String maxContentLength) {
        this.attributes.attribute(RestServerConfiguration.MAX_CONTENT_LENGTH).set((Object)maxContentLength);
        return this;
    }

    public RestServerConfigurationBuilder compressionLevel(int compressLevel) {
        this.attributes.attribute(RestServerConfiguration.COMPRESSION_LEVEL).set((Object)compressLevel);
        return this;
    }

    public RestServerConfigurationBuilder compressionThreshold(int compressThreshold) {
        this.attributes.attribute(RestServerConfiguration.COMPRESSION_THRESHOLD).set((Object)compressThreshold);
        return this;
    }

    public RestAuthenticationConfigurationBuilder authentication() {
        return this.authentication;
    }

    public EncryptionConfigurationBuilder encryption() {
        return this.encryption;
    }

    public RestServerConfigurationBuilder addAll(List<CorsConfig> corsConfig) {
        this.cors.add(corsConfig);
        return this;
    }

    public RestServerConfigurationBuilder staticResources(Path dir) {
        this.staticResources = dir;
        return this;
    }

    public CorsConfigurationBuilder cors() {
        return this.cors;
    }

    public void validate() {
        super.validate();
        this.authentication.validate();
        int compressionLevel = (Integer)this.attributes.attribute(RestServerConfiguration.COMPRESSION_LEVEL).get();
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw logger.illegalCompressionLevel(compressionLevel);
        }
    }

    public RestServerConfiguration create() {
        if (!this.attributes.attribute(ProtocolServerConfiguration.NAME).isModified()) {
            String socketBinding = this.socketBinding();
            this.name(DEFAULT_NAME + (String)(socketBinding == null ? "" : "-" + socketBinding));
        }
        return new RestServerConfiguration(this.attributes.protect(), this.ssl.create(), this.staticResources, this.authentication.create(), this.cors.create(), this.encryption.create(), this.ipFilter.create());
    }

    public Builder<?> read(RestServerConfiguration template, Combine combine) {
        super.read((ProtocolServerConfiguration)template, combine);
        this.attributes.read(template.attributes(), combine);
        this.authentication.read(template.authentication(), combine);
        this.cors.read(template.cors(), combine);
        this.encryption.read(template.encryption(), combine);
        return this;
    }

    public RestServerConfiguration build() {
        return this.build(true);
    }

    public RestServerConfiguration build(boolean validate) {
        if (validate) {
            this.validate();
        }
        return this.create();
    }

    public RestServerConfigurationBuilder self() {
        return this;
    }

    public RestServerConfigurationBuilder defaultCacheName(String defaultCacheName) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder idleTimeout(int idleTimeout) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder tcpNoDelay(boolean tcpNoDelay) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder tcpKeepAlive(boolean tcpKeepAlive) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder recvBufSize(int recvBufSize) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder sendBufSize(int sendBufSize) {
        throw logger.unsupportedConfigurationOption();
    }
}

