/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.ipfilter.IpFilterRuleType;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.commons.io.StringBuilderWriter;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.JVMMemoryInfoInfo;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.manager.CacheManagerInfo;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.logging.Messages;
import org.infinispan.rest.resources.MediaTypeUtils;
import org.infinispan.rest.resources.ResourceUtil;
import org.infinispan.security.AuditContext;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.Security;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.ServerManagement;
import org.infinispan.server.core.ServerStateManager;
import org.infinispan.server.core.transport.IpSubnetFilterRule;
import org.infinispan.server.core.transport.Transport;
import org.infinispan.util.function.SerializableFunction;

public class ServerResource
implements ResourceHandler {
    private final InvocationHelper invocationHelper;
    private final Executor blockingExecutor;

    public ServerResource(InvocationHelper invocationHelper) {
        this.invocationHelper = invocationHelper;
        this.blockingExecutor = invocationHelper.getExecutor();
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET).path("/v2/server/").handleWith(this::info).invocation().methods(Method.GET).path("/v2/server/config").permission(AuthorizationPermission.ADMIN).auditContext(AuditContext.SERVER).handleWith(this::config).invocation().methods(Method.GET).path("/v2/server/env").permission(AuthorizationPermission.ADMIN).auditContext(AuditContext.SERVER).handleWith(this::env).invocation().methods(Method.GET).path("/v2/server/memory").permission(AuthorizationPermission.ADMIN).auditContext(AuditContext.SERVER).handleWith(this::memory).invocation().methods(Method.POST).path("/v2/server/memory").withAction("heap-dump").permission(AuthorizationPermission.ADMIN).auditContext(AuditContext.SERVER).handleWith(this::heapDump).invocation().methods(Method.POST).path("/v2/server/").withAction("stop").permission(AuthorizationPermission.ADMIN).handleWith(this::stop).invocation().methods(Method.GET).path("/v2/server/overview-report").permission(AuthorizationPermission.ADMIN).handleWith(this::overviewReport).invocation().methods(Method.GET).path("/v2/server/threads").permission(AuthorizationPermission.ADMIN).auditContext(AuditContext.SERVER).handleWith(this::threads).invocation().methods(Method.GET).path("/v2/server/report").permission(AuthorizationPermission.ADMIN).auditContext(AuditContext.SERVER).handleWith(this::report).invocation().methods(Method.GET).path("/v2/server/report/{nodeName}").permission(AuthorizationPermission.ADMIN).auditContext(AuditContext.SERVER).handleWith(this::nodeReport).invocation().methods(Method.GET).path("/v2/server/ignored-caches/{cache-manager}").deprecated().permission(AuthorizationPermission.ADMIN).auditContext(AuditContext.SERVER).handleWith(this::listIgnored).invocation().methods(Method.GET).path("/v2/server/ignored-caches").permission(AuthorizationPermission.ADMIN).auditContext(AuditContext.SERVER).handleWith(this::listIgnored).invocation().methods(Method.POST, Method.DELETE).path("/v2/server/ignored-caches/{cache-manager}/{cache}").deprecated().permission(AuthorizationPermission.ADMIN).auditContext(AuditContext.SERVER).handleWith(this::doIgnoreOp).invocation().methods(Method.POST, Method.DELETE).path("/v2/server/ignored-caches/{cache}").permission(AuthorizationPermission.ADMIN).auditContext(AuditContext.SERVER).handleWith(this::doIgnoreOp).invocation().methods(Method.GET).path("/v2/server/connections").permission(AuthorizationPermission.ADMIN).name("CONNECTION LIST").auditContext(AuditContext.SERVER).handleWith(this::listConnections).invocation().methods(Method.GET).path("/v2/server/connectors").permission(AuthorizationPermission.ADMIN).name("CONNECTOR LIST").auditContext(AuditContext.SERVER).handleWith(this::listConnectors).invocation().methods(Method.GET).path("/v2/server/connectors/{connector}").permission(AuthorizationPermission.ADMIN).name("CONNECTOR GET").auditContext(AuditContext.SERVER).handleWith(this::connectorStatus).invocation().methods(Method.POST).path("/v2/server/connectors/{connector}").withAction("start").permission(AuthorizationPermission.ADMIN).name("CONNECTOR START").auditContext(AuditContext.SERVER).handleWith(this::connectorStartStop).invocation().methods(Method.POST).path("/v2/server/connectors/{connector}").withAction("stop").permission(AuthorizationPermission.ADMIN).name("CONNECTOR STOP").auditContext(AuditContext.SERVER).handleWith(this::connectorStartStop).invocation().methods(Method.GET).path("/v2/server/connectors/{connector}/ip-filter").permission(AuthorizationPermission.ADMIN).name("CONNECTOR FILTER GET").auditContext(AuditContext.SERVER).handleWith(this::connectorIpFilterList).invocation().methods(Method.POST).path("/v2/server/connectors/{connector}/ip-filter").permission(AuthorizationPermission.ADMIN).name("CONNECTOR FILTER SET").auditContext(AuditContext.SERVER).handleWith(this::connectorIpFilterSet).invocation().methods(Method.DELETE).path("/v2/server/connectors/{connector}/ip-filter").permission(AuthorizationPermission.ADMIN).name("CONNECTOR FILTER DELETE").auditContext(AuditContext.SERVER).handleWith(this::connectorIpFilterClear).invocation().methods(Method.GET).path("/v2/server/datasources").permission(AuthorizationPermission.ADMIN).name("DATASOURCE LIST").auditContext(AuditContext.SERVER).handleWith(this::dataSourceList).invocation().methods(Method.POST).path("/v2/server/datasources/{datasource}").withAction("test").permission(AuthorizationPermission.ADMIN).name("DATASOURCE TEST").auditContext(AuditContext.SERVER).handleWith(this::dataSourceTest).invocation().methods(Method.GET).path("/v2/server/caches/defaults").handleWith(this::getCacheConfigDefaultAttributes).create();
    }

    private CompletionStage<RestResponse> doIgnoreOp(RestRequest request) {
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request).status(HttpResponseStatus.NO_CONTENT);
        boolean add = request.method().equals((Object)Method.POST);
        RestCacheManager<Object> cacheManager = this.invocationHelper.getRestCacheManager();
        String cacheManagerName = request.variables().get("cache-manager");
        String cacheName = request.variables().get("cache");
        if (cacheName == null) {
            cacheName = cacheManagerName;
        }
        if (!cacheManager.getCacheNames().contains(cacheName)) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.NOT_FOUND).build());
        }
        String cacheNameFinal = cacheName;
        ServerManagement server = this.invocationHelper.getServer();
        ServerStateManager ignoreManager = server.getServerStateManager();
        return ((CompletableFuture)Security.doAs((Subject)request.getSubject(), () -> add ? ignoreManager.ignoreCache(cacheNameFinal) : ignoreManager.unignoreCache(cacheNameFinal))).thenApply(r -> builder.build());
    }

    private CompletionStage<RestResponse> listIgnored(RestRequest request) {
        ServerStateManager serverStateManager = this.invocationHelper.getServer().getServerStateManager();
        Set ignored = serverStateManager.getIgnoredCaches();
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), Json.make((Object)ignored), ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> connectorStartStop(RestRequest request) {
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request).status(HttpResponseStatus.NO_CONTENT);
        String connectorName = request.variables().get("connector");
        ProtocolServer connector = (ProtocolServer)this.invocationHelper.getServer().getProtocolServers().get(connectorName);
        if (connector == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.NOT_FOUND).build());
        }
        ServerStateManager serverStateManager = this.invocationHelper.getServer().getServerStateManager();
        switch (request.getAction()) {
            case "start": {
                return (CompletionStage)Security.doAs((Subject)request.getSubject(), () -> serverStateManager.connectorStart(connectorName).thenApply(r -> builder.build()));
            }
            case "stop": {
                if (connector.equals((Object)this.invocationHelper.getProtocolServer()) || connector.equals((Object)this.invocationHelper.getProtocolServer().getEnclosingProtocolServer())) {
                    return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.CONFLICT).entity(Messages.MSG.connectorMatchesRequest(connectorName)).build());
                }
                return (CompletionStage)Security.doAs((Subject)request.getSubject(), () -> serverStateManager.connectorStop(connectorName).thenApply(r -> builder.build()));
            }
        }
        throw Log.REST.unknownAction(request.getAction());
    }

    private CompletionStage<RestResponse> connectorStatus(RestRequest request) {
        CompletableFuture<Integer> globalConnections;
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
        String connectorName = request.variables().get("connector");
        ProtocolServer<?> connector = this.getProtocolServer(request);
        if (connector == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.NOT_FOUND).build());
        }
        ServerStateManager serverStateManager = this.invocationHelper.getServer().getServerStateManager();
        Json info = Json.object().set("name", (Object)connectorName).set("ip-filter-rules", this.ipFilterRulesAsJson(connector)).set("default-cache", (Object)connector.getConfiguration().defaultCacheName());
        Transport transport = connector.getTransport();
        if (transport != null) {
            info.set("host", (Object)transport.getHostName()).set("port", (Object)transport.getPort()).set("local-connections", (Object)transport.getNumberOfLocalConnections()).set("io-threads", (Object)transport.getNumberIOThreads()).set("pending-tasks", (Object)transport.getPendingTasks()).set("total-bytes-read", (Object)transport.getTotalBytesRead()).set("total-bytes-written", (Object)transport.getTotalBytesWritten()).set("send-buffer-size", (Object)transport.getSendBufferSize()).set("receive-buffer-size", (Object)transport.getReceiveBufferSize());
            globalConnections = CompletableFuture.supplyAsync(() -> ((Transport)transport).getNumberOfGlobalConnections(), this.invocationHelper.getExecutor());
        } else {
            globalConnections = CompletableFutures.completedNull();
        }
        CompletableFuture connectorStatus = (CompletableFuture)Security.doAs((Subject)request.getSubject(), () -> serverStateManager.connectorStatus(connectorName));
        return connectorStatus.thenCombine(globalConnections, (cs, gc) -> {
            info.set("enabled", cs);
            if (gc != null) {
                info.set("global-connections", gc);
            }
            return builder.contentType(MediaType.APPLICATION_JSON).entity(info).build();
        });
    }

    private CompletionStage<RestResponse> connectorIpFilterList(RestRequest request) {
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
        ProtocolServer<?> connector = this.getProtocolServer(request);
        if (connector == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.NOT_FOUND).build());
        }
        return CompletableFuture.completedFuture(ResourceUtil.addEntityAsJson(this.ipFilterRulesAsJson(connector), builder, ResourceUtil.isPretty(request)).build());
    }

    private Json ipFilterRulesAsJson(ProtocolServer<?> connector) {
        List rules = connector.getConfiguration().ipFilter().rules();
        Json array = Json.array();
        for (IpSubnetFilterRule rule : rules) {
            array.add(Json.object().set("type", (Object)rule.ruleType().name().toLowerCase()).set("from", (Object)rule.cidr()));
        }
        return array;
    }

    private ProtocolServer<?> getProtocolServer(RestRequest restRequest) {
        String connectorName = restRequest.variables().get("connector");
        return (ProtocolServer)this.invocationHelper.getServer().getProtocolServers().get(connectorName);
    }

    private CompletionStage<RestResponse> listConnections(RestRequest request) {
        boolean global = Boolean.parseBoolean(request.getParameter("global"));
        if (global) {
            List results = Collections.synchronizedList(new ArrayList());
            return SecurityActions.getClusterExecutor((EmbeddedCacheManager)this.invocationHelper.getProtocolServer().getCacheManager()).submitConsumer((SerializableFunction & Serializable)ecm -> {
                GlobalComponentRegistry gcr = SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)ecm);
                BasicComponentRegistry bcr = (BasicComponentRegistry)gcr.getComponent(BasicComponentRegistry.class);
                ServerStateManager ssm = (ServerStateManager)bcr.getComponent(ServerStateManager.class).wired();
                return ((Json)CompletableFutures.uncheckedAwait((CompletableFuture)ssm.listConnections())).toString();
            }, (ignore, s, t) -> {
                if (t != null) {
                    throw CompletableFutures.asCompletionException((Throwable)t);
                }
                results.add(Json.read((String)s));
            }).thenApply(ignore -> {
                Json all = Json.array();
                for (Json result : results) {
                    for (Json c : result.asJsonList()) {
                        all.add(c);
                    }
                }
                return ResourceUtil.asJsonResponse(this.invocationHelper.newResponse(request), all, ResourceUtil.isPretty(request));
            });
        }
        ServerStateManager serverStateManager = this.invocationHelper.getServer().getServerStateManager();
        return serverStateManager.listConnections().thenApply(j -> ResourceUtil.asJsonResponse(this.invocationHelper.newResponse(request), j, ResourceUtil.isPretty(request)));
    }

    private CompletionStage<RestResponse> connectorIpFilterClear(RestRequest request) {
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request).status(HttpResponseStatus.NO_CONTENT);
        String connectorName = request.variables().get("connector");
        ProtocolServer connector = (ProtocolServer)this.invocationHelper.getServer().getProtocolServers().get(connectorName);
        if (connector == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.NOT_FOUND).build());
        }
        ServerStateManager serverStateManager = this.invocationHelper.getServer().getServerStateManager();
        return (CompletionStage)Security.doAs((Subject)request.getSubject(), () -> serverStateManager.clearConnectorIpFilterRules(connectorName).thenApply(r -> builder.build()));
    }

    private CompletionStage<RestResponse> listConnectors(RestRequest request) {
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), Json.make(this.invocationHelper.getServer().getProtocolServers().keySet()), ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> connectorIpFilterSet(RestRequest request) {
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request).status(HttpResponseStatus.NO_CONTENT);
        String connectorName = request.variables().get("connector");
        ProtocolServer connector = (ProtocolServer)this.invocationHelper.getServer().getProtocolServers().get(connectorName);
        if (connector == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.NOT_FOUND).build());
        }
        Json json = Json.read((String)request.contents().asString());
        if (!json.isArray()) {
            throw Log.REST.invalidContent();
        }
        List list = json.asJsonList();
        ArrayList<IpSubnetFilterRule> rules = new ArrayList<IpSubnetFilterRule>(list.size());
        for (Json o : list) {
            if (!o.has("type") || !o.has("cidr")) {
                throw Log.REST.missingArguments("type", "cidr");
            }
            rules.add(new IpSubnetFilterRule(o.at("cidr").asString(), IpFilterRuleType.valueOf((String)o.at("type").asString())));
        }
        if (connector.equals((Object)this.invocationHelper.getProtocolServer()) || connector.equals((Object)this.invocationHelper.getProtocolServer().getEnclosingProtocolServer())) {
            InetSocketAddress remoteAddress = request.getRemoteAddress();
            for (IpSubnetFilterRule rule : rules) {
                if (rule.ruleType() != IpFilterRuleType.REJECT || !rule.matches(remoteAddress)) continue;
                return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.CONFLICT).entity(Messages.MSG.rejectRuleMatchesRequestAddress(rule, remoteAddress)).build());
            }
        }
        ServerStateManager serverStateManager = this.invocationHelper.getServer().getServerStateManager();
        return (CompletionStage)Security.doAs((Subject)request.getSubject(), () -> serverStateManager.setConnectorIpFilterRule(connectorName, (Collection)rules).thenApply(r -> builder.build()));
    }

    private CompletionStage<RestResponse> memory(RestRequest request) {
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), new JVMMemoryInfoInfo().toJson(), ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> heapDump(RestRequest request) {
        boolean live = Boolean.parseBoolean(request.getParameter("live"));
        boolean pretty = ResourceUtil.isPretty(request);
        ServerManagement server = this.invocationHelper.getServer();
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path dumpFile = Files.createTempFile(server.getServerDataPath(), "dump", ".hprof", new FileAttribute[0]);
                Files.delete(dumpFile);
                new JVMMemoryInfoInfo().heapDump(dumpFile, live);
                return ResourceUtil.asJsonResponse(this.invocationHelper.newResponse(request), Json.object().set("filename", (Object)dumpFile.getFileName().toString()), pretty);
            }
            catch (IOException e) {
                throw Log.REST.heapDumpFailed(e);
            }
        }, this.blockingExecutor);
    }

    private CompletionStage<RestResponse> env(RestRequest request) {
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), Json.make((Object)System.getProperties()), ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> info(RestRequest request) {
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), new ServerInfo(this.invocationHelper.getServer()).toJson(), ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> overviewReport(RestRequest request) {
        return CompletableFuture.supplyAsync(() -> ResourceUtil.asJsonResponse(this.invocationHelper.newResponse(request), this.invocationHelper.getServer().overviewReport(), ResourceUtil.isPretty(request)), this.blockingExecutor);
    }

    private CompletionStage<RestResponse> threads(RestRequest request) {
        return CompletableFuture.completedFuture(this.invocationHelper.newResponse(request).contentType(MediaType.TEXT_PLAIN).entity(Util.threadDump()).build());
    }

    private CompletionStage<RestResponse> report(RestRequest request) {
        ServerManagement server = this.invocationHelper.getServer();
        return (CompletionStage)Security.doAs((Subject)request.getSubject(), () -> server.getServerReport().handle((path, t) -> {
            if (t != null) {
                throw CompletableFutures.asCompletionException((Throwable)t);
            }
            return this.createReportResponse(request, path.toFile(), this.invocationHelper.getRestCacheManager().getNodeName());
        }));
    }

    private RestResponse createReportResponse(RestRequest request, Object report, String filename) {
        return this.invocationHelper.newResponse(request).contentType("application/gzip").header("Content-Disposition", String.format("attachment; filename=\"%s-%s-%3$tY%3$tm%3$td%3$tH%3$tM%3$tS-report.tar.gz\"", Version.getBrandName().toLowerCase().replaceAll("\\s", "-"), filename, Calendar.getInstance())).entity(report).build();
    }

    private CompletionStage<RestResponse> nodeReport(RestRequest request) {
        String targetName = request.variables().get("nodeName");
        EmbeddedCacheManager cacheManager = this.invocationHelper.getProtocolServer().getCacheManager();
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        List members = cacheManager.getMembers();
        if (this.invocationHelper.getRestCacheManager().getNodeName().equals(targetName)) {
            return this.report(request);
        }
        if (members == null) {
            return CompletableFuture.completedFuture(responseBuilder.status(HttpResponseStatus.NOT_FOUND).build());
        }
        ByRef response = new ByRef(null);
        return SecurityActions.getClusterExecutor((EmbeddedCacheManager)cacheManager).submitConsumer((SerializableFunction & Serializable)ecm -> {
            CacheManagerInfo cmi = ecm.getCacheManagerInfo();
            if (!cmi.getNodeName().equals(targetName)) {
                return null;
            }
            GlobalComponentRegistry gcr = SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)ecm);
            BasicComponentRegistry bcr = (BasicComponentRegistry)gcr.getComponent(BasicComponentRegistry.class);
            ServerStateManager ssm = (ServerStateManager)bcr.getComponent(ServerStateManager.class).wired();
            Path reportPath = (Path)CompletableFutures.uncheckedAwait(ssm.managedServer().getServerReport().toCompletableFuture());
            try {
                return Files.readAllBytes(reportPath);
            }
            catch (IOException e) {
                throw new CacheException(String.format("Failed reading '%s' at node '%s'", reportPath, targetName), (Throwable)e);
            }
        }, (ignore, info, t) -> {
            if (t != null) {
                throw CompletableFutures.asCompletionException((Throwable)t);
            }
            if (info != null) {
                response.set(info);
            }
        }).thenApply(ignore -> {
            byte[] report = (byte[])response.get();
            if (report == null) {
                return responseBuilder.status(HttpResponseStatus.NOT_FOUND).build();
            }
            return this.createReportResponse(request, report, targetName);
        });
    }

    private CompletionStage<RestResponse> stop(RestRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            Security.doAs((Subject)request.getSubject(), () -> this.invocationHelper.getServer().serverStop(Collections.emptyList()));
            return this.invocationHelper.newResponse(request).status(HttpResponseStatus.NO_CONTENT).build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> config(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        MediaType accept = MediaTypeUtils.negotiateMediaType(request, MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML, MediaType.APPLICATION_YAML);
        responseBuilder.contentType(accept);
        boolean pretty = Boolean.parseBoolean(request.getParameter("pretty"));
        StringBuilderWriter sw = new StringBuilderWriter();
        try (ConfigurationWriter w = ConfigurationWriter.to((Writer)sw).withType(accept).prettyPrint(pretty).build();){
            this.invocationHelper.getServer().serializeConfiguration(w);
        }
        responseBuilder.entity(sw.toString());
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> dataSourceList(RestRequest request) {
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), Json.make(this.invocationHelper.getServer().getDataSources().keySet()), ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> dataSourceTest(RestRequest request) {
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
        String name = request.variables().get("datasource");
        DataSource dataSource = (DataSource)this.invocationHelper.getServer().getDataSources().get(name);
        if (dataSource == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.NOT_FOUND).build());
        }
        return CompletableFuture.supplyAsync(() -> {
            try (Connection connection = dataSource.getConnection();){
                if (connection.isValid(0)) {
                    builder.status(HttpResponseStatus.OK).entity(Messages.MSG.dataSourceTestOk(name));
                } else {
                    builder.status(HttpResponseStatus.SERVICE_UNAVAILABLE).entity(Messages.MSG.dataSourceTestFail(name));
                }
            }
            catch (Exception e) {
                throw Util.unchecked((Throwable)e);
            }
            return builder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> getCacheConfigDefaultAttributes(RestRequest request) {
        Configuration configuration = new ConfigurationBuilder().build();
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        ServerResource.allAttributes(configuration, attributes, configuration.elementName());
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), Json.make(attributes), ResourceUtil.isPretty(request));
    }

    private static void allAttributes(ConfigurationElement<?> element, Map<String, Object> attributes, String prefix) {
        LinkedHashMap<String, String> attributeMap = new LinkedHashMap<String, String>();
        for (Attribute attribute : element.attributes().attributes()) {
            AttributeDefinition definition = attribute.getAttributeDefinition();
            String value = attribute.getInitialValue() == null ? null : attribute.getInitialValue().toString();
            attributeMap.put(definition.name(), value);
        }
        Map relative = attributes;
        String[] path = prefix.split("\\.");
        for (int i = 0; i < path.length - 1; ++i) {
            String key = path[i];
            relative = (Map)relative.computeIfAbsent((String)key, ignore -> new LinkedHashMap());
        }
        relative.put((String)path[path.length - 1], attributeMap);
        for (ConfigurationElement child : element.children()) {
            ServerResource.allAttributes(child, attributes, prefix + "." + child.elementName());
        }
    }

    static class ServerInfo
    implements JsonSerialization {
        private final Json json;

        public ServerInfo(ServerManagement server) {
            this.json = Json.object((Object[])new Object[]{"version", Version.printVersion(), "cache-manager-name", server.getCacheManager().getName()});
        }

        public Json toJson() {
            return this.json;
        }
    }
}

