/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.distribution;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.manager.CacheManagerInfo;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.rest.distribution.NodeDataDistribution;
import org.infinispan.stats.Stats;

@ProtoTypeId(value=6000)
public class CacheDistributionInfo
implements JsonSerialization,
NodeDataDistribution {
    private final String name;
    private final List<String> addresses;
    private final long memoryEntries;
    private final long totalEntries;
    private final long memoryUsed;

    @ProtoFactory
    public CacheDistributionInfo(String name, List<String> addresses, long memoryEntries, long totalEntries, long memoryUsed) {
        this.name = name;
        this.addresses = addresses;
        this.memoryEntries = memoryEntries;
        this.totalEntries = totalEntries;
        this.memoryUsed = memoryUsed;
    }

    @Override
    @ProtoField(value=1)
    public String name() {
        return this.name;
    }

    @Override
    @ProtoField(value=2, collectionImplementation=ArrayList.class)
    public List<String> addresses() {
        return this.addresses;
    }

    @ProtoField(value=3, defaultValue="0")
    public long memoryEntries() {
        return this.memoryEntries;
    }

    @ProtoField(value=4, defaultValue="0")
    public long totalEntries() {
        return this.totalEntries;
    }

    @ProtoField(value=5, defaultValue="0")
    public long memoryUsed() {
        return this.memoryUsed;
    }

    public Json toJson() {
        return Json.object().set("node_name", (Object)this.name).set("node_addresses", Json.array((Object[])this.addresses.toArray())).set("memory_entries", (Object)this.memoryEntries).set("total_entries", (Object)this.totalEntries).set("memory_used", (Object)this.memoryUsed);
    }

    public static CacheDistributionInfo resolve(AdvancedCache<?, ?> cache) {
        CacheManagerInfo manager = cache.getCacheManager().getCacheManagerInfo();
        return CacheDistributionInfo.resolve(cache, manager);
    }

    public static CacheDistributionInfo resolve(AdvancedCache<?, ?> cache, CacheManagerInfo manager) {
        Stats stats = cache.getStats();
        long inMemory = stats.getApproximateEntriesInMemory();
        long total = stats.getApproximateEntries();
        return new CacheDistributionInfo(manager.getNodeName(), manager.getPhysicalAddressesRaw(), inMemory, total, stats.getDataMemoryUsed());
    }
}

