/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpContent;
import java.nio.charset.StandardCharsets;

public class ServerSentEvent
implements HttpContent {
    private static final byte[] EVENT = "event: ".getBytes();
    private static final byte[] NL = "\n".getBytes();
    private static final byte[] DATA = "data: ".getBytes();
    private final String event;
    private final String data;
    private DecoderResult decoderResult;

    public ServerSentEvent(String event, String data) {
        this.event = event;
        this.data = data;
    }

    public String toString() {
        return "ServerSentEvent{, event='" + this.event + "', data='" + this.data + "'}";
    }

    public HttpContent copy() {
        return this;
    }

    public HttpContent duplicate() {
        return this;
    }

    public HttpContent retainedDuplicate() {
        return this;
    }

    public HttpContent replace(ByteBuf content) {
        return this;
    }

    public HttpContent retain() {
        return this;
    }

    public HttpContent retain(int increment) {
        return this;
    }

    public HttpContent touch() {
        return this;
    }

    public HttpContent touch(Object hint) {
        return this;
    }

    public ByteBuf content() {
        ByteBuf b = Unpooled.buffer();
        if (this.event != null) {
            b.writeBytes(EVENT);
            b.writeBytes(this.event.getBytes(StandardCharsets.UTF_8));
            b.writeBytes(NL);
        }
        for (String line : this.data.split("\n")) {
            b.writeBytes(DATA);
            b.writeBytes(line.getBytes(StandardCharsets.UTF_8));
            b.writeBytes(NL);
        }
        b.writeBytes(NL);
        return b;
    }

    public DecoderResult getDecoderResult() {
        return this.decoderResult();
    }

    public DecoderResult decoderResult() {
        return this.decoderResult;
    }

    public void setDecoderResult(DecoderResult result) {
        this.decoderResult = result;
    }

    public int refCnt() {
        return 1;
    }

    public boolean release() {
        return false;
    }

    public boolean release(int i) {
        return false;
    }
}

