/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import org.hibernate.search.util.common.function.TriFunction;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.raft.RaftManager;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.distribution.NodeDistributionInfo;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.resources.BackupManagerResource;
import org.infinispan.rest.resources.ResourceUtil;
import org.infinispan.security.AuditContext;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.Security;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.core.BackupManager;
import org.infinispan.util.function.SerializableFunction;
import org.infinispan.util.function.TriConsumer;

public class ClusterResource
implements ResourceHandler {
    private static final String MEMBER_PARAMETER = "member";
    private final InvocationHelper invocationHelper;
    private final BackupManager backupManager;

    public ClusterResource(InvocationHelper invocationHelper) {
        this.invocationHelper = invocationHelper;
        this.backupManager = invocationHelper.getServer().getBackupManager();
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.POST).path("/v2/cluster").withAction("stop").permission(AuthorizationPermission.LIFECYCLE).name("CLUSTER STOP").auditContext(AuditContext.SERVER).handleWith(this::stop).invocation().method(Method.GET).path("/v2/cluster").withAction("distribution").permission(AuthorizationPermission.MONITOR).name("CLUSTER DISTRIBUTION").auditContext(AuditContext.SERVER).handleWith(this::distribution).invocation().methods(Method.GET, Method.HEAD).path("/v2/cluster/backups").permission(AuthorizationPermission.ADMIN).name("BACKUP NAMES").auditContext(AuditContext.SERVER).handleWith(this::getAllBackupNames).invocation().methods(Method.DELETE, Method.GET, Method.HEAD, Method.POST).path("/v2/cluster/backups/{backupName}").permission(AuthorizationPermission.ADMIN).name("BACKUP").auditContext(AuditContext.SERVER).handleWith(this::backup).invocation().methods(Method.GET).path("/v2/cluster/restores").permission(AuthorizationPermission.ADMIN).name("RESTORE NAMES").auditContext(AuditContext.SERVER).handleWith(this::getAllRestoreNames).invocation().methods(Method.DELETE, Method.HEAD, Method.POST).path("/v2/cluster/restores/{restoreName}").permission(AuthorizationPermission.ADMIN).name("RESTORE").auditContext(AuditContext.SERVER).handleWith(this::restore).invocation().methods(Method.GET).path("/v2/cluster/raft").permission(AuthorizationPermission.ADMIN).name("RAFT MEMBERS").auditContext(AuditContext.SERVER).handleWith(this::handleRaftMembers).invocation().methods(Method.POST, Method.PUT).path("/v2/cluster/raft/{member}").permission(AuthorizationPermission.ADMIN).name("RAFT ADD MEMBER").auditContext(AuditContext.SERVER).handleWith(this::handleAddRaftMember).invocation().methods(Method.DELETE).path("/v2/cluster/raft/{member}").permission(AuthorizationPermission.ADMIN).name("RAFT REMOVE MEMBER").auditContext(AuditContext.SERVER).handleWith(this::handleRemoveRaftMember).create();
    }

    private CompletionStage<RestResponse> stop(RestRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            List<String> servers = request.parameters().get("server");
            if (servers != null && !servers.isEmpty()) {
                Security.doAs((Subject)request.getSubject(), () -> this.invocationHelper.getServer().serverStop(servers));
            } else {
                Security.doAs((Subject)request.getSubject(), () -> this.invocationHelper.getServer().clusterStop());
            }
            return this.invocationHelper.newResponse(request).status(HttpResponseStatus.NO_CONTENT).build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> getAllBackupNames(RestRequest request) {
        BackupManager backupManager = this.invocationHelper.getServer().getBackupManager();
        Set names = (Set)Security.doAs((Subject)request.getSubject(), () -> ((BackupManager)backupManager).getBackupNames());
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), Json.make((Object)names), ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> backup(RestRequest request) {
        return BackupManagerResource.handleBackupRequest(this.invocationHelper, request, this.backupManager, (TriConsumer<String, Path, Json>)((TriConsumer)(name, workingDir, json) -> this.backupManager.create(name, workingDir)));
    }

    private CompletionStage<RestResponse> getAllRestoreNames(RestRequest request) {
        BackupManager backupManager = this.invocationHelper.getServer().getBackupManager();
        Set names = (Set)Security.doAs((Subject)request.getSubject(), () -> ((BackupManager)backupManager).getRestoreNames());
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), Json.make((Object)names), ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> restore(RestRequest request) {
        return BackupManagerResource.handleRestoreRequest(this.invocationHelper, request, this.backupManager, (TriFunction<String, Path, Json, CompletionStage<Void>>)((TriFunction)(name, path, json) -> this.backupManager.restore(name, path)));
    }

    private CompletionStage<RestResponse> distribution(RestRequest request) {
        boolean pretty = ResourceUtil.isPretty(request);
        return this.clusterDistribution().thenApply(distributions -> ResourceUtil.asJsonResponse(this.invocationHelper.newResponse(request), Json.array((Object[])distributions.stream().map(NodeDistributionInfo::toJson).toArray()), pretty));
    }

    private CompletionStage<List<NodeDistributionInfo>> clusterDistribution() {
        EmbeddedCacheManager cacheManager = this.invocationHelper.getProtocolServer().getCacheManager();
        List members = cacheManager.getMembers();
        if (members == null) {
            NodeDistributionInfo info2 = NodeDistributionInfo.resolve(cacheManager.getCacheManagerInfo(), SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)cacheManager));
            return CompletableFuture.completedFuture(Collections.singletonList(info2));
        }
        ConcurrentHashMap distributions = new ConcurrentHashMap(members.size());
        return SecurityActions.getClusterExecutor((EmbeddedCacheManager)cacheManager).submitConsumer((SerializableFunction & Serializable)ecm -> NodeDistributionInfo.resolve(ecm.getCacheManagerInfo(), SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)ecm)), (address, info, t) -> {
            if (t != null) {
                throw CompletableFutures.asCompletionException((Throwable)t);
            }
            distributions.putIfAbsent(address, info);
        }).thenApply(ignore -> {
            Collection collection = distributions.values();
            return Immutables.immutableListWrap((Object[])collection.toArray(new NodeDistributionInfo[0]));
        });
    }

    private CompletionStage<RestResponse> handleRaftMembers(RestRequest request) {
        RaftManager raftManager = this.raftManager();
        if (!raftManager.isRaftAvailable()) {
            return CompletableFuture.completedFuture(this.invocationHelper.noContentResponse(request));
        }
        boolean isPretty = ResourceUtil.isPretty(request);
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), Json.array((Collection)raftManager.raftMembers()), isPretty);
    }

    private CompletionStage<RestResponse> handleAddRaftMember(RestRequest request) {
        RaftManager raftManager = this.raftManager();
        if (!raftManager.isRaftAvailable()) {
            return CompletableFuture.completedFuture(this.invocationHelper.notFoundResponse(request));
        }
        String raftId = request.variables().get(MEMBER_PARAMETER);
        return raftManager.addMember(raftId).thenApply(unused -> this.invocationHelper.newResponse(request, HttpResponseStatus.OK));
    }

    private CompletionStage<RestResponse> handleRemoveRaftMember(RestRequest request) {
        RaftManager raftManager = this.raftManager();
        if (!raftManager.isRaftAvailable()) {
            return CompletableFuture.completedFuture(this.invocationHelper.notFoundResponse(request));
        }
        String raftId = request.variables().get(MEMBER_PARAMETER);
        return raftManager.removeMembers(raftId).thenApply(unused -> this.invocationHelper.newResponse(request, HttpResponseStatus.OK));
    }

    private RaftManager raftManager() {
        return SecurityActions.getRaftManager((EmbeddedCacheManager)this.invocationHelper.getRestCacheManager().getInstance());
    }
}

