/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.infinispan.CacheStream;
import org.infinispan.container.entries.InternalCacheEntry;

public class CacheEntryInputStream
extends InputStream {
    private static final byte[] KEY_LABEL = "\"key\":".getBytes();
    private static final byte[] VALUE_LABEL = "\"value\":".getBytes();
    private static final char OPEN_CHAR = '[';
    private static final char OPEN_ITEM_CHAR = '{';
    private static final char SEPARATOR = ',';
    private static final char CLOSE_ITEM_CHAR = '}';
    private static final char CLOSE_CHAR = ']';
    private final Iterator<? extends Map.Entry<?, ?>> iterator;
    private final Stream<? extends Map.Entry<?, ?>> stream;
    private final int batchSize;
    private boolean includeMetadata;
    private Map.Entry<?, ?> currentEntry;
    private byte[] currentMetadata;
    private int cursor = 0;
    private int keyCursor = 0;
    private int valueCursor = 0;
    private int mdCursor = 0;
    private int keyLabelCursor = 0;
    private int valueLabelCursor = 0;
    private Boolean hasNext;
    private State state = State.BEGIN;

    public CacheEntryInputStream(CacheStream<? extends Map.Entry<?, ?>> stream, int batchSize, boolean includeMetadata) {
        this.stream = stream.distributedBatchSize(batchSize);
        this.iterator = stream.iterator();
        this.hasNext = this.iterator.hasNext();
        this.includeMetadata = includeMetadata;
        this.batchSize = batchSize;
    }

    @Override
    public int available() {
        if (this.currentEntry == null) {
            return 0;
        }
        int keySize = ((byte[])this.currentEntry.getKey()).length;
        int valueSize = ((byte[])this.currentEntry.getValue()).length;
        int metadataSize = this.includeMetadata ? this.currentMetadata.length : 0;
        return keySize + valueSize + metadataSize - this.cursor * this.batchSize;
    }

    @Override
    public synchronized int read() {
        block13: while (true) {
            switch (this.state) {
                case BEGIN: {
                    this.state = this.hasNext != false ? State.BEGIN_ITEM : State.END;
                    return 91;
                }
                case BEGIN_ITEM: {
                    this.state = State.ITEM_KEY;
                    return 123;
                }
                case NEXT_ITEM: {
                    this.state = State.BEGIN_ITEM;
                    return 44;
                }
                case END_ITEM: {
                    this.state = this.hasNext != false ? State.NEXT_ITEM : State.END;
                    return 125;
                }
                case SEPARATOR_KEY: {
                    this.state = State.ITEM_VALUE;
                    return 44;
                }
                case SEPARATOR_VALUE: {
                    this.state = State.ITEM_METADATA;
                    return 44;
                }
                case SEPARATOR: {
                    if (this.hasNext.booleanValue()) {
                        this.state = State.ITEM_KEY;
                        return 44;
                    }
                    this.state = State.END;
                    continue block13;
                }
                case END: {
                    this.state = State.EOF;
                    this.stream.close();
                    return 93;
                }
                case ITEM_KEY: {
                    if (this.currentEntry == null && this.hasNext.booleanValue()) {
                        this.currentEntry = this.iterator.next();
                        if (this.includeMetadata) {
                            this.loadMetadata();
                        }
                    }
                    if (this.keyLabelCursor < KEY_LABEL.length) {
                        return KEY_LABEL[this.keyLabelCursor++] & 0xFF;
                    }
                    byte[] key = (byte[])this.currentEntry.getKey();
                    int ck = this.currentEntry == null || this.keyCursor == key.length ? -1 : key[this.keyCursor++] & 0xFF;
                    ++this.cursor;
                    if (ck != -1) {
                        return ck;
                    }
                    this.keyCursor = 0;
                    this.keyLabelCursor = 0;
                    this.state = State.SEPARATOR_KEY;
                    continue block13;
                }
                case ITEM_VALUE: {
                    if (this.valueLabelCursor < VALUE_LABEL.length) {
                        return VALUE_LABEL[this.valueLabelCursor++] & 0xFF;
                    }
                    byte[] value = (byte[])this.currentEntry.getValue();
                    int cv = this.valueCursor == value.length ? -1 : value[this.valueCursor++] & 0xFF;
                    ++this.cursor;
                    if (cv != -1) {
                        return cv;
                    }
                    this.valueCursor = 0;
                    this.valueLabelCursor = 0;
                    if (this.includeMetadata) {
                        this.state = State.SEPARATOR_VALUE;
                        continue block13;
                    }
                    this.endItem();
                    continue block13;
                }
                case ITEM_METADATA: {
                    int cm = this.mdCursor == this.currentMetadata.length ? -1 : this.currentMetadata[this.mdCursor++] & 0xFF;
                    ++this.cursor;
                    if (cm != -1) {
                        return cm;
                    }
                    this.endItem();
                    this.mdCursor = 0;
                    this.currentMetadata = null;
                    continue block13;
                }
            }
            break;
        }
        return -1;
    }

    private void endItem() {
        this.currentEntry = null;
        this.state = State.END_ITEM;
        this.hasNext = this.iterator.hasNext();
        this.cursor = 0;
    }

    private void loadMetadata() {
        if (this.currentEntry instanceof InternalCacheEntry) {
            long maxIdleInSeconds;
            InternalCacheEntry ice = (InternalCacheEntry)this.currentEntry;
            long lifespanInSeconds = ice.getLifespan();
            if (lifespanInSeconds > -1L) {
                lifespanInSeconds = TimeUnit.MILLISECONDS.toSeconds(lifespanInSeconds);
            }
            if ((maxIdleInSeconds = ice.getMaxIdle()) > -1L) {
                maxIdleInSeconds = TimeUnit.MILLISECONDS.toSeconds(maxIdleInSeconds);
            }
            long created = ice.getCreated();
            long lastUsed = ice.getLastUsed();
            long expiryTime = ice.getExpiryTime();
            this.currentMetadata = new Metadata(lifespanInSeconds, maxIdleInSeconds, created, lastUsed, expiryTime).bytes();
        } else {
            this.currentMetadata = Metadata.EMPTY;
        }
    }

    static class Metadata {
        public static final byte[] EMPTY = new Metadata().bytes();
        private final long timeToLiveSeconds;
        private final long maxIdleTimeSeconds;
        private final long created;
        private final long lastUsed;
        private final long expireTime;

        public Metadata() {
            this.timeToLiveSeconds = -1L;
            this.maxIdleTimeSeconds = -1L;
            this.created = -1L;
            this.lastUsed = -1L;
            this.expireTime = -1L;
        }

        public Metadata(long timeToLiveSeconds, long maxIdleTimeSeconds, long created, long lastUsed, long expireTime) {
            this.timeToLiveSeconds = timeToLiveSeconds;
            this.maxIdleTimeSeconds = maxIdleTimeSeconds;
            this.created = created;
            this.lastUsed = lastUsed;
            this.expireTime = expireTime;
        }

        public byte[] bytes() {
            return ("\"timeToLiveSeconds\": " + this.timeToLiveSeconds + ", \"maxIdleTimeSeconds\": " + this.maxIdleTimeSeconds + ", \"created\": " + this.created + ", \"lastUsed\": " + this.lastUsed + ", \"expireTime\": " + this.expireTime).getBytes();
        }
    }

    private static enum State {
        BEGIN,
        BEGIN_ITEM,
        NEXT_ITEM,
        ITEM_KEY,
        ITEM_VALUE,
        ITEM_METADATA,
        SEPARATOR_KEY,
        SEPARATOR_VALUE,
        END_ITEM,
        SEPARATOR,
        END,
        EOF;

    }
}

