/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.hll.internal;

import com.google.errorprone.annotations.ThreadSafe;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.server.resp.hll.internal.CompactSet;
import org.infinispan.server.resp.hll.internal.HLLRepresentation;
import org.infinispan.server.resp.hll.internal.Util;

@ThreadSafe
@ProtoTypeId(value=6102)
public class ExplicitSet
implements HLLRepresentation {
    private final Set<Long> storage;
    private final int threshold = 1 + CompactSet.STORE_SIZE / 8;

    public ExplicitSet() {
        this.storage = ConcurrentHashMap.newKeySet(this.threshold);
    }

    @ProtoFactory
    ExplicitSet(Set<Long> storage) {
        this();
        this.storage.addAll(storage);
    }

    @Override
    public boolean set(byte[] data) {
        long hash = Util.hash(data);
        return this.storage.add(hash);
    }

    @Override
    public long cardinality() {
        return this.storage.size();
    }

    public boolean needsMigration() {
        return this.storage.size() >= this.threshold;
    }

    public void migrate(CompactSet cs) {
        cs.readSource(this.storage);
    }

    @ProtoField(number=1, collectionImplementation=HashSet.class)
    Collection<Long> storage() {
        return new HashSet<Long>(this.storage);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExplicitSet that = (ExplicitSet)o;
        return Objects.equals(this.storage, that.storage);
    }

    public int hashCode() {
        return Objects.hash(this.storage);
    }
}

