/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.json;

import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespUtil;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.json.JSONCommandArgumentReader;
import org.infinispan.server.resp.json.EmbeddedJsonCache;
import org.infinispan.server.resp.serialization.Resp3Type;
import org.infinispan.server.resp.serialization.ResponseWriter;

public abstract class JSONLEN
extends RespCommand
implements Resp3Command {
    private final boolean includePathOnError;

    public JSONLEN(String commandName, long aclMask) {
        this(commandName, false, aclMask);
    }

    public JSONLEN(String commandName, boolean includePathOnError, long aclMask) {
        super(commandName, -2, 1, 1, 1, aclMask);
        this.includePathOnError = includePathOnError;
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        JSONCommandArgumentReader.CommandArgs commandArgs = JSONCommandArgumentReader.readCommandArgs(arguments);
        EmbeddedJsonCache ejc = handler.getJsonCache();
        CompletionStage<List<Long>> lengths = this.len(ejc, commandArgs.key(), commandArgs.jsonPath());
        if (commandArgs.isLegacy()) {
            return handler.stageToReturn(lengths, ctx, this.legacyOutput(commandArgs.path()));
        }
        return handler.stageToReturn(lengths, ctx, this.newArrayOrErrorWriter(commandArgs.path()));
    }

    protected abstract CompletionStage<List<Long>> len(EmbeddedJsonCache var1, byte[] var2, byte[] var3);

    BiConsumer<List<Long>, ResponseWriter> newArrayOrErrorWriter(byte[] path) {
        return (c, writer) -> {
            if (c == null) {
                if (this.includePathOnError) {
                    this.raiseTypeError(path);
                }
                throw new RuntimeException("could not perform this operation on a key that doesn't exist");
            }
            writer.array((Collection<?>)c, Resp3Type.INTEGER);
        };
    }

    protected abstract void raiseTypeError(byte[] var1);

    BiConsumer<List<Long>, ResponseWriter> legacyOutput(byte[] path) {
        return (c, writer) -> {
            if (c == null) {
                writer.nulls();
            } else {
                if (c.isEmpty()) {
                    throw new RuntimeException("Path '" + RespUtil.ascii(path) + "' does not exist");
                }
                if (c.get(0) == null) {
                    this.raiseTypeError(path);
                } else {
                    writer.integers((Number)c.get(0));
                }
            }
        };
    }
}

