/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.iteration;

import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.server.core.iteration.IterableIterationResult;
import org.infinispan.server.core.iteration.IterationInitializationContext;
import org.infinispan.server.core.iteration.IterationManager;
import org.infinispan.server.core.iteration.IterationState;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.iteration.IterationArguments;
import org.infinispan.server.resp.serialization.Resp3Type;
import org.infinispan.server.resp.serialization.ResponseWriter;
import org.infinispan.util.concurrent.BlockingManager;

public abstract class BaseIterationCommand
extends RespCommand
implements Resp3Command {
    private static final String INITIAL_CURSOR = "0";

    protected BaseIterationCommand(int arity, int firstKeyPos, int lastKeyPos, int steps, long aclMask) {
        super(arity, firstKeyPos, lastKeyPos, steps, aclMask);
    }

    protected byte[] getMatch(List<byte[]> arguments) {
        return null;
    }

    @Override
    public final CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        IterationArguments args = IterationArguments.parse(handler, arguments, this.getMatch(arguments));
        if (args == null) {
            return handler.myStage();
        }
        IterationManager manager = this.retrieveIterationManager(handler);
        String cursor = this.cursor(arguments);
        if (INITIAL_CURSOR.equals(cursor)) {
            CompletionStage<IterationInitializationContext> initialization = this.initializeIteration(handler, arguments);
            if (initialization != null) {
                return handler.stageToReturn(initialization.thenCompose(iic -> this.initializeAndIterate(handler, ctx, manager, args, (IterationInitializationContext)iic)), ctx);
            }
            return this.initializeAndIterate(handler, ctx, manager, args, null);
        }
        return this.iterate(handler, ctx, manager, cursor, args);
    }

    private CompletionStage<RespRequestHandler> initializeAndIterate(Resp3Handler handler, ChannelHandlerContext ctx, IterationManager manager, IterationArguments arguments, IterationInitializationContext iic) {
        AdvancedCache cache = handler.cache().withMediaType(MediaType.APPLICATION_OCTET_STREAM, null);
        IterationState iterationState = manager.start(cache, null, arguments.getFilterConverterFactory(), arguments.getFilterConverterParams(), null, arguments.getCount(), false, DeliveryGuarantee.AT_LEAST_ONCE, iic);
        iterationState.getReaper().registerChannel(ctx.channel());
        return this.iterate(handler, ctx, manager, iterationState.getId(), arguments);
    }

    private CompletionStage<RespRequestHandler> iterate(Resp3Handler handler, ChannelHandlerContext ctx, IterationManager manager, String cursor, IterationArguments arguments) {
        CompletionStage<IterableIterationResult> cs = this.acquireNext(handler.getBlockingManager(), manager, cursor, arguments.getCount());
        return cs.thenAcceptAsync(result -> this.handleIterationResult((IterableIterationResult)result, handler, manager, cursor), (Executor)ctx.executor()).thenApply(ignore -> handler);
    }

    private void handleIterationResult(IterableIterationResult result, Resp3Handler handler, IterationManager manager, String cursor) {
        IterableIterationResult.Status status = result.getStatusCode();
        if (status == IterableIterationResult.Status.InvalidIteration) {
            this.emptyIterationResponse(handler);
        } else {
            String replyCursor;
            if (!this.writeCursor()) {
                handler.writer().array(this.writeResponse(result.getEntries()), Resp3Type.BULK_STRING);
                return;
            }
            if (status == IterableIterationResult.Status.Finished) {
                replyCursor = INITIAL_CURSOR;
                manager.close(cursor);
            } else {
                replyCursor = cursor;
            }
            ResponseWriter writer = handler.writer();
            writer.array(List.of(replyCursor, this.writeResponse(result.getEntries())), (o, w) -> {
                if (o instanceof Collection) {
                    w.array((Collection)o, Resp3Type.BULK_STRING);
                } else {
                    w.string((CharSequence)o);
                }
            });
        }
    }

    private CompletionStage<IterableIterationResult> acquireNext(BlockingManager bm, IterationManager manager, String cursor, int count) {
        return bm.supplyBlocking(() -> manager.next(cursor, count), (Object)("resp-iter-" + cursor));
    }

    private void emptyIterationResponse(Resp3Handler handler) {
        ResponseWriter writer = handler.writer();
        writer.array(List.of(INITIAL_CURSOR, Collections.emptyList()), (o, w) -> {
            if (o instanceof String) {
                w.string(INITIAL_CURSOR);
            } else {
                w.arrayEmpty();
            }
        });
    }

    protected boolean writeCursor() {
        return true;
    }

    protected abstract IterationManager retrieveIterationManager(Resp3Handler var1);

    protected CompletionStage<IterationInitializationContext> initializeIteration(Resp3Handler handler, List<byte[]> arguments) {
        return null;
    }

    protected abstract String cursor(List<byte[]> var1);

    protected abstract Collection<byte[]> writeResponse(List<CacheEntry> var1);
}

