/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.serialization.bytebuf;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.serialization.RespConstants;
import org.infinispan.server.resp.serialization.ResponseSerializer;

final class ByteBufDoubleSerializer
implements ResponseSerializer<Double, ByteBufPool> {
    static final ByteBufDoubleSerializer INSTANCE = new ByteBufDoubleSerializer();
    private static final byte[] NAN = new byte[]{110, 97, 110};
    private static final byte[] INF = new byte[]{105, 110, 102};

    ByteBufDoubleSerializer() {
    }

    @Override
    public void accept(Double d, ByteBufPool alloc) {
        if (d.isNaN()) {
            this.writeNaN(alloc);
            return;
        }
        if (d.isInfinite()) {
            this.writeInfinite(d >= 0.0, alloc);
            return;
        }
        byte[] transformed = this.serializeDouble(d);
        int size = 1 + transformed.length + RespConstants.CRLF.length;
        alloc.acquire(size).writeByte(44).writeBytes(transformed).writeBytes(RespConstants.CRLF);
    }

    private void writeNaN(ByteBufPool alloc) {
        int size = 1 + NAN.length + RespConstants.CRLF.length;
        alloc.acquire(size).writeByte(44).writeBytes(NAN).writeBytes(RespConstants.CRLF);
    }

    private void writeInfinite(boolean positive, ByteBufPool alloc) {
        int size = 1 + (positive ? 0 : 1) + INF.length + RespConstants.CRLF.length;
        ByteBuf buffer = alloc.acquire(size).writeByte(44);
        if (!positive) {
            buffer.writeByte(45);
        }
        buffer.writeBytes(INF).writeBytes(RespConstants.CRLF);
    }

    private byte[] serializeDouble(double value) {
        return Double.toString(value).getBytes(StandardCharsets.US_ASCII);
    }

    @Override
    public boolean test(Object object) {
        return object instanceof Double || object instanceof Float;
    }
}

