/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.server.core.transport.ConnectionMetadata;
import org.infinispan.server.resp.CacheRespRequestHandler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.authentication.RespAuthenticator;
import org.infinispan.server.resp.commands.AuthResp3Command;
import org.infinispan.server.resp.configuration.RespServerConfiguration;

public class Resp3AuthHandler
extends CacheRespRequestHandler {
    public Resp3AuthHandler(RespServer server) {
        this(server, server.getCache());
    }

    protected Resp3AuthHandler(RespServer server, AdvancedCache<byte[], byte[]> cache) {
        super(server, cache);
    }

    @Override
    protected CompletionStage<RespRequestHandler> actualHandleRequest(ChannelHandlerContext ctx, RespCommand command, List<byte[]> arguments) {
        if (command instanceof AuthResp3Command) {
            AuthResp3Command authCommand = (AuthResp3Command)((Object)command);
            return authCommand.perform(this, ctx, arguments);
        }
        if (this.isAuthorized()) {
            return super.actualHandleRequest(ctx, command, arguments);
        }
        this.handleUnauthorized(ctx);
        return this.myStage;
    }

    public CompletionStage<Boolean> performAuth(ChannelHandlerContext ctx, byte[] username, byte[] password) {
        return this.performAuth(ctx, new String(username, StandardCharsets.UTF_8), new String(password, StandardCharsets.UTF_8));
    }

    public CompletionStage<Boolean> performAuth(ChannelHandlerContext ctx) {
        return this.performAuth(ctx, (String)null, null);
    }

    private CompletionStage<Boolean> performAuth(ChannelHandlerContext ctx, String username, String password) {
        CompletableFuture authentication;
        RespAuthenticator authenticator = ((RespServerConfiguration)this.respServer.getConfiguration()).authentication().authenticator();
        if (authenticator == null) {
            return CompletableFutures.booleanStage((boolean)this.handleAuthResponse(ctx, null));
        }
        if (username == null && password == null) {
            try {
                authentication = this.canUseCertAuth() ? authenticator.clientCertAuth(ctx.channel()) : CompletableFutures.completedNull();
            }
            catch (SaslException e) {
                throw CompletableFutures.asCompletionException((Throwable)e);
            }
        } else {
            authentication = authenticator.usernamePasswordAuth(username, password.toCharArray());
        }
        return authentication.thenApplyAsync(r -> this.handleAuthResponse(ctx, (Subject)r), (Executor)ctx.channel().eventLoop()).exceptionally(t -> false);
    }

    private boolean handleAuthResponse(ChannelHandlerContext ctx, Subject subject) {
        assert (ctx.channel().eventLoop().inEventLoop());
        if (subject == null) {
            return false;
        }
        ConnectionMetadata metadata = ConnectionMetadata.getInstance((Channel)ctx.channel());
        metadata.subject(subject);
        this.setCache((AdvancedCache<byte[], byte[]>)this.cache().withSubject(subject));
        return true;
    }

    private void handleUnauthorized(ChannelHandlerContext ctx) {
        assert (ctx.channel().eventLoop().inEventLoop());
        this.writer().unauthorized();
    }

    public boolean isAuthorized() {
        return this.getClass() != Resp3AuthHandler.class;
    }

    public boolean canUseCertAuth() {
        RespAuthenticator authenticator = ((RespServerConfiguration)this.respServer.getConfiguration()).authentication().authenticator();
        return authenticator != null && authenticator.isClientCertAuthEnabled();
    }
}

