/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.serialization.bytebuf;

import java.util.ArrayList;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.serialization.NestedResponseSerializer;
import org.infinispan.server.resp.serialization.ResponseSerializer;
import org.infinispan.server.resp.serialization.SerializationHint;
import org.infinispan.server.resp.serialization.bytebuf.ByteBufBigNumberSerializer;
import org.infinispan.server.resp.serialization.bytebuf.ByteBufCollectionSerializer;
import org.infinispan.server.resp.serialization.bytebuf.ByteBufDoubleSerializer;
import org.infinispan.server.resp.serialization.bytebuf.ByteBufMapSerializer;
import org.infinispan.server.resp.serialization.bytebuf.ByteBufPrimitiveSerializer;
import org.infinispan.server.resp.serialization.bytebuf.ByteBufThrowableSerializer;

final class ByteBufSerializerRegistry {
    private static final ResponseSerializer<?, ByteBufPool>[] serializers;

    private ByteBufSerializerRegistry() {
    }

    static void serialize(Object value, ByteBufPool alloc) {
        ByteBufSerializerRegistry.serialize(value, alloc, serializers);
    }

    static void serialize(Object value, ByteBufPool alloc, ResponseSerializer<?, ByteBufPool>[] candidates) {
        if (ByteBufPrimitiveSerializer.NullSerializer.INSTANCE.test(value)) {
            ByteBufPrimitiveSerializer.NullSerializer.INSTANCE.accept((Object)null, alloc);
            return;
        }
        for (ResponseSerializer<?, ByteBufPool> serializer : candidates) {
            if (!serializer.test(value)) continue;
            ByteBufSerializerRegistry.serialize(serializer, value, alloc);
            return;
        }
        throw new IllegalStateException("Serializer unknown: " + String.valueOf(value.getClass()));
    }

    static void serialize(Object value, ByteBufPool alloc, ResponseSerializer<?, ByteBufPool> candidate) {
        if (ByteBufPrimitiveSerializer.NullSerializer.INSTANCE.test(value)) {
            ByteBufPrimitiveSerializer.NullSerializer.INSTANCE.accept((Object)null, alloc);
            return;
        }
        if (!candidate.test(value)) {
            throw new IllegalStateException("Serializer not handling: " + String.valueOf(value.getClass()));
        }
        ByteBufSerializerRegistry.serialize(candidate, value, alloc);
    }

    static <H extends SerializationHint> void serialize(Object value, ByteBufPool alloc, NestedResponseSerializer<?, ByteBufPool, H> candidate, H hint) {
        if (ByteBufPrimitiveSerializer.NullSerializer.INSTANCE.test(value)) {
            ByteBufPrimitiveSerializer.NullSerializer.INSTANCE.accept((Object)null, alloc);
            return;
        }
        if (!candidate.test(value)) {
            throw new IllegalStateException("Serializer not handling: " + String.valueOf(value.getClass()));
        }
        NestedResponseSerializer<?, ByteBufPool, H> nrs = candidate;
        nrs.accept(value, alloc, hint);
    }

    private static void serialize(ResponseSerializer<?, ByteBufPool> serializer, Object value, ByteBufPool alloc) {
        ResponseSerializer<?, ByteBufPool> s = serializer;
        s.accept(value, alloc);
    }

    static {
        ArrayList s = new ArrayList(ByteBufPrimitiveSerializer.SERIALIZERS);
        s.add(ByteBufCollectionSerializer.ArraySerializer.INSTANCE);
        s.add(ByteBufCollectionSerializer.SetSerializer.INSTANCE);
        s.add(ByteBufDoubleSerializer.INSTANCE);
        s.add(ByteBufThrowableSerializer.INSTANCE);
        s.add(ByteBufMapSerializer.INSTANCE);
        s.add(ByteBufBigNumberSerializer.INSTANCE);
        serializers = (ResponseSerializer[])s.toArray(ResponseSerializer[]::new);
    }
}

