/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.sortedset;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.multimap.impl.EmbeddedMultimapSortedSetCache;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.sortedset.ZSetCommonUtils;
import org.infinispan.server.resp.serialization.ResponseWriter;

public class ZRANDMEMBER
extends RespCommand
implements Resp3Command {
    public ZRANDMEMBER() {
        super(-2, 1, 1, 1);
    }

    @Override
    public long aclMask() {
        return AclCategory.READ | AclCategory.SORTEDSET | AclCategory.SLOW;
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        boolean withScores;
        byte[] name = arguments.get(0);
        int count = 1;
        if (arguments.size() > 1) {
            try {
                count = ArgumentUtils.toInt(arguments.get(1));
            }
            catch (NumberFormatException ex) {
                handler.writer().valueNotInteger();
                return handler.myStage();
            }
        }
        if (arguments.size() > 2) {
            withScores = ZSetCommonUtils.isWithScoresArg(arguments.get(2));
            if (!withScores) {
                handler.writer().syntaxError();
                return handler.myStage();
            }
        } else {
            withScores = false;
        }
        EmbeddedMultimapSortedSetCache<byte[], byte[]> sortedSetCache = handler.getSortedSeMultimap();
        CompletionStage randomMembers = sortedSetCache.randomMembers((Object)name, count);
        if (arguments.size() == 1) {
            return handler.stageToReturn(randomMembers.thenApply(r -> r.isEmpty() ? null : (byte[])((ScoredValue)r.get(0)).getValue()), ctx, ResponseWriter.BULK_STRING_BYTES);
        }
        return handler.stageToReturn(randomMembers.thenApply(r -> ZSetCommonUtils.response(r, withScores)), ctx, ResponseWriter.CUSTOM);
    }
}

