/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.generic;

import io.netty.channel.ChannelHandlerContext;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.metadata.Metadata;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.serialization.ResponseWriter;

public class RENAME
extends RespCommand
implements Resp3Command {
    public RENAME() {
        super(3, 1, 2, 1);
    }

    @Override
    public long aclMask() {
        return AclCategory.KEYSPACE | AclCategory.WRITE | AclCategory.SLOW;
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        byte[] srcKey = arguments.get(0);
        byte[] dstKey = arguments.get(1);
        return RENAME.rename(handler, srcKey, dstKey, ctx, ResponseWriter.OK);
    }

    public static CompletionStage<RespRequestHandler> rename(Resp3Handler handler, byte[] srcKey, byte[] dstKey, ChannelHandlerContext ctx, BiConsumer<?, ResponseWriter> consumer) {
        BiConsumer<?, ResponseWriter> bc = consumer;
        MediaType vmt = handler.cache().getValueDataConversion().getStorageMediaType();
        AdvancedCache acm = handler.typedCache(vmt);
        CompletionStage cs = acm.removeAsyncEntry((Object)srcKey).thenCompose(e -> {
            if (e == null) {
                return CompletableFutures.completedNull();
            }
            if (Arrays.equals(srcKey, dstKey)) {
                return CompletableFuture.completedFuture(1L);
            }
            TimeService timeService = handler.respServer().getTimeService();
            if (e.getLifespan() <= 0L) {
                Metadata.Builder newMeta = e.getMetadata().builder();
                return acm.putAsyncEntry((Object)dstKey, e.getValue(), newMeta.build()).thenApply(ignore -> 1L);
            }
            long newLifespan = e.getLifespan() + e.getCreated() - timeService.wallClockTime();
            if (newLifespan > 0L) {
                Metadata.Builder newMeta = e.getMetadata().builder().lifespan(newLifespan);
                return acm.putAsyncEntry((Object)dstKey, e.getValue(), newMeta.build()).thenApply(ignore -> 1L);
            }
            return CompletableFuture.completedFuture(1L);
        });
        return handler.stageToReturn(cs, ctx, (l, writer) -> {
            if (l != null) {
                bc.accept(l, (ResponseWriter)writer);
            } else {
                writer.noSuchKey();
            }
        });
    }
}

