/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.text;

import io.netty.buffer.ByteBuf;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.Version;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.context.Flag;
import org.infinispan.metadata.Metadata;
import org.infinispan.server.core.transport.ExtendedByteBuf;
import org.infinispan.server.memcached.MemcachedInboundAdapter;
import org.infinispan.server.memcached.MemcachedMetadata;
import org.infinispan.server.memcached.MemcachedResponse;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.MemcachedStats;
import org.infinispan.server.memcached.ParseUtil;
import org.infinispan.server.memcached.text.TextCommand;
import org.infinispan.server.memcached.text.TextConstants;
import org.infinispan.server.memcached.text.TextDecoder;
import org.infinispan.server.memcached.text.TextHeader;

public abstract class TextOpDecoder
extends TextDecoder {
    protected TextOpDecoder(MemcachedServer server, Subject subject) {
        super(server, subject);
    }

    protected MemcachedResponse get(TextHeader header, List<byte[]> keys, boolean withVersions) {
        int numberOfKeys = keys.size();
        if (numberOfKeys > 1) {
            CacheEntry[] arr = new CacheEntry[numberOfKeys];
            List<CacheEntry<byte[], byte[]>> entries = Collections.synchronizedList(Arrays.asList(arr));
            AggregateCompletionStage acs = CompletionStages.aggregateCompletionStage(entries);
            for (int i = 0; i < numberOfKeys; ++i) {
                acs.dependsOn(this.doGetMultipleKeys(keys, entries, i));
            }
            CompletionStage cs = acs.freeze();
            if (CompletionStages.isCompletedSuccessfully((CompletionStage)cs)) {
                return this.send(header, CompletableFuture.completedFuture(this.createMultiGetResponse(entries)));
            }
            return this.send(header, cs.thenApply(this::createMultiGetResponse));
        }
        byte[] key = keys.get(0);
        CompletableFuture cs = this.cache.getCacheEntryAsync((Object)key);
        if (CompletionStages.isCompletedSuccessfully((CompletionStage)cs)) {
            return this.send(header, CompletableFuture.completedFuture(TextOpDecoder.createGetResponse(key, (CacheEntry<byte[], byte[]>)((CacheEntry)CompletionStages.join((CompletionStage)cs)), withVersions)));
        }
        return this.send(header, cs.thenApply(entry -> TextOpDecoder.createGetResponse(key, (CacheEntry<byte[], byte[]>)entry, withVersions)));
    }

    protected MemcachedResponse set(TextHeader header, byte[] key, byte[] value, int flags, int expiration, boolean quiet) {
        CompletableFuture cs = this.cache.withFlags(Flag.IGNORE_RETURN_VALUES).putAsync((Object)key, (Object)value, this.metadata(flags, expiration));
        if (CompletionStages.isCompletedSuccessfully((CompletionStage)cs)) {
            return this.send(header, CompletableFuture.completedFuture(this.createSuccessResponse(TextCommand.set, quiet)));
        }
        return this.send(header, cs.thenApply(unused -> this.createSuccessResponse(TextCommand.set, quiet)));
    }

    protected MemcachedResponse delete(TextHeader header, byte[] key, boolean quiet) {
        return this.send(header, this.cache.removeAsync((Object)key).thenApply(prev -> prev == null ? this.createNotExistResponse(TextCommand.delete, quiet) : this.createSuccessResponse(TextCommand.delete, quiet)));
    }

    protected MemcachedResponse concat(TextHeader header, byte[] key, byte[] value, int flags, int expiration, boolean quiet, boolean append) {
        return this.send(header, this.cache.getAsync((Object)key).thenCompose(prev -> {
            if (prev == null) {
                return CompletableFuture.completedFuture(quiet ? null : TextConstants.NOT_STORED);
            }
            byte[] concatenated = append ? TextOpDecoder.concat(prev, value) : TextOpDecoder.concat(value, prev);
            return this.cache.replaceAsync((Object)key, prev, (Object)concatenated, this.metadata(flags, expiration)).thenApply(replaced -> replaced.booleanValue() ? (quiet ? null : TextConstants.STORED) : (byte[])(quiet ? null : TextConstants.NOT_STORED));
        }));
    }

    protected MemcachedResponse replace(TextHeader header, byte[] key, byte[] value, int flags, int expiration, boolean quiet) {
        return this.send(header, ((CompletableFuture)this.cache.withFlags(Flag.SKIP_LISTENER_NOTIFICATION).getAsync((Object)key).thenCompose(prev -> prev == null ? CompletableFutures.completedNull() : this.cache.replaceAsync((Object)key, (Object)value, this.metadata(flags, expiration)))).thenApply(prev -> prev == null ? this.createNotExecutedResponse(TextCommand.replace, quiet) : this.createSuccessResponse(TextCommand.replace, quiet)));
    }

    protected MemcachedResponse add(TextHeader header, byte[] key, byte[] value, int flags, int expiration, boolean quiet) {
        return this.send(header, ((CompletableFuture)this.cache.getAsync((Object)key).thenCompose(prev -> prev == null ? this.cache.putIfAbsentAsync((Object)key, (Object)value, this.metadata(flags, expiration)) : CompletableFuture.completedFuture(prev))).thenApply(prev -> prev == null ? this.createSuccessResponse(TextCommand.add, quiet) : this.createNotExecutedResponse(TextCommand.add, quiet)));
    }

    protected MemcachedResponse cas(TextHeader header, byte[] key, byte[] value, int flags, int expiration, long cas, boolean quiet) {
        return this.send(header, this.cache.withFlags(Flag.SKIP_LISTENER_NOTIFICATION).getCacheEntryAsync((Object)key).thenCompose(entry -> {
            if (entry == null) {
                return CompletableFuture.completedFuture(this.createNotExistResponse(TextCommand.cas, quiet));
            }
            NumericVersion streamVersion = new NumericVersion(cas);
            if (!entry.getMetadata().version().equals((Object)streamVersion)) {
                return CompletableFuture.completedFuture(this.createNotExecutedResponse(TextCommand.cas, quiet));
            }
            byte[] prev = (byte[])entry.getValue();
            return this.cache.replaceAsync((Object)key, (Object)prev, (Object)value, this.metadata(flags, expiration)).thenApply(replaced -> replaced != false ? this.createSuccessResponse(TextCommand.cas, quiet) : this.createNotExecutedResponse(TextCommand.cas, quiet));
        }));
    }

    protected MemcachedResponse touch(TextHeader header, byte[] key, int expiration, boolean quiet) {
        return this.send(header, this.cache.getCacheEntryAsync((Object)key).thenCompose(entry -> {
            if (entry == null) {
                return CompletableFuture.completedFuture(this.createNotExistResponse(TextCommand.touch, quiet));
            }
            return this.cache.replaceAsync((Object)((byte[])entry.getKey()), (Object)((byte[])entry.getValue()), this.touchMetadata((CacheEntry<?, ?>)entry, expiration)).thenApply(unused -> TextOpDecoder.createTouchedResponse(quiet));
        }));
    }

    protected MemcachedResponse gat(TextHeader header, int expiration, List<byte[]> keys, boolean withVersions) {
        int numberOfKeys = keys.size();
        if (numberOfKeys > 1) {
            CacheEntry[] arr = new CacheEntry[numberOfKeys];
            List<CacheEntry<byte[], byte[]>> entries = Collections.synchronizedList(Arrays.asList(arr));
            CompletionStage<Void> lastStage = this.doGatMultipleKeys(keys, entries, expiration, 0);
            int i = 1;
            while (i < numberOfKeys) {
                int idx = i++;
                lastStage = lastStage.thenCompose(unused -> this.doGatMultipleKeys(keys, entries, expiration, idx));
            }
            return this.send(header, lastStage.thenApply(unused -> this.createMultiGetResponse(entries)));
        }
        byte[] key = keys.get(0);
        return this.send(header, this.cache.getCacheEntryAsync((Object)key).thenCompose(entry -> {
            if (entry == null) {
                return CompletableFuture.completedFuture(TextConstants.END);
            }
            return this.cache.replaceAsync((Object)((byte[])entry.getKey()), (Object)((byte[])entry.getValue()), this.touchMetadata((CacheEntry<?, ?>)entry, expiration)).thenApply(unused -> TextOpDecoder.createGetResponse(key, (CacheEntry<byte[], byte[]>)entry, withVersions));
        }));
    }

    protected MemcachedResponse md(TextHeader header, byte[] key, List<byte[]> args) {
        throw new UnsupportedOperationException();
    }

    protected MemcachedResponse ma(TextHeader header, byte[] key, List<byte[]> args) {
        throw new UnsupportedOperationException();
    }

    protected MemcachedResponse me(TextHeader header, byte[] key, List<byte[]> args) {
        throw new UnsupportedOperationException();
    }

    protected MemcachedResponse mn(TextHeader header) {
        return this.send(header, CompletableFuture.completedFuture(TextConstants.MN));
    }

    protected MemcachedResponse ms(TextHeader header, byte[] key, byte[] value, List<byte[]> args) {
        throw new UnsupportedOperationException();
    }

    protected MemcachedResponse mg(TextHeader header, byte[] key, List<byte[]> args) {
        throw new UnsupportedOperationException();
    }

    private Object createMultiGetResponse(List<CacheEntry<byte[], byte[]>> entries) {
        int size = (int)entries.stream().filter(e -> e != null && e.getValue() != null).count();
        ByteBuf[] elements = new ByteBuf[size + 1];
        int i = 0;
        for (CacheEntry<byte[], byte[]> entry : entries) {
            if (entry == null || entry.getValue() == null) continue;
            elements[i++] = TextOpDecoder.buildGetResponse(entry);
        }
        elements[i] = ExtendedByteBuf.wrappedBuffer((byte[][])new byte[][]{TextConstants.END});
        return elements;
    }

    private CompletionStage<Void> doGetMultipleKeys(List<byte[]> keys, List<CacheEntry<byte[], byte[]>> entries, int i) {
        try {
            return this.cache.getCacheEntryAsync((Object)keys.get(i)).thenAccept(entry -> entries.set(i, (CacheEntry<byte[], byte[]>)entry));
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    private CompletionStage<Void> doGatMultipleKeys(List<byte[]> keys, List<CacheEntry<byte[], byte[]>> entries, int expiration, int idx) {
        return this.cache.getCacheEntryAsync((Object)keys.get(idx)).thenCompose(entry -> {
            if (entry == null) {
                return CompletableFutures.completedNull();
            }
            return this.cache.replaceAsync((Object)((byte[])entry.getKey()), (Object)((byte[])entry.getValue()), this.touchMetadata((CacheEntry<?, ?>)entry, expiration)).thenAccept(unused -> entries.set(idx, (CacheEntry<byte[], byte[]>)entry));
        });
    }

    protected MemcachedResponse flush_all(TextHeader header, List<byte[]> varargs) {
        boolean noreply = false;
        int delay = 0;
        for (byte[] arg : varargs) {
            String s = new String(arg, StandardCharsets.US_ASCII);
            if ("noreply".equals(s)) {
                noreply = true;
                continue;
            }
            delay = ParseUtil.readInt(arg);
        }
        boolean quiet = noreply;
        if (delay == 0) {
            return this.send(header, this.cache.clearAsync().thenApply(unused -> quiet ? null : TextConstants.OK));
        }
        this.server.getScheduler().schedule(() -> ((AdvancedCache)this.cache).clear(), this.toMillis(delay), TimeUnit.MILLISECONDS);
        return this.send(header, CompletableFuture.completedFuture(quiet ? null : TextConstants.OK));
    }

    protected MemcachedResponse version(TextHeader header) {
        return this.send(header, CompletableFuture.completedFuture("VERSION " + Version.getVersion() + "\r\n"));
    }

    protected void quit(TextHeader header) {
        this.ctx.close();
    }

    protected MemcachedResponse incr(TextHeader header, byte[] key, byte[] delta, boolean quiet, boolean isIncrement) {
        return this.send(header, this.cache.getAsync((Object)key).thenCompose(prev -> {
            BigInteger candidateCounter;
            if (prev == null) {
                if (this.statsEnabled) {
                    if (isIncrement) {
                        MemcachedStats.INCR_MISSES.incrementAndGet(this.statistics);
                    } else {
                        MemcachedStats.DECR_MISSES.incrementAndGet(this.statistics);
                    }
                }
                return CompletableFuture.completedFuture(quiet ? null : TextConstants.NOT_FOUND);
            }
            BigInteger prevCounter = new BigInteger(new String((byte[])prev));
            BigInteger d = this.validateDelta(new String(delta, StandardCharsets.US_ASCII));
            candidateCounter = isIncrement ? ((candidateCounter = prevCounter.add(d)).compareTo(TextConstants.MAX_UNSIGNED_LONG) > 0 ? TextConstants.MIN_UNSIGNED : candidateCounter) : ((candidateCounter = prevCounter.subtract(d)).compareTo(TextConstants.MIN_UNSIGNED) < 0 ? TextConstants.MIN_UNSIGNED : candidateCounter);
            String counterString = candidateCounter.toString();
            return this.cache.replaceAsync((Object)key, prev, (Object)counterString.getBytes(), this.metadata(0, 0)).thenApply(replaced -> {
                if (!replaced.booleanValue()) {
                    throw CompletableFutures.asCompletionException((Throwable)new CacheException("Value modified since we retrieved from the cache, old value was " + String.valueOf(prevCounter)));
                }
                if (this.statsEnabled) {
                    if (isIncrement) {
                        MemcachedStats.INCR_HITS.incrementAndGet(this.statistics);
                    } else {
                        MemcachedStats.DECR_HITS.incrementAndGet(this.statistics);
                    }
                }
                return quiet ? null : counterString + "\r\n";
            });
        }));
    }

    protected MemcachedResponse stats(TextHeader header, List<byte[]> names) {
        return this.send(header, this.server.getBlockingManager().runBlocking(() -> {
            Map<byte[], byte[]> stats = this.statsMap();
            ByteBuf buf = MemcachedInboundAdapter.getAllocator(this.ctx).acquire(1024);
            if (names.isEmpty()) {
                for (Map.Entry<byte[], byte[]> stat : stats.entrySet()) {
                    TextOpDecoder.stat(buf, stat.getKey(), stat.getValue());
                }
            } else {
                for (byte[] name : names) {
                    if (stats.containsKey(name)) continue;
                    buf.writeCharSequence((CharSequence)"CLIENT_ERROR\r\n", StandardCharsets.US_ASCII);
                    return;
                }
                for (byte[] name : names) {
                    TextOpDecoder.stat(buf, name, stats.get(name));
                }
            }
            buf.writeBytes(TextConstants.END);
        }, (Object)"memcached-stats"));
    }

    private static void stat(ByteBuf buf, byte[] name, byte[] value) {
        if (value != null) {
            buf.writeCharSequence((CharSequence)"STAT ", StandardCharsets.US_ASCII);
            buf.writeBytes(name);
            buf.writeByte(32);
            buf.writeBytes(value);
            buf.writeBytes(TextConstants.CRLFBytes);
        }
    }

    private CompletionStage<Void> doGetMultipleKeys(byte[] key, Map<byte[], CacheEntry<byte[], byte[]>> responses) {
        try {
            return this.cache.getCacheEntryAsync((Object)key).thenAccept(entry -> {
                if (entry != null) {
                    responses.put(key, (CacheEntry<byte[], byte[]>)entry);
                }
            });
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    private Object createSuccessResponse(TextCommand cmd, boolean quiet) {
        if (this.statsEnabled && cmd == TextCommand.cas) {
            MemcachedStats.CAS_HITS.incrementAndGet(this.statistics);
        }
        if (quiet) {
            return null;
        }
        return cmd == TextCommand.delete ? TextConstants.DELETED : TextConstants.STORED;
    }

    Object createNotExecutedResponse(TextCommand cmd, boolean quiet) {
        if (this.statsEnabled && cmd == TextCommand.cas) {
            MemcachedStats.CAS_BADVAL.incrementAndGet(this.statistics);
        }
        if (quiet) {
            return null;
        }
        return cmd == TextCommand.cas ? TextConstants.EXISTS : TextConstants.NOT_STORED;
    }

    Object createNotExistResponse(TextCommand cmd, boolean quiet) {
        if (this.statsEnabled && cmd == TextCommand.cas) {
            MemcachedStats.CAS_MISSES.incrementAndGet(this.statistics);
        }
        return quiet ? null : TextConstants.NOT_FOUND;
    }

    private static Object createGetResponse(byte[] k, CacheEntry<byte[], byte[]> entry, boolean requiresVersions) {
        if (entry == null) {
            return TextConstants.END;
        }
        return requiresVersions ? TextOpDecoder.buildSingleGetWithVersionResponse(entry) : TextOpDecoder.buildSingleGetResponse(entry);
    }

    private static Object createTouchedResponse(boolean quiet) {
        return quiet ? null : TextConstants.TOUCHED;
    }

    private static ByteBuf buildSingleGetResponse(CacheEntry<byte[], byte[]> entry) {
        ByteBuf buf = TextOpDecoder.buildGetHeaderBegin(entry, TextConstants.END_SIZE);
        TextOpDecoder.writeGetHeaderData((byte[])entry.getValue(), buf);
        return TextOpDecoder.writeGetHeaderEnd(buf);
    }

    private static ByteBuf buildGetResponse(CacheEntry<byte[], byte[]> entry) {
        if (entry == null) {
            return null;
        }
        ByteBuf buf = TextOpDecoder.buildGetHeaderBegin(entry, 0);
        return TextOpDecoder.writeGetHeaderData((byte[])entry.getValue(), buf);
    }

    private static ByteBuf buildGetHeaderBegin(CacheEntry<byte[], byte[]> entry, int extraSpace) {
        byte[] flags;
        byte[] key = (byte[])entry.getKey();
        byte[] data = (byte[])entry.getValue();
        byte[] dataSize = String.valueOf(data.length).getBytes();
        Metadata metadata = entry.getMetadata();
        if (metadata instanceof MemcachedMetadata) {
            long metaFlags = ((MemcachedMetadata)metadata).flags;
            flags = String.valueOf(metaFlags).getBytes();
        } else {
            flags = TextConstants.ZERO;
        }
        int flagsSize = flags.length;
        ByteBuf buf = ExtendedByteBuf.buffer((int)(TextConstants.VALUE_SIZE + key.length + data.length + flagsSize + dataSize.length + 6 + extraSpace));
        buf.writeBytes(TextConstants.VALUE);
        buf.writeBytes(key);
        buf.writeByte(32);
        buf.writeBytes(flags);
        buf.writeByte(32);
        buf.writeBytes(dataSize);
        return buf;
    }

    private static ByteBuf buildSingleGetWithVersionResponse(CacheEntry<byte[], byte[]> entry) {
        byte[] v = (byte[])entry.getValue();
        byte[] version = String.valueOf(((NumericVersion)entry.getMetadata().version()).getVersion()).getBytes();
        ByteBuf buf = TextOpDecoder.buildGetHeaderBegin(entry, version.length + 1 + TextConstants.END_SIZE);
        buf.writeByte(32);
        buf.writeBytes(version);
        TextOpDecoder.writeGetHeaderData(v, buf);
        return TextOpDecoder.writeGetHeaderEnd(buf);
    }

    private static ByteBuf writeGetHeaderData(byte[] data, ByteBuf buf) {
        buf.writeBytes(TextConstants.CRLFBytes);
        buf.writeBytes(data);
        buf.writeBytes(TextConstants.CRLFBytes);
        return buf;
    }

    private static ByteBuf writeGetHeaderEnd(ByteBuf buf) {
        buf.writeBytes(TextConstants.END);
        return buf;
    }

    static byte[] concat(byte[] a, byte[] b) {
        byte[] data = new byte[a.length + b.length];
        System.arraycopy(a, 0, data, 0, a.length);
        System.arraycopy(b, 0, data, a.length, b.length);
        return data;
    }

    private BigInteger validateDelta(String delta) {
        BigInteger bigIntDelta = new BigInteger(delta);
        if (bigIntDelta.compareTo(TextConstants.MAX_UNSIGNED_LONG) > 0) {
            throw CompletableFutures.asCompletionException((Throwable)new StreamCorruptedException("Increment or decrement delta sent (" + delta + ") exceeds unsigned limit (" + String.valueOf(TextConstants.MAX_UNSIGNED_LONG) + ")"));
        }
        if (bigIntDelta.compareTo(TextConstants.MIN_UNSIGNED) < 0) {
            throw CompletableFutures.asCompletionException((Throwable)new StreamCorruptedException("Increment or decrement delta cannot be negative: " + delta));
        }
        return bigIntDelta;
    }
}

