/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.group.ChannelMatcher;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.transport.NettyChannelInitializer;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyInitializers;
import org.infinispan.server.memcached.MemcachedAutoDetector;
import org.infinispan.server.memcached.MemcachedBaseDecoder;
import org.infinispan.server.memcached.MemcachedBinaryDetector;
import org.infinispan.server.memcached.MemcachedChannelInitializer;
import org.infinispan.server.memcached.MemcachedInboundAdapter;
import org.infinispan.server.memcached.MemcachedStats;
import org.infinispan.server.memcached.MemcachedTextDetector;
import org.infinispan.server.memcached.binary.BinaryAuthDecoderImpl;
import org.infinispan.server.memcached.binary.BinaryOpDecoderImpl;
import org.infinispan.server.memcached.configuration.MemcachedAuthenticationConfiguration;
import org.infinispan.server.memcached.configuration.MemcachedProtocol;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;
import org.infinispan.server.memcached.text.TextAuthDecoderImpl;
import org.infinispan.server.memcached.text.TextOpDecoderImpl;

public class MemcachedServer
extends AbstractProtocolServer<MemcachedServerConfiguration> {
    protected final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private Cache<Object, Object> memcachedCache;
    private MemcachedStats statistics;

    public MemcachedServer() {
        super("Memcached");
    }

    protected void startCaches() {
    }

    public CompletionStage<Void> initializeDefaultCache() {
        GlobalConfiguration globalConfiguration = SecurityActions.getCacheManagerConfiguration((EmbeddedCacheManager)this.cacheManager);
        Configuration cacheConfiguration = SecurityActions.getCacheConfiguration((EmbeddedCacheManager)this.cacheManager, (String)((MemcachedServerConfiguration)this.configuration).defaultCacheName());
        if (cacheConfiguration == null) {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            Configuration defaultCacheConfiguration = SecurityActions.getDefaultCacheConfiguration((EmbeddedCacheManager)this.cacheManager);
            if (defaultCacheConfiguration != null) {
                builder.read(defaultCacheConfiguration);
            } else if (globalConfiguration.isClustered()) {
                builder.clustering().cacheMode(CacheMode.REPL_SYNC);
            }
            builder.encoding().key().mediaType(MediaType.TEXT_PLAIN);
            builder.encoding().value().mediaType(MediaType.APPLICATION_OCTET_STREAM);
            builder.statistics().enable();
            cacheConfiguration = builder.build();
        }
        Configuration c = cacheConfiguration;
        return this.getBlockingManager().runBlocking(() -> SecurityActions.getOrCreateCache((EmbeddedCacheManager)this.cacheManager, (String)((MemcachedServerConfiguration)this.configuration).defaultCacheName(), (Configuration)c), (Object)"create-memcached-cache");
    }

    public ChannelOutboundHandler getEncoder() {
        return null;
    }

    public ChannelInboundHandler getDecoder() {
        switch (((MemcachedServerConfiguration)this.configuration).protocol()) {
            case TEXT: {
                if (((MemcachedAuthenticationConfiguration)((MemcachedServerConfiguration)this.configuration).authentication()).enabled()) {
                    return new TextAuthDecoderImpl(this);
                }
                return new TextOpDecoderImpl(this);
            }
            case BINARY: {
                if (((MemcachedAuthenticationConfiguration)((MemcachedServerConfiguration)this.configuration).authentication()).enabled()) {
                    return new BinaryAuthDecoderImpl(this);
                }
                return new BinaryOpDecoderImpl(this);
            }
        }
        return new MemcachedAutoDetector(this);
    }

    public ChannelInboundHandler getDecoder(MemcachedProtocol protocol) {
        switch (protocol) {
            case TEXT: {
                if (((MemcachedAuthenticationConfiguration)((MemcachedServerConfiguration)this.configuration).authentication()).enabled()) {
                    return new TextAuthDecoderImpl(this);
                }
                return new TextOpDecoderImpl(this);
            }
            case BINARY: {
                if (((MemcachedAuthenticationConfiguration)((MemcachedServerConfiguration)this.configuration).authentication()).enabled()) {
                    return new BinaryAuthDecoderImpl(this);
                }
                return new BinaryOpDecoderImpl(this);
            }
        }
        throw new IllegalStateException();
    }

    public void installMemcachedInboundHandler(Channel ch, MemcachedBaseDecoder decoder) {
        MemcachedInboundAdapter inboundAdapter = new MemcachedInboundAdapter(decoder);
        decoder.registerExceptionHandler(inboundAdapter::handleExceptionally);
        ch.pipeline().addLast("handler", (ChannelHandler)inboundAdapter);
    }

    public ChannelMatcher getChannelMatcher() {
        return channel -> channel.pipeline().get(TextOpDecoderImpl.class) != null || channel.pipeline().get(BinaryOpDecoderImpl.class) != null;
    }

    public ChannelInitializer<Channel> getInitializer() {
        return new NettyInitializers(new NettyInitializer[]{new NettyChannelInitializer((ProtocolServer)this, this.transport, this.getEncoder(), null), new MemcachedChannelInitializer(this)});
    }

    public ChannelInitializer<Channel> getInitializer(MemcachedProtocol protocol) {
        return new NettyInitializers(new NettyInitializer[]{new NettyChannelInitializer((ProtocolServer)this, this.transport, this.getEncoder(), null), new MemcachedChannelInitializer(this, protocol)});
    }

    public void stop() {
        super.stop();
        this.scheduler.shutdown();
    }

    public Cache<Object, Object> getCache() {
        if (this.memcachedCache == null) {
            if (!this.cacheManager.isRunning(((MemcachedServerConfiguration)this.configuration).defaultCacheName())) {
                throw new IllegalStateException("Memcached is not initialized");
            }
            this.memcachedCache = this.cacheManager.getCache(((MemcachedServerConfiguration)this.configuration).defaultCacheName());
            if (SecurityActions.getCacheConfiguration(this.memcachedCache).statistics().enabled()) {
                this.statistics = new MemcachedStats();
            }
        }
        return this.memcachedCache;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public void installDetector(Channel ch) {
        switch (((MemcachedServerConfiguration)this.configuration).protocol()) {
            case AUTO: {
                ch.pipeline().addLast("memcached-text-detector", (ChannelHandler)new MemcachedTextDetector(this)).addLast("memcached-binary-detector", (ChannelHandler)new MemcachedBinaryDetector(this));
                break;
            }
            case TEXT: {
                ch.pipeline().addLast("memcached-text-detector", (ChannelHandler)new MemcachedTextDetector(this));
                break;
            }
            case BINARY: {
                ch.pipeline().addLast("memcached-binary-detector", (ChannelHandler)new MemcachedBinaryDetector(this));
            }
        }
    }

    public MemcachedStats getStatistics() {
        return this.statistics;
    }

    protected String protocolType() {
        return "memcached";
    }

    public String toString() {
        return this.toString("Memcached", "protocol=" + String.valueOf((Object)((MemcachedServerConfiguration)this.configuration).protocol()) + ", auth=" + String.join((CharSequence)",", ((MemcachedAuthenticationConfiguration)((MemcachedServerConfiguration)this.configuration).authentication()).sasl().mechanisms()));
    }
}

