/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.binary;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.server.core.transport.ConnectionMetadata;
import org.infinispan.server.memcached.ByteBufPool;
import org.infinispan.server.memcached.MemcachedBaseDecoder;
import org.infinispan.server.memcached.MemcachedInboundAdapter;
import org.infinispan.server.memcached.MemcachedResponse;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.MemcachedStatus;
import org.infinispan.server.memcached.binary.BinaryHeader;
import org.infinispan.server.memcached.binary.BinaryResponse;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;
import org.infinispan.server.memcached.logging.Header;

abstract class BinaryDecoder
extends MemcachedBaseDecoder {
    private final BinaryHeader singleHeader = new BinaryHeader();

    protected BinaryDecoder(MemcachedServer server, Subject subject) {
        super(server, subject);
    }

    public BinaryHeader acquireHeader() {
        return this.singleHeader;
    }

    @Override
    protected final AdvancedCache<byte[], byte[]> createCache(MemcachedServer server) {
        return server.getCache().getAdvancedCache().withMediaType(MediaType.APPLICATION_OCTET_STREAM, ((MemcachedServerConfiguration)server.getConfiguration()).clientEncoding());
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        ConnectionMetadata metadata = ConnectionMetadata.getInstance((Channel)ctx.channel());
        metadata.subject(this.subject);
        metadata.protocolVersion("MCBIN");
    }

    protected MemcachedResponse config(BinaryHeader header, byte[] key) {
        if (log.isTraceEnabled()) {
            log.tracef("CONFIG %s", (Object)Util.printArray((byte[])key));
        }
        String k = new String(key, StandardCharsets.US_ASCII);
        StringBuilder sb = new StringBuilder();
        if ("cluster".equals(k)) {
            sb.append("1");
            sb.append("\r\n");
            sb.append(this.server.getHost());
            sb.append('|');
            sb.append(this.server.getHost());
            sb.append('|');
            sb.append(this.server.getPort());
            sb.append("\r\n");
        }
        this.response(header, MemcachedStatus.NO_ERROR, 0, Util.EMPTY_BYTE_ARRAY, sb.toString().getBytes(StandardCharsets.US_ASCII));
        return this.send(header, CompletableFutures.completedNull());
    }

    protected int response(BinaryHeader header, MemcachedStatus status) {
        return this.response(header, status, Util.EMPTY_BYTE_ARRAY, Util.EMPTY_BYTE_ARRAY);
    }

    protected int response(BinaryHeader header, MemcachedStatus status, byte[] value) {
        return this.response(header, status, Util.EMPTY_BYTE_ARRAY, value);
    }

    protected int response(BinaryHeader header, MemcachedStatus status, byte[] key, byte[] value) {
        return BinaryDecoder.response(MemcachedInboundAdapter.getAllocator(this.ctx), header, status, key, value);
    }

    static int response(ByteBufPool allocator, BinaryHeader header, MemcachedStatus status, byte[] key, byte[] value) {
        int totalLength = key.length + value.length;
        ByteBuf buf = allocator.acquire(24 + totalLength);
        buf.writeByte(-127);
        buf.writeByte((int)header.getCommand().opCode());
        buf.writeShort(key.length);
        buf.writeByte(0);
        buf.writeByte(0);
        buf.writeShort((int)status.getBinary());
        buf.writeInt(totalLength);
        buf.writeInt(header.getOpaque());
        buf.writeLong(header.getCas());
        buf.writeBytes(key);
        buf.writeBytes(value);
        return 24 + totalLength;
    }

    protected void response(BinaryHeader header, MemcachedStatus status, int flags, byte[] key, byte[] value) {
        int totalLength = key.length + value.length + 4;
        ByteBuf buf = MemcachedInboundAdapter.getAllocator(this.ctx).acquire(24 + totalLength);
        buf.writeByte(-127);
        buf.writeByte((int)header.getCommand().opCode());
        buf.writeShort(key.length);
        buf.writeByte(4);
        buf.writeByte(0);
        buf.writeShort((int)status.getBinary());
        buf.writeInt(totalLength);
        buf.writeInt(header.getOpaque());
        buf.writeLong(header.getCas());
        buf.writeInt(flags);
        buf.writeBytes(key);
        buf.writeBytes(value);
    }

    protected void response(BinaryHeader header, MemcachedStatus status, long number) {
        ByteBuf buf = MemcachedInboundAdapter.getAllocator(this.ctx).acquire(32);
        buf.writeByte(-127);
        buf.writeByte((int)header.getCommand().opCode());
        buf.writeShort(0);
        buf.writeByte(0);
        buf.writeByte(0);
        buf.writeShort((int)status.getBinary());
        buf.writeInt(8);
        buf.writeInt(header.getOpaque());
        buf.writeLong(header.getCas());
        buf.writeLong(number);
    }

    protected void response(BinaryHeader header, MemcachedStatus status, Throwable t) {
        this.response(header, status, t.getMessage().getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    protected MemcachedResponse failedResponse(Header header, Throwable t) {
        return new BinaryResponse(t, header);
    }

    @Override
    public MemcachedResponse send(Header header, CompletionStage<?> response) {
        return new BinaryResponse(response, header, null);
    }

    @Override
    public MemcachedResponse send(Header header, CompletionStage<?> response, GenericFutureListener<? extends Future<? super Void>> listener) {
        return new BinaryResponse(response, header, listener);
    }
}

