/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.text;

import io.netty.channel.ChannelHandler;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.server.core.security.UsernamePasswordAuthenticator;
import org.infinispan.server.memcached.MemcachedInboundAdapter;
import org.infinispan.server.memcached.MemcachedResponse;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.configuration.MemcachedAuthenticationConfiguration;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;
import org.infinispan.server.memcached.text.TextConstants;
import org.infinispan.server.memcached.text.TextDecoder;
import org.infinispan.server.memcached.text.TextHeader;
import org.infinispan.server.memcached.text.TextOpDecoderImpl;

public abstract class TextAuthDecoder
extends TextDecoder {
    private static final CompletionStage<byte[]> FAILED_AUTH = CompletableFuture.failedFuture(new SecurityException("Wrong credentials"));
    private final UsernamePasswordAuthenticator authenticator;

    protected TextAuthDecoder(MemcachedServer server) {
        super(server, ANONYMOUS);
        this.authenticator = ((MemcachedAuthenticationConfiguration)((MemcachedServerConfiguration)server.getConfiguration()).authentication()).text().authenticator();
    }

    protected final MemcachedResponse auth(TextHeader header, byte[] token) {
        return this.send(header, this.auth(token));
    }

    private CompletionStage<byte[]> auth(byte[] token) {
        String s = new String(token, StandardCharsets.US_ASCII);
        String[] parts = s.split(" ");
        if (parts.length != 2) {
            return FAILED_AUTH;
        }
        return CompletionStages.handleAndCompose((CompletionStage)this.authenticator.authenticate(parts[0], parts[1].toCharArray()), (subject, t) -> {
            if (t != null) {
                return CompletableFuture.failedFuture(new SecurityException(t.getMessage()));
            }
            CompletableFuture cs = new CompletableFuture();
            this.ctx.channel().eventLoop().submit(() -> {
                MemcachedInboundAdapter inbound = (MemcachedInboundAdapter)this.ctx.pipeline().get(MemcachedInboundAdapter.class);
                TextOpDecoderImpl decoder = new TextOpDecoderImpl(this.server, (Subject)subject);
                decoder.registerExceptionHandler(inbound::handleExceptionally);
                this.ctx.pipeline().replace("decoder", "decoder", (ChannelHandler)decoder);
                cs.complete(TextConstants.STORED);
            });
            return cs;
        });
    }
}

