package org.infinispan.server.memcached.binary;
import java.util.List;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.TooLongFrameException;
import java.time.Instant;
import java.time.temporal.Temporal;
import javax.security.auth.Subject;
import org.infinispan.server.memcached.MemcachedServer;

public class BinaryOpDecoderImpl extends BinaryOpDecoder {
	private int state;
	private int requestBytes;

	private long mc_long;
	private byte mc_dataType;
	private short mc_vbucketId;
	private int mc_opaque;
	private BinaryCommand mc_op;
	private int mc_totalBodyLength;
	private int mc_int;
	private int mc_verbosity;
	private int mc_expiration;
	private BinaryHeader mc_header;
	private int mc_flags;
	private long mc_cas;
	private BinaryCommand mc_opCode;
	private byte[] mc_fixedArray;
	private byte mc_byte;
	private long mc_initial;
	private byte[] mc_key;
	private byte mc_magic;
	private short mc_keyLength;
	private long mc_delta;
	private byte[] mc_value;
	private short mc_short;
	private int mc_valueLength;
	private byte mc_extrasLength;

	private boolean deadEnd = false;
	public BinaryOpDecoderImpl(MemcachedServer server, Subject subject) {
		super(server, subject);
	}

	public BinaryOpDecoderImpl(MemcachedServer server) {
		this(server, ANONYMOUS);
	}

	@Override
	public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
		int pos = buf.readerIndex();
		try {
			if (! ctx.channel().config().isAutoRead()) {
				log.tracef("Auto read was disabled, not reading next bytes yet");
				return;
			} else {
				log.tracef("Auto read was enabled, reading next bytes");
			}
			while (switch1_0(ctx, buf, out));
		} catch (Throwable t) {
			exceptionally(ctx, t);
		} finally {
			requestBytes += buf.readerIndex() - pos;
		}
	}

	private boolean switch1_0(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
		switch (state >> 6) {
		case 0: return switch0(ctx, buf, out);
		case 1: return switch1(ctx, buf, out);
		case 2: return switch2(ctx, buf, out);
		default: throw new IllegalStateException();
		}
	}

	private boolean switch0(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
		byte b;
		int pos;
		switch (state) {
		case 0: 
			// 
			reset(); 
			state = 1;
			// fallthrough
		case 1: 
			// 
			posBefore = buf.readerIndex();
			
			state = 2;
			// fallthrough
		case 2: 
			// mc.request
			pos = buf.readerIndex();
			mc_byte = org.infinispan.server.memcached.binary.BinaryIntrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_magic = mc_byte;
			state = 3;
			// fallthrough
		case 3: 
			// mc.request
			if (accessLogging) requestStart = Instant.now();
			
			state = 4;
			// fallthrough
		case 4: 
			// mc.request
			if (mc_magic != org.infinispan.server.memcached.binary.BinaryConstants.MAGIC_REQ) {
				state = 6;
				return true;
			}
			deadEnd = false;
			
			state = 7;
			return true;
		case 5: 
			// mc.request
			if (log.isTraceEnabled()) log.tracef("Parsed header: %s", mc_header);
			
			state = 15;
			return true;
		case 6: 
			// mc.request/mc.header
			throw new IllegalStateException("Error reading magic byte or message id: " + mc_magic);
			
		case 7: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_opCode = org.infinispan.server.memcached.binary.BinaryIntrinsics.opCode(buf);
			if (buf.readerIndex() == pos) return false;
			mc_op = mc_opCode;
			state = 8;
			// fallthrough
		case 8: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_short = org.infinispan.server.memcached.binary.BinaryIntrinsics.short_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_keyLength = mc_short;
			state = 9;
			// fallthrough
		case 9: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_byte = org.infinispan.server.memcached.binary.BinaryIntrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_extrasLength = mc_byte;
			state = 10;
			// fallthrough
		case 10: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_byte = org.infinispan.server.memcached.binary.BinaryIntrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_dataType = mc_byte;
			state = 11;
			// fallthrough
		case 11: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_short = org.infinispan.server.memcached.binary.BinaryIntrinsics.short_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_vbucketId = mc_short;
			state = 12;
			// fallthrough
		case 12: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_totalBodyLength = mc_int;
			state = 13;
			// fallthrough
		case 13: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_opaque = mc_int;
			state = 14;
			// fallthrough
		case 14: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_long = org.infinispan.server.memcached.binary.BinaryIntrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_cas = mc_long;
			mc_valueLength = mc_totalBodyLength - mc_keyLength - mc_extrasLength;
			mc_header = acquireHeader().replace(requestStart, requestBytes, principalName, mc_key, mc_opCode, mc_opaque, mc_cas);
			state = 5;
			return true;
		case 15: 
			// mc.request
			return userSwitch15();
		case 16: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 18;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 17;
			// fallthrough
		case 17: 
			// mc.request/mc.parameters
			if (out.add(get(mc_header, mc_key, false))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 18: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 17;
			return true;
		case 19: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 21;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 20;
			// fallthrough
		case 20: 
			// mc.request/mc.parameters
			if (out.add(get(mc_header, mc_key, true))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 21: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 20;
			return true;
		case 22: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 24;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 23;
			// fallthrough
		case 23: 
			// mc.request/mc.parameters
			if (out.add(get(mc_header, mc_key, false))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 24: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 23;
			return true;
		case 25: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 27;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 26;
			// fallthrough
		case 26: 
			// mc.request/mc.parameters
			if (out.add(get(mc_header, mc_key, true))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 27: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 26;
			return true;
		case 28: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_flags = mc_int;
			state = 29;
			// fallthrough
		case 29: 
			// mc.request/mc.parameters
			if (mc_extrasLength > 0) {
				state = 31;
				return true;
			}
			mc_expiration = 0;
			state = 30;
			// fallthrough
		case 30: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 33;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 32;
			return true;
		case 31: 
			// mc.request/mc.parameters/mc.expiration
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_expiration = mc_int;
			state = 30;
			return true;
		case 32: 
			// mc.request/mc.parameters
			if (mc_valueLength > 0) {
				state = 35;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 34;
			return true;
		case 33: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 32;
			return true;
		case 34: 
			// mc.request/mc.parameters
			if (out.add(set(mc_header, mc_key, mc_value, mc_flags, mc_expiration, false))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 35: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_valueLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 34;
			return true;
		case 36: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_flags = mc_int;
			state = 37;
			// fallthrough
		case 37: 
			// mc.request/mc.parameters
			if (mc_extrasLength > 0) {
				state = 39;
				return true;
			}
			mc_expiration = 0;
			state = 38;
			// fallthrough
		case 38: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 41;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 40;
			return true;
		case 39: 
			// mc.request/mc.parameters/mc.expiration
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_expiration = mc_int;
			state = 38;
			return true;
		case 40: 
			// mc.request/mc.parameters
			if (mc_valueLength > 0) {
				state = 43;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 42;
			return true;
		case 41: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 40;
			return true;
		case 42: 
			// mc.request/mc.parameters
			if (out.add(set(mc_header, mc_key, mc_value, mc_flags, mc_expiration, true))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 43: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_valueLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 42;
			return true;
		case 44: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_flags = mc_int;
			state = 45;
			// fallthrough
		case 45: 
			// mc.request/mc.parameters
			if (mc_extrasLength > 0) {
				state = 47;
				return true;
			}
			mc_expiration = 0;
			state = 46;
			// fallthrough
		case 46: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 49;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 48;
			return true;
		case 47: 
			// mc.request/mc.parameters/mc.expiration
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_expiration = mc_int;
			state = 46;
			return true;
		case 48: 
			// mc.request/mc.parameters
			if (mc_valueLength > 0) {
				state = 51;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 50;
			return true;
		case 49: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 48;
			return true;
		case 50: 
			// mc.request/mc.parameters
			if (out.add(add(mc_header, mc_key, mc_value, mc_flags, mc_expiration, false))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 51: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_valueLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 50;
			return true;
		case 52: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_flags = mc_int;
			state = 53;
			// fallthrough
		case 53: 
			// mc.request/mc.parameters
			if (mc_extrasLength > 0) {
				state = 55;
				return true;
			}
			mc_expiration = 0;
			state = 54;
			// fallthrough
		case 54: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 57;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 56;
			return true;
		case 55: 
			// mc.request/mc.parameters/mc.expiration
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_expiration = mc_int;
			state = 54;
			return true;
		case 56: 
			// mc.request/mc.parameters
			if (mc_valueLength > 0) {
				state = 59;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 58;
			return true;
		case 57: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 56;
			return true;
		case 58: 
			// mc.request/mc.parameters
			if (out.add(add(mc_header, mc_key, mc_value, mc_flags, mc_expiration, true))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 59: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_valueLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 58;
			return true;
		case 60: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_flags = mc_int;
			state = 61;
			// fallthrough
		case 61: 
			// mc.request/mc.parameters
			if (mc_extrasLength > 0) {
				state = 63;
				return true;
			}
			mc_expiration = 0;
			state = 62;
			// fallthrough
		case 62: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 65;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 64;
			return true;
		case 63: 
			// mc.request/mc.parameters/mc.expiration
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_expiration = mc_int;
			state = 62;
			return true;
		}
		return true;
	}

	private boolean switch1(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
		byte b;
		int pos;
		switch (state) {
		case 64: 
			// mc.request/mc.parameters
			if (mc_valueLength > 0) {
				state = 67;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 66;
			return true;
		case 65: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 64;
			return true;
		case 66: 
			// mc.request/mc.parameters
			if (out.add(replace(mc_header, mc_key, mc_value, mc_flags, mc_expiration, false))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 67: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_valueLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 66;
			return true;
		case 68: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_flags = mc_int;
			state = 69;
			// fallthrough
		case 69: 
			// mc.request/mc.parameters
			if (mc_extrasLength > 0) {
				state = 71;
				return true;
			}
			mc_expiration = 0;
			state = 70;
			// fallthrough
		case 70: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 73;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 72;
			return true;
		case 71: 
			// mc.request/mc.parameters/mc.expiration
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_expiration = mc_int;
			state = 70;
			return true;
		case 72: 
			// mc.request/mc.parameters
			if (mc_valueLength > 0) {
				state = 75;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 74;
			return true;
		case 73: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 72;
			return true;
		case 74: 
			// mc.request/mc.parameters
			if (out.add(replace(mc_header, mc_key, mc_value, mc_flags, mc_expiration, true))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 75: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_valueLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 74;
			return true;
		case 76: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 78;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 77;
			// fallthrough
		case 77: 
			// mc.request/mc.parameters
			if (out.add(delete(mc_header, mc_key, false))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 78: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 77;
			return true;
		case 79: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 81;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 80;
			// fallthrough
		case 80: 
			// mc.request/mc.parameters
			if (out.add(delete(mc_header, mc_key, true))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 81: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 80;
			return true;
		case 82: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_long = org.infinispan.server.memcached.binary.BinaryIntrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_delta = mc_long;
			state = 83;
			// fallthrough
		case 83: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_long = org.infinispan.server.memcached.binary.BinaryIntrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_initial = mc_long;
			state = 84;
			// fallthrough
		case 84: 
			// mc.request/mc.parameters
			if (mc_extrasLength > 0) {
				state = 86;
				return true;
			}
			mc_expiration = 0;
			state = 85;
			// fallthrough
		case 85: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 88;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 87;
			return true;
		case 86: 
			// mc.request/mc.parameters/mc.expiration
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_expiration = mc_int;
			state = 85;
			return true;
		case 87: 
			// mc.request/mc.parameters
			if (out.add(increment(mc_header, mc_key, mc_delta, mc_initial, mc_expiration, false))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 88: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 87;
			return true;
		case 89: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_long = org.infinispan.server.memcached.binary.BinaryIntrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_delta = mc_long;
			state = 90;
			// fallthrough
		case 90: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_long = org.infinispan.server.memcached.binary.BinaryIntrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_initial = mc_long;
			state = 91;
			// fallthrough
		case 91: 
			// mc.request/mc.parameters
			if (mc_extrasLength > 0) {
				state = 93;
				return true;
			}
			mc_expiration = 0;
			state = 92;
			// fallthrough
		case 92: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 95;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 94;
			return true;
		case 93: 
			// mc.request/mc.parameters/mc.expiration
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_expiration = mc_int;
			state = 92;
			return true;
		case 94: 
			// mc.request/mc.parameters
			if (out.add(increment(mc_header, mc_key, mc_delta, mc_initial, mc_expiration, true))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 95: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 94;
			return true;
		case 96: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_long = org.infinispan.server.memcached.binary.BinaryIntrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_delta = mc_long;
			state = 97;
			// fallthrough
		case 97: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_long = org.infinispan.server.memcached.binary.BinaryIntrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_initial = mc_long;
			state = 98;
			// fallthrough
		case 98: 
			// mc.request/mc.parameters
			if (mc_extrasLength > 0) {
				state = 100;
				return true;
			}
			mc_expiration = 0;
			state = 99;
			// fallthrough
		case 99: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 102;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 101;
			return true;
		case 100: 
			// mc.request/mc.parameters/mc.expiration
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_expiration = mc_int;
			state = 99;
			return true;
		case 101: 
			// mc.request/mc.parameters
			if (out.add(increment(mc_header, mc_key, - mc_delta, mc_initial, mc_expiration, false))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 102: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 101;
			return true;
		case 103: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_long = org.infinispan.server.memcached.binary.BinaryIntrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_delta = mc_long;
			state = 104;
			// fallthrough
		case 104: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_long = org.infinispan.server.memcached.binary.BinaryIntrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_initial = mc_long;
			state = 105;
			// fallthrough
		case 105: 
			// mc.request/mc.parameters
			if (mc_extrasLength > 0) {
				state = 107;
				return true;
			}
			mc_expiration = 0;
			state = 106;
			// fallthrough
		case 106: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 109;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 108;
			return true;
		case 107: 
			// mc.request/mc.parameters/mc.expiration
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_expiration = mc_int;
			state = 106;
			return true;
		case 108: 
			// mc.request/mc.parameters
			if (out.add(increment(mc_header, mc_key, - mc_delta, mc_initial, mc_expiration, true))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 109: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 108;
			return true;
		case 110: 
			// mc.request/mc.parameters
			if (out.add(quit(mc_header, false))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 111: 
			// mc.request/mc.parameters
			quit(mc_header, true);
			
			state = 0;
			return true;
		case 112: 
			// mc.request/mc.parameters
			if (mc_extrasLength > 0) {
				state = 114;
				return true;
			}
			mc_expiration = 0;
			state = 113;
			// fallthrough
		case 113: 
			// mc.request/mc.parameters
			if (out.add(flush(mc_header, mc_expiration, false))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 114: 
			// mc.request/mc.parameters/mc.expiration
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_expiration = mc_int;
			state = 113;
			return true;
		case 115: 
			// mc.request/mc.parameters
			if (mc_extrasLength > 0) {
				state = 117;
				return true;
			}
			mc_expiration = 0;
			state = 116;
			// fallthrough
		case 116: 
			// mc.request/mc.parameters
			flush(mc_header, mc_expiration, true);
			
			state = 0;
			return true;
		case 117: 
			// mc.request/mc.parameters/mc.expiration
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_expiration = mc_int;
			state = 116;
			return true;
		case 118: 
			// mc.request/mc.parameters
			if (out.add(noop(mc_header))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 119: 
			// mc.request/mc.parameters
			if (out.add(version(mc_header))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 120: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 122;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 121;
			// fallthrough
		case 121: 
			// mc.request/mc.parameters
			if (mc_valueLength > 0) {
				state = 124;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 123;
			return true;
		case 122: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 121;
			return true;
		case 123: 
			// mc.request/mc.parameters
			if (out.add(append(mc_header, mc_key, mc_value, false))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 124: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_valueLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 123;
			return true;
		case 125: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 127;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 126;
			// fallthrough
		case 126: 
			// mc.request/mc.parameters
			if (mc_valueLength > 0) {
				state = 129;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 128;
			return true;
		case 127: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 126;
			return true;
		}
		return true;
	}

	private boolean switch2(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
		byte b;
		int pos;
		switch (state) {
		case 128: 
			// mc.request/mc.parameters
			if (out.add(append(mc_header, mc_key, mc_value, true))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 129: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_valueLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 128;
			return true;
		case 130: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 132;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 131;
			// fallthrough
		case 131: 
			// mc.request/mc.parameters
			if (mc_valueLength > 0) {
				state = 134;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 133;
			return true;
		case 132: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 131;
			return true;
		case 133: 
			// mc.request/mc.parameters
			if (out.add(prepend(mc_header, mc_key, mc_value, false))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 134: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_valueLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 133;
			return true;
		case 135: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 137;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 136;
			// fallthrough
		case 136: 
			// mc.request/mc.parameters
			if (mc_valueLength > 0) {
				state = 139;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 138;
			return true;
		case 137: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 136;
			return true;
		case 138: 
			// mc.request/mc.parameters
			if (out.add(prepend(mc_header, mc_key, mc_value, true))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 139: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_valueLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 138;
			return true;
		case 140: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_verbosity = mc_int;
			state = 141;
			// fallthrough
		case 141: 
			// mc.request/mc.parameters
			if (out.add(verbosityLevel(mc_header, mc_verbosity))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 142: 
			// mc.request/mc.parameters
			if (mc_extrasLength > 0) {
				state = 144;
				return true;
			}
			mc_expiration = 0;
			state = 143;
			// fallthrough
		case 143: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 146;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 145;
			return true;
		case 144: 
			// mc.request/mc.parameters/mc.expiration
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_expiration = mc_int;
			state = 143;
			return true;
		case 145: 
			// mc.request/mc.parameters
			if (out.add(touch(mc_header, mc_key, mc_expiration))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 146: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 145;
			return true;
		case 147: 
			// mc.request/mc.parameters
			if (mc_extrasLength > 0) {
				state = 149;
				return true;
			}
			mc_expiration = 0;
			state = 148;
			// fallthrough
		case 148: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 151;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 150;
			return true;
		case 149: 
			// mc.request/mc.parameters/mc.expiration
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_expiration = mc_int;
			state = 148;
			return true;
		case 150: 
			// mc.request/mc.parameters
			if (out.add(gat(mc_header, mc_key, mc_expiration, false))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 151: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 150;
			return true;
		case 152: 
			// mc.request/mc.parameters
			if (mc_extrasLength > 0) {
				state = 154;
				return true;
			}
			mc_expiration = 0;
			state = 153;
			// fallthrough
		case 153: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 156;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 155;
			return true;
		case 154: 
			// mc.request/mc.parameters/mc.expiration
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_expiration = mc_int;
			state = 153;
			return true;
		case 155: 
			// mc.request/mc.parameters
			if (out.add(gat(mc_header, mc_key, mc_expiration, true))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 156: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 155;
			return true;
		case 157: 
			// mc.request/mc.parameters
			if (mc_extrasLength > 0) {
				state = 159;
				return true;
			}
			mc_expiration = 0;
			state = 158;
			// fallthrough
		case 158: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 161;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 160;
			return true;
		case 159: 
			// mc.request/mc.parameters/mc.expiration
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_expiration = mc_int;
			state = 158;
			return true;
		case 160: 
			// mc.request/mc.parameters
			if (out.add(gat(mc_header, mc_key, mc_expiration, false))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 161: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 160;
			return true;
		case 162: 
			// mc.request/mc.parameters
			if (mc_extrasLength > 0) {
				state = 164;
				return true;
			}
			mc_expiration = 0;
			state = 163;
			// fallthrough
		case 163: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 166;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 165;
			return true;
		case 164: 
			// mc.request/mc.parameters/mc.expiration
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_expiration = mc_int;
			state = 163;
			return true;
		case 165: 
			// mc.request/mc.parameters
			if (out.add(gat(mc_header, mc_key, mc_expiration, true))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 166: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 165;
			return true;
		case 167: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 169;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 168;
			// fallthrough
		case 168: 
			// mc.request/mc.parameters
			if (out.add(stat(mc_header, mc_key))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 169: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 168;
			return true;
		case 170: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 172;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 171;
			// fallthrough
		case 171: 
			// mc.request/mc.parameters
			if (out.add(config(mc_header, mc_key))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 172: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 171;
			return true;
		}
		return true;
	}

	private void deadEnd() {
		if (! deadEnd) {
			log.tracef("Invalid state of parsing");
			exceptionCaught(mc_header, new IllegalStateException("Dead end processing request"));
			deadEnd = true;
		}
		state = 0;
	}

	private void exceptionally(ChannelHandlerContext ctx, Throwable t) throws Exception {
		state = 0;
		if (t instanceof TooLongFrameException tlfe) {
			log.requestTooLarge(ctx.channel(), tlfe);
			ctx.close();
			return;
		}
		log.trace("Parsing error", t);
		exceptionCaught(mc_header, t);
	}

	private void reset() {
		requestBytes = 0;
		mc_long = 0;
		mc_dataType = 0;
		mc_vbucketId = 0;
		mc_opaque = 0;
		mc_op = null;
		mc_totalBodyLength = 0;
		mc_int = 0;
		mc_verbosity = 0;
		mc_expiration = 0;
		mc_header = null;
		mc_flags = 0;
		mc_cas = 0;
		mc_opCode = null;
		mc_fixedArray = null;
		mc_byte = 0;
		mc_initial = 0;
		mc_key = null;
		mc_magic = 0;
		mc_keyLength = 0;
		mc_delta = 0;
		mc_value = null;
		mc_short = 0;
		mc_valueLength = 0;
		mc_extrasLength = 0;
	}

	public int requestBytes() {
		return requestBytes;
	}

	private boolean userSwitch15() throws Exception {
		switch (mc_op) {
		case GET: 
			state = 16;
			return true;
		case GETQ: 
			state = 19;
			return true;
		case GETK: 
			state = 22;
			return true;
		case GETKQ: 
			state = 25;
			return true;
		case SET: 
			state = 28;
			return true;
		case SETQ: 
			state = 36;
			return true;
		case ADD: 
			state = 44;
			return true;
		case ADDQ: 
			state = 52;
			return true;
		case REPLACE: 
			state = 60;
			return true;
		case REPLACEQ: 
			state = 68;
			return true;
		case DELETE: 
			state = 76;
			return true;
		case DELETEQ: 
			state = 79;
			return true;
		case INCREMENT: 
			state = 82;
			return true;
		case INCREMENTQ: 
			state = 89;
			return true;
		case DECREMENT: 
			state = 96;
			return true;
		case DECREMENTQ: 
			state = 103;
			return true;
		case QUIT: 
			state = 110;
			return true;
		case QUITQ: 
			state = 111;
			return true;
		case FLUSH: 
			state = 112;
			return true;
		case FLUSHQ: 
			state = 115;
			return true;
		case NO_OP: 
			state = 118;
			return true;
		case VERSION: 
			state = 119;
			return true;
		case APPEND: 
			state = 120;
			return true;
		case APPENDQ: 
			state = 125;
			return true;
		case PREPEND: 
			state = 130;
			return true;
		case PREPENDQ: 
			state = 135;
			return true;
		case VERBOSITY: 
			state = 140;
			return true;
		case TOUCH: 
			state = 142;
			return true;
		case GAT: 
			state = 147;
			return true;
		case GATQ: 
			state = 152;
			return true;
		case GATK: 
			state = 157;
			return true;
		case GATKQ: 
			state = 162;
			return true;
		case STAT: 
			state = 167;
			return true;
		case CONFIG_GET: 
			state = 170;
			return true;
		default: 
			throw new IllegalArgumentException("Unknown operation " + mc_op);
			
		}
	}

}
