package org.infinispan.server.memcached.binary;
import java.util.List;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.TooLongFrameException;
import java.time.Instant;
import java.time.temporal.Temporal;
import org.infinispan.server.memcached.MemcachedServer;

public class BinaryAuthDecoderImpl extends BinaryAuthDecoder {
	private int state;
	private int requestBytes;

	private long mc_long;
	private byte mc_dataType;
	private short mc_vbucketId;
	private int mc_opaque;
	private BinaryCommand mc_op;
	private int mc_totalBodyLength;
	private int mc_int;
	private int mc_verbosity;
	private BinaryHeader mc_header;
	private long mc_cas;
	private BinaryCommand mc_opCode;
	private byte[] mc_fixedArray;
	private byte mc_byte;
	private long mc_initial;
	private byte[] mc_key;
	private byte mc_magic;
	private short mc_keyLength;
	private long mc_delta;
	private byte[] mc_value;
	private short mc_short;
	private int mc_valueLength;
	private byte mc_extrasLength;

	private boolean deadEnd = false;
	public BinaryAuthDecoderImpl(MemcachedServer server) {
		super(server);
	}

	@Override
	public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
		int pos = buf.readerIndex();
		try {
			while (switch0(ctx, buf, out));
		} catch (Throwable t) {
			exceptionally(ctx, t);
		} finally {
			requestBytes += buf.readerIndex() - pos;
		}
	}

	private boolean switch0(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
		byte b;
		int pos;
		switch (state) {
		case 0: 
			// 
			reset(); 
			state = 1;
			// fallthrough
		case 1: 
			// 
			posBefore = buf.readerIndex();
			
			state = 2;
			// fallthrough
		case 2: 
			// mc.request
			pos = buf.readerIndex();
			mc_byte = org.infinispan.server.memcached.binary.BinaryIntrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_magic = mc_byte;
			state = 3;
			// fallthrough
		case 3: 
			// mc.request
			requestStart = Instant.now();
			
			state = 4;
			// fallthrough
		case 4: 
			// mc.request
			if (mc_magic != org.infinispan.server.memcached.binary.BinaryConstants.MAGIC_REQ) {
				state = 6;
				return true;
			}
			deadEnd = false;
			
			state = 7;
			return true;
		case 5: 
			// mc.request
			if (log.isTraceEnabled()) log.tracef("Parsed header: %s", mc_header);
			
			state = 15;
			return true;
		case 6: 
			// mc.request/mc.header
			throw new IllegalStateException("Error reading magic byte or message id: " + mc_magic);
			
		case 7: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_opCode = org.infinispan.server.memcached.binary.BinaryIntrinsics.opCode(buf);
			if (buf.readerIndex() == pos) return false;
			mc_op = mc_opCode;
			state = 8;
			// fallthrough
		case 8: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_short = org.infinispan.server.memcached.binary.BinaryIntrinsics.short_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_keyLength = mc_short;
			state = 9;
			// fallthrough
		case 9: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_byte = org.infinispan.server.memcached.binary.BinaryIntrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_extrasLength = mc_byte;
			state = 10;
			// fallthrough
		case 10: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_byte = org.infinispan.server.memcached.binary.BinaryIntrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_dataType = mc_byte;
			state = 11;
			// fallthrough
		case 11: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_short = org.infinispan.server.memcached.binary.BinaryIntrinsics.short_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_vbucketId = mc_short;
			state = 12;
			// fallthrough
		case 12: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_totalBodyLength = mc_int;
			state = 13;
			// fallthrough
		case 13: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_int = org.infinispan.server.memcached.binary.BinaryIntrinsics.int_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_opaque = mc_int;
			state = 14;
			// fallthrough
		case 14: 
			// mc.request/mc.header
			pos = buf.readerIndex();
			mc_long = org.infinispan.server.memcached.binary.BinaryIntrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_cas = mc_long;
			mc_valueLength = mc_totalBodyLength - mc_keyLength - mc_extrasLength;
			mc_header = acquireHeader().replace(requestStart, requestBytes, principalName, mc_key, mc_opCode, mc_opaque, mc_cas);
			state = 5;
			return true;
		case 15: 
			// mc.request
			switch (mc_op) {
			case SASL_LIST_MECHS: 
				state = 16;
				return true;
			case SASL_AUTH: 
				state = 17;
				return true;
			case SASL_STEP: 
				state = 22;
				return true;
			case CONFIG_GET: 
				state = 27;
				return true;
			default: 
				throw new IllegalArgumentException("Unknown operation " + mc_op);
				
			}
		case 16: 
			// mc.request/mc.parameters
			if (out.add(saslListMechs(mc_header))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 17: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 19;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 18;
			// fallthrough
		case 18: 
			// mc.request/mc.parameters
			if (mc_valueLength > 0) {
				state = 21;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 20;
			return true;
		case 19: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 18;
			return true;
		case 20: 
			// mc.request/mc.parameters
			if (out.add(saslAuth(mc_header, mc_key, mc_value))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 21: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_valueLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 20;
			return true;
		case 22: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 24;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 23;
			// fallthrough
		case 23: 
			// mc.request/mc.parameters
			if (mc_valueLength > 0) {
				state = 26;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 25;
			return true;
		case 24: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 23;
			return true;
		case 25: 
			// mc.request/mc.parameters
			if (out.add(saslStep(mc_header, mc_key, mc_value))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 26: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_valueLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 25;
			return true;
		case 27: 
			// mc.request/mc.parameters
			if (mc_keyLength > 0) {
				state = 29;
				return true;
			}
			mc_key = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 28;
			// fallthrough
		case 28: 
			// mc.request/mc.parameters
			if (out.add(config(mc_header, mc_key))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 29: 
			// mc.request/mc.parameters/mc.key
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.binary.BinaryIntrinsics.fixedArray(buf, mc_keyLength, bytesAvailable(buf, requestBytes));
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_fixedArray;
			state = 28;
			return true;
		}
		return true;
	}

	private void deadEnd() {
		if (! deadEnd) {
			log.tracef("Invalid state of parsing");
			deadEnd = true;
		}
		state = 0;
	}

	private void exceptionally(ChannelHandlerContext ctx, Throwable t) throws Exception {
		state = 0;
		if (t instanceof TooLongFrameException tlfe) {
			log.requestTooLarge(ctx.channel(), tlfe);
			ctx.close();
			return;
		}
		log.trace("Parsing error", t);
	}

	private void reset() {
		requestBytes = 0;
		mc_long = 0;
		mc_dataType = 0;
		mc_vbucketId = 0;
		mc_opaque = 0;
		mc_op = null;
		mc_totalBodyLength = 0;
		mc_int = 0;
		mc_verbosity = 0;
		mc_header = null;
		mc_cas = 0;
		mc_opCode = null;
		mc_fixedArray = null;
		mc_byte = 0;
		mc_initial = 0;
		mc_key = null;
		mc_magic = 0;
		mc_keyLength = 0;
		mc_delta = 0;
		mc_value = null;
		mc_short = 0;
		mc_valueLength = 0;
		mc_extrasLength = 0;
	}

	public int requestBytes() {
		return requestBytes;
	}
}
