/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.text;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.server.core.transport.ConnectionMetadata;
import org.infinispan.server.memcached.MemcachedBaseDecoder;
import org.infinispan.server.memcached.MemcachedResponse;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;
import org.infinispan.server.memcached.logging.Header;
import org.infinispan.server.memcached.text.TextResponse;
import org.infinispan.server.memcached.text.TokenReader;

abstract class TextDecoder
extends MemcachedBaseDecoder {
    protected TokenReader reader;

    protected TextDecoder(MemcachedServer server, Subject subject) {
        super(server, subject, (AdvancedCache<byte[], byte[]>)server.getCache().getAdvancedCache().withMediaType(MediaType.TEXT_PLAIN, ((MemcachedServerConfiguration)server.getConfiguration()).clientEncoding()));
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.reader = new TokenReader(ctx.alloc().buffer(256));
        ConnectionMetadata metadata = ConnectionMetadata.getInstance((Channel)ctx.channel());
        metadata.subject(this.subject);
        metadata.protocolVersion("MCTXT");
    }

    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved0(ctx);
        if (this.reader != null) {
            this.reader.release();
        }
    }

    @Override
    protected MemcachedResponse failedResponse(Header header, Throwable t) {
        return new TextResponse(t, header);
    }

    @Override
    protected MemcachedResponse send(Header header, CompletionStage<?> response) {
        return new TextResponse(response, header, null);
    }

    @Override
    protected MemcachedResponse send(Header header, CompletionStage<?> response, GenericFutureListener<? extends Future<? super Void>> listener) {
        return new TextResponse(response, header, listener);
    }
}

