/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.text;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.TooLongFrameException;
import java.time.Instant;
import java.util.List;
import javax.security.auth.Subject;
import org.infinispan.commons.util.Util;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.text.TextCommand;
import org.infinispan.server.memcached.text.TextHeader;
import org.infinispan.server.memcached.text.TextIntrinsics;
import org.infinispan.server.memcached.text.TextOpDecoder;

public class TextOpDecoderImpl
extends TextOpDecoder {
    private int state;
    private int requestBytes;
    private int mc_parseUnsignedInt;
    private int mc_exptime;
    private byte[] mc_text_key;
    private int mc_flags;
    private ByteBuf mc_token;
    private byte[] mc_fixedArray;
    private int mc_int_number;
    private byte[] mc_text;
    private TextCommand mc_command;
    private List<byte[]> mc_text_key_list;
    private byte[] mc_key;
    private short mc_short;
    private List<byte[]> mc_keys;
    private boolean mc_eowc;
    private long mc_long_number;
    private int mc_readBuf;
    private long mc_cas_unique;
    private long mc_parseLong;
    private boolean mc_consumeLine;
    private TextCommand mc_command_name;
    private int mc_vsize;
    private byte[] mc_value;
    private short mc_eol;
    private byte[] mc_delta;
    private boolean mc_noreply;
    private List<byte[]> mc_varargs;
    private List<byte[]> mc_text_list;
    private List<byte[]> mc_readByteList;
    private boolean deadEnd = false;

    public TextOpDecoderImpl(MemcachedServer server, Subject subject) {
        super(server, subject);
    }

    public TextOpDecoderImpl(MemcachedServer server) {
        this(server, ANONYMOUS);
    }

    private TextHeader getHeader() {
        return this.accessLogging ? new TextHeader(this.requestBytes, this.requestStart, this.principalName, this.mc_key, this.mc_command_name) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        int pos = buf.readerIndex();
        try {
            if (!ctx.channel().config().isAutoRead()) {
                log.tracef("Auto read was disabled, not reading next bytes yet", new Object[0]);
                return;
            }
            log.tracef("Auto read was enabled, reading next bytes", new Object[0]);
            while (this.switch1_0(ctx, buf, out)) {
            }
        }
        catch (Throwable t) {
            this.exceptionally(ctx, t);
        }
        finally {
            this.requestBytes += buf.readerIndex() - pos;
        }
    }

    private boolean switch1_0(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state >> 6) {
            case 0: {
                return this.switch0(ctx, buf, out);
            }
            case 1: {
                return this.switch1(ctx, buf, out);
            }
        }
        throw new IllegalStateException();
    }

    private boolean switch0(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 0: {
                this.reset();
                this.state = 1;
            }
            case 1: {
                this.posBefore = buf.readerIndex();
                this.state = 2;
            }
            case 2: {
                int pos = buf.readerIndex();
                this.mc_command = TextIntrinsics.command(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_command_name = this.mc_command;
                this.state = 3;
            }
            case 3: {
                this.requestStart = Instant.now();
                this.state = 4;
            }
            case 4: {
                return this.userSwitch4();
            }
            case 5: {
                int pos = buf.readerIndex();
                this.mc_text_key = TextIntrinsics.text_key(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_text_key;
                this.state = 6;
            }
            case 6: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int_number;
                this.state = 7;
            }
            case 7: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_exptime = this.mc_int_number;
                this.state = 8;
            }
            case 8: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_vsize = this.mc_int_number;
                this.state = 9;
            }
            case 9: {
                int pos = buf.readerIndex();
                this.mc_eowc = TextIntrinsics.eowc(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_noreply = this.mc_eowc;
                this.state = 10;
            }
            case 10: {
                if (this.mc_vsize > 0) {
                    this.state = 12;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 11;
            }
            case 11: {
                int pos = buf.readerIndex();
                this.mc_short = TextIntrinsics.short_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_eol = this.mc_short;
                this.state = 13;
                return true;
            }
            case 12: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = TextIntrinsics.fixedArray(buf, this.mc_vsize, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 11;
                return true;
            }
            case 13: {
                if (out.add(this.set(this.getHeader(), this.mc_key, this.mc_value, this.mc_flags, this.mc_exptime, this.mc_noreply))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 14: {
                int pos = buf.readerIndex();
                this.mc_text_key = TextIntrinsics.text_key(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_text_key;
                this.state = 15;
            }
            case 15: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int_number;
                this.state = 16;
            }
            case 16: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_exptime = this.mc_int_number;
                this.state = 17;
            }
            case 17: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_vsize = this.mc_int_number;
                this.state = 18;
            }
            case 18: {
                int pos = buf.readerIndex();
                this.mc_eowc = TextIntrinsics.eowc(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_noreply = this.mc_eowc;
                this.state = 19;
            }
            case 19: {
                if (this.mc_vsize > 0) {
                    this.state = 21;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 20;
            }
            case 20: {
                int pos = buf.readerIndex();
                this.mc_short = TextIntrinsics.short_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_eol = this.mc_short;
                this.state = 22;
                return true;
            }
            case 21: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = TextIntrinsics.fixedArray(buf, this.mc_vsize, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 20;
                return true;
            }
            case 22: {
                if (out.add(this.add(this.getHeader(), this.mc_key, this.mc_value, this.mc_flags, this.mc_exptime, this.mc_noreply))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 23: {
                int pos = buf.readerIndex();
                this.mc_text_key = TextIntrinsics.text_key(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_text_key;
                this.state = 24;
            }
            case 24: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int_number;
                this.state = 25;
            }
            case 25: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_exptime = this.mc_int_number;
                this.state = 26;
            }
            case 26: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_vsize = this.mc_int_number;
                this.state = 27;
            }
            case 27: {
                int pos = buf.readerIndex();
                this.mc_eowc = TextIntrinsics.eowc(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_noreply = this.mc_eowc;
                this.state = 28;
            }
            case 28: {
                if (this.mc_vsize > 0) {
                    this.state = 30;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 29;
            }
            case 29: {
                int pos = buf.readerIndex();
                this.mc_short = TextIntrinsics.short_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_eol = this.mc_short;
                this.state = 31;
                return true;
            }
            case 30: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = TextIntrinsics.fixedArray(buf, this.mc_vsize, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 29;
                return true;
            }
            case 31: {
                if (out.add(this.replace(this.getHeader(), this.mc_key, this.mc_value, this.mc_flags, this.mc_exptime, this.mc_noreply))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 32: {
                int pos = buf.readerIndex();
                this.mc_text_key = TextIntrinsics.text_key(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_text_key;
                this.state = 33;
            }
            case 33: {
                int pos = buf.readerIndex();
                this.mc_eowc = TextIntrinsics.eowc(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_noreply = this.mc_eowc;
                this.state = 34;
            }
            case 34: {
                if (out.add(this.delete(this.getHeader(), this.mc_key, this.mc_noreply))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 35: {
                int pos = buf.readerIndex();
                this.mc_text_key = TextIntrinsics.text_key(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_text_key;
                this.state = 36;
            }
            case 36: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int_number;
                this.state = 37;
            }
            case 37: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_exptime = this.mc_int_number;
                this.state = 38;
            }
            case 38: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_vsize = this.mc_int_number;
                this.state = 39;
            }
            case 39: {
                int pos = buf.readerIndex();
                this.mc_eowc = TextIntrinsics.eowc(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_noreply = this.mc_eowc;
                this.state = 40;
            }
            case 40: {
                if (this.mc_vsize > 0) {
                    this.state = 42;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 41;
            }
            case 41: {
                int pos = buf.readerIndex();
                this.mc_short = TextIntrinsics.short_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_eol = this.mc_short;
                this.state = 43;
                return true;
            }
            case 42: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = TextIntrinsics.fixedArray(buf, this.mc_vsize, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 41;
                return true;
            }
            case 43: {
                if (out.add(this.concat(this.getHeader(), this.mc_key, this.mc_value, this.mc_flags, this.mc_exptime, this.mc_noreply, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 44: {
                int pos = buf.readerIndex();
                this.mc_text_key = TextIntrinsics.text_key(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_text_key;
                this.state = 45;
            }
            case 45: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int_number;
                this.state = 46;
            }
            case 46: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_exptime = this.mc_int_number;
                this.state = 47;
            }
            case 47: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_vsize = this.mc_int_number;
                this.state = 48;
            }
            case 48: {
                int pos = buf.readerIndex();
                this.mc_eowc = TextIntrinsics.eowc(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_noreply = this.mc_eowc;
                this.state = 49;
            }
            case 49: {
                if (this.mc_vsize > 0) {
                    this.state = 51;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 50;
            }
            case 50: {
                int pos = buf.readerIndex();
                this.mc_short = TextIntrinsics.short_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_eol = this.mc_short;
                this.state = 52;
                return true;
            }
            case 51: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = TextIntrinsics.fixedArray(buf, this.mc_vsize, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 50;
                return true;
            }
            case 52: {
                if (out.add(this.concat(this.getHeader(), this.mc_key, this.mc_value, this.mc_flags, this.mc_exptime, this.mc_noreply, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 53: {
                int pos = buf.readerIndex();
                this.mc_text_key = TextIntrinsics.text_key(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_text_key;
                this.state = 54;
            }
            case 54: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int_number;
                this.state = 55;
            }
            case 55: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_exptime = this.mc_int_number;
                this.state = 56;
            }
            case 56: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_vsize = this.mc_int_number;
                this.state = 57;
            }
            case 57: {
                int pos = buf.readerIndex();
                this.mc_long_number = TextIntrinsics.long_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_cas_unique = this.mc_long_number;
                this.state = 58;
            }
            case 58: {
                int pos = buf.readerIndex();
                this.mc_eowc = TextIntrinsics.eowc(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_noreply = this.mc_eowc;
                this.state = 59;
            }
            case 59: {
                if (this.mc_vsize > 0) {
                    this.state = 61;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 60;
            }
            case 60: {
                int pos = buf.readerIndex();
                this.mc_short = TextIntrinsics.short_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_eol = this.mc_short;
                this.state = 62;
                return true;
            }
            case 61: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = TextIntrinsics.fixedArray(buf, this.mc_vsize, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 60;
                return true;
            }
            case 62: {
                if (out.add(this.cas(this.getHeader(), this.mc_key, this.mc_value, this.mc_flags, this.mc_exptime, this.mc_cas_unique, this.mc_noreply))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 63: {
                int pos = buf.readerIndex();
                this.mc_text_key_list = TextIntrinsics.text_key_list(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_keys = this.mc_text_key_list;
                this.state = 64;
            }
        }
        return true;
    }

    private boolean switch1(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 64: {
                if (out.add(this.get(this.getHeader(), this.mc_keys, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 65: {
                int pos = buf.readerIndex();
                this.mc_text_key_list = TextIntrinsics.text_key_list(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_keys = this.mc_text_key_list;
                this.state = 66;
            }
            case 66: {
                if (out.add(this.get(this.getHeader(), this.mc_keys, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 67: {
                int pos = buf.readerIndex();
                this.mc_text_key = TextIntrinsics.text_key(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_text_key;
                this.state = 68;
            }
            case 68: {
                int pos = buf.readerIndex();
                this.mc_text = TextIntrinsics.text(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_delta = this.mc_text;
                this.state = 69;
            }
            case 69: {
                int pos = buf.readerIndex();
                this.mc_eowc = TextIntrinsics.eowc(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_noreply = this.mc_eowc;
                this.state = 70;
            }
            case 70: {
                if (out.add(this.incr(this.getHeader(), this.mc_key, this.mc_delta, this.mc_noreply, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 71: {
                int pos = buf.readerIndex();
                this.mc_text_key = TextIntrinsics.text_key(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_text_key;
                this.state = 72;
            }
            case 72: {
                int pos = buf.readerIndex();
                this.mc_text = TextIntrinsics.text(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_delta = this.mc_text;
                this.state = 73;
            }
            case 73: {
                int pos = buf.readerIndex();
                this.mc_eowc = TextIntrinsics.eowc(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_noreply = this.mc_eowc;
                this.state = 74;
            }
            case 74: {
                if (out.add(this.incr(this.getHeader(), this.mc_key, this.mc_delta, this.mc_noreply, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 75: {
                int pos = buf.readerIndex();
                this.mc_text_key = TextIntrinsics.text_key(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_text_key;
                this.state = 76;
            }
            case 76: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_exptime = this.mc_int_number;
                this.state = 77;
            }
            case 77: {
                int pos = buf.readerIndex();
                this.mc_eowc = TextIntrinsics.eowc(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_noreply = this.mc_eowc;
                this.state = 78;
            }
            case 78: {
                if (out.add(this.touch(this.getHeader(), this.mc_key, this.mc_exptime, this.mc_noreply))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 79: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_exptime = this.mc_int_number;
                this.state = 80;
            }
            case 80: {
                int pos = buf.readerIndex();
                this.mc_text_key_list = TextIntrinsics.text_key_list(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_keys = this.mc_text_key_list;
                this.state = 81;
            }
            case 81: {
                if (out.add(this.gat(this.getHeader(), this.mc_exptime, this.mc_keys, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 82: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_exptime = this.mc_int_number;
                this.state = 83;
            }
            case 83: {
                int pos = buf.readerIndex();
                this.mc_text_key_list = TextIntrinsics.text_key_list(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_keys = this.mc_text_key_list;
                this.state = 84;
            }
            case 84: {
                if (out.add(this.gat(this.getHeader(), this.mc_exptime, this.mc_keys, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 85: {
                int pos = buf.readerIndex();
                this.mc_text_list = TextIntrinsics.text_list(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_varargs = this.mc_text_list;
                this.state = 86;
            }
            case 86: {
                if (out.add(this.flush_all(this.getHeader(), this.mc_varargs))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 87: {
                int pos = buf.readerIndex();
                this.mc_short = TextIntrinsics.short_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_eol = this.mc_short;
                this.state = 88;
            }
            case 88: {
                if (out.add(this.version(this.getHeader()))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 89: {
                int pos = buf.readerIndex();
                this.mc_short = TextIntrinsics.short_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_eol = this.mc_short;
                this.state = 90;
            }
            case 90: {
                this.quit(this.getHeader());
                this.state = 0;
                return true;
            }
            case 91: {
                int pos = buf.readerIndex();
                this.mc_text_key_list = TextIntrinsics.text_key_list(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_keys = this.mc_text_key_list;
                this.state = 92;
            }
            case 92: {
                if (out.add(this.stats(this.getHeader(), this.mc_keys))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 93: {
                int pos = buf.readerIndex();
                this.mc_text_key = TextIntrinsics.text_key(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_text_key;
                this.state = 94;
            }
            case 94: {
                int pos = buf.readerIndex();
                this.mc_text_list = TextIntrinsics.text_list(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_varargs = this.mc_text_list;
                this.state = 95;
            }
            case 95: {
                if (out.add(this.mg(this.getHeader(), this.mc_key, this.mc_varargs))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 96: {
                int pos = buf.readerIndex();
                this.mc_text_key = TextIntrinsics.text_key(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_text_key;
                this.state = 97;
            }
            case 97: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_vsize = this.mc_int_number;
                this.state = 98;
            }
            case 98: {
                int pos = buf.readerIndex();
                this.mc_text_list = TextIntrinsics.text_list(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_varargs = this.mc_text_list;
                this.state = 99;
            }
            case 99: {
                if (this.mc_vsize > 0) {
                    this.state = 101;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 100;
            }
            case 100: {
                int pos = buf.readerIndex();
                this.mc_short = TextIntrinsics.short_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_eol = this.mc_short;
                this.state = 102;
                return true;
            }
            case 101: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = TextIntrinsics.fixedArray(buf, this.mc_vsize, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 100;
                return true;
            }
            case 102: {
                if (out.add(this.ms(this.getHeader(), this.mc_key, this.mc_value, this.mc_varargs))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 103: {
                int pos = buf.readerIndex();
                this.mc_text_key = TextIntrinsics.text_key(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_text_key;
                this.state = 104;
            }
            case 104: {
                int pos = buf.readerIndex();
                this.mc_text_list = TextIntrinsics.text_list(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_varargs = this.mc_text_list;
                this.state = 105;
            }
            case 105: {
                if (out.add(this.md(this.getHeader(), this.mc_key, this.mc_varargs))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 106: {
                int pos = buf.readerIndex();
                this.mc_text_key = TextIntrinsics.text_key(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_text_key;
                this.state = 107;
            }
            case 107: {
                int pos = buf.readerIndex();
                this.mc_text_list = TextIntrinsics.text_list(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_varargs = this.mc_text_list;
                this.state = 108;
            }
            case 108: {
                if (out.add(this.ma(this.getHeader(), this.mc_key, this.mc_varargs))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 109: {
                int pos = buf.readerIndex();
                this.mc_short = TextIntrinsics.short_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_eol = this.mc_short;
                this.state = 110;
            }
            case 110: {
                if (out.add(this.mn(this.getHeader()))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 111: {
                int pos = buf.readerIndex();
                this.mc_text_key = TextIntrinsics.text_key(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_text_key;
                this.state = 112;
            }
            case 112: {
                int pos = buf.readerIndex();
                this.mc_text_list = TextIntrinsics.text_list(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_varargs = this.mc_text_list;
                this.state = 113;
            }
            case 113: {
                if (out.add(this.me(this.getHeader(), this.mc_key, this.mc_varargs))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
        }
        return true;
    }

    private void deadEnd() {
        if (!this.deadEnd) {
            this.exceptionCaught(this.getHeader(), new IllegalStateException("Dead end processing request"));
            this.deadEnd = true;
        }
        this.state = 0;
    }

    private void exceptionally(ChannelHandlerContext ctx, Throwable t) throws Exception {
        this.state = 0;
        if (t instanceof TooLongFrameException) {
            TooLongFrameException tlfe = (TooLongFrameException)t;
            log.requestTooLarge(ctx.channel(), tlfe);
            ctx.close();
            return;
        }
        this.exceptionCaught(this.getHeader(), t);
    }

    private void reset() {
        this.requestBytes = 0;
        this.mc_parseUnsignedInt = 0;
        this.mc_exptime = 0;
        this.mc_text_key = null;
        this.mc_flags = 0;
        this.mc_token = null;
        this.mc_fixedArray = null;
        this.mc_int_number = 0;
        this.mc_text = null;
        this.mc_command = null;
        this.mc_text_key_list = null;
        this.mc_key = null;
        this.mc_short = 0;
        this.mc_keys = null;
        this.mc_eowc = false;
        this.mc_long_number = 0L;
        this.mc_readBuf = 0;
        this.mc_cas_unique = 0L;
        this.mc_parseLong = 0L;
        this.mc_consumeLine = false;
        this.mc_command_name = null;
        this.mc_vsize = 0;
        this.mc_value = null;
        this.mc_eol = 0;
        this.mc_delta = null;
        this.mc_noreply = false;
        this.mc_varargs = null;
        this.mc_text_list = null;
        this.mc_readByteList = null;
    }

    public int requestBytes() {
        return this.requestBytes;
    }

    private boolean userSwitch4() throws Exception {
        switch (this.mc_command_name) {
            case set: {
                this.state = 5;
                return true;
            }
            case add: {
                this.state = 14;
                return true;
            }
            case replace: {
                this.state = 23;
                return true;
            }
            case delete: {
                this.state = 32;
                return true;
            }
            case append: {
                this.state = 35;
                return true;
            }
            case prepend: {
                this.state = 44;
                return true;
            }
            case cas: {
                this.state = 53;
                return true;
            }
            case get: {
                this.state = 63;
                return true;
            }
            case gets: {
                this.state = 65;
                return true;
            }
            case incr: {
                this.state = 67;
                return true;
            }
            case decr: {
                this.state = 71;
                return true;
            }
            case touch: {
                this.state = 75;
                return true;
            }
            case gat: {
                this.state = 79;
                return true;
            }
            case gats: {
                this.state = 82;
                return true;
            }
            case flush_all: {
                this.state = 85;
                return true;
            }
            case version: {
                this.state = 87;
                return true;
            }
            case quit: {
                this.state = 89;
                return true;
            }
            case stats: {
                this.state = 91;
                return true;
            }
            case mg: {
                this.state = 93;
                return true;
            }
            case ms: {
                this.state = 96;
                return true;
            }
            case md: {
                this.state = 103;
                return true;
            }
            case ma: {
                this.state = 106;
                return true;
            }
            case mn: {
                this.state = 109;
                return true;
            }
            case me: {
                this.state = 111;
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown command " + String.valueOf((Object)this.mc_command_name));
    }
}

