/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.binary;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.TooLongFrameException;
import java.time.Instant;
import java.util.List;
import javax.security.auth.Subject;
import org.infinispan.commons.util.Util;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.binary.BinaryCommand;
import org.infinispan.server.memcached.binary.BinaryHeader;
import org.infinispan.server.memcached.binary.BinaryIntrinsics;
import org.infinispan.server.memcached.binary.BinaryOpDecoder;

public class BinaryOpDecoderImpl
extends BinaryOpDecoder {
    private int state;
    private int requestBytes;
    private long mc_long;
    private byte mc_dataType;
    private short mc_vbucketId;
    private int mc_opaque;
    private BinaryCommand mc_op;
    private int mc_totalBodyLength;
    private int mc_int;
    private int mc_verbosity;
    private int mc_expiration;
    private BinaryHeader mc_header;
    private int mc_flags;
    private long mc_cas;
    private BinaryCommand mc_opCode;
    private byte[] mc_fixedArray;
    private byte mc_byte;
    private long mc_initial;
    private byte[] mc_key;
    private byte mc_magic;
    private short mc_keyLength;
    private long mc_delta;
    private byte[] mc_value;
    private short mc_short;
    private int mc_valueLength;
    private byte mc_extrasLength;
    private boolean deadEnd = false;

    public BinaryOpDecoderImpl(MemcachedServer server, Subject subject) {
        super(server, subject);
    }

    public BinaryOpDecoderImpl(MemcachedServer server) {
        this(server, ANONYMOUS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        int pos = buf.readerIndex();
        try {
            if (!ctx.channel().config().isAutoRead()) {
                log.tracef("Auto read was disabled, not reading next bytes yet", new Object[0]);
                return;
            }
            log.tracef("Auto read was enabled, reading next bytes", new Object[0]);
            while (this.switch1_0(ctx, buf, out)) {
            }
        }
        catch (Throwable t) {
            this.exceptionally(ctx, t);
        }
        finally {
            this.requestBytes += buf.readerIndex() - pos;
        }
    }

    private boolean switch1_0(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state >> 6) {
            case 0: {
                return this.switch0(ctx, buf, out);
            }
            case 1: {
                return this.switch1(ctx, buf, out);
            }
            case 2: {
                return this.switch2(ctx, buf, out);
            }
        }
        throw new IllegalStateException();
    }

    private boolean switch0(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 0: {
                this.reset();
                this.state = 1;
            }
            case 1: {
                this.posBefore = buf.readerIndex();
                this.state = 2;
            }
            case 2: {
                int pos = buf.readerIndex();
                this.mc_byte = BinaryIntrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_magic = this.mc_byte;
                this.state = 3;
            }
            case 3: {
                if (this.accessLogging) {
                    this.requestStart = Instant.now();
                }
                this.state = 4;
            }
            case 4: {
                if (this.mc_magic != -128) {
                    this.state = 6;
                    return true;
                }
                this.deadEnd = false;
                this.state = 7;
                return true;
            }
            case 5: {
                if (log.isTraceEnabled()) {
                    log.tracef("Parsed header: %s", (Object)this.mc_header);
                }
                this.state = 15;
                return true;
            }
            case 6: {
                throw new IllegalStateException("Error reading magic byte or message id: " + this.mc_magic);
            }
            case 7: {
                int pos = buf.readerIndex();
                this.mc_opCode = BinaryIntrinsics.opCode(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_op = this.mc_opCode;
                this.state = 8;
            }
            case 8: {
                int pos = buf.readerIndex();
                this.mc_short = BinaryIntrinsics.short_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_keyLength = this.mc_short;
                this.state = 9;
            }
            case 9: {
                int pos = buf.readerIndex();
                this.mc_byte = BinaryIntrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_extrasLength = this.mc_byte;
                this.state = 10;
            }
            case 10: {
                int pos = buf.readerIndex();
                this.mc_byte = BinaryIntrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_dataType = this.mc_byte;
                this.state = 11;
            }
            case 11: {
                int pos = buf.readerIndex();
                this.mc_short = BinaryIntrinsics.short_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_vbucketId = this.mc_short;
                this.state = 12;
            }
            case 12: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_totalBodyLength = this.mc_int;
                this.state = 13;
            }
            case 13: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_opaque = this.mc_int;
                this.state = 14;
            }
            case 14: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_cas = this.mc_long;
                this.mc_valueLength = this.mc_totalBodyLength - this.mc_keyLength - this.mc_extrasLength;
                this.mc_header = this.acquireHeader().replace(this.requestStart, this.requestBytes, this.principalName, this.mc_key, this.mc_opCode, this.mc_opaque, this.mc_cas);
                this.state = 5;
                return true;
            }
            case 15: {
                return this.userSwitch15();
            }
            case 16: {
                if (this.mc_keyLength > 0) {
                    this.state = 18;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 17;
            }
            case 17: {
                if (out.add(this.get(this.mc_header, this.mc_key, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 18: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 17;
                return true;
            }
            case 19: {
                if (this.mc_keyLength > 0) {
                    this.state = 21;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 20;
            }
            case 20: {
                if (out.add(this.get(this.mc_header, this.mc_key, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 21: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 20;
                return true;
            }
            case 22: {
                if (this.mc_keyLength > 0) {
                    this.state = 24;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 23;
            }
            case 23: {
                if (out.add(this.get(this.mc_header, this.mc_key, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 24: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 23;
                return true;
            }
            case 25: {
                if (this.mc_keyLength > 0) {
                    this.state = 27;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 26;
            }
            case 26: {
                if (out.add(this.get(this.mc_header, this.mc_key, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 27: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 26;
                return true;
            }
            case 28: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int;
                this.state = 29;
            }
            case 29: {
                if (this.mc_extrasLength > 0) {
                    this.state = 31;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 30;
            }
            case 30: {
                if (this.mc_keyLength > 0) {
                    this.state = 33;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 32;
                return true;
            }
            case 31: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 30;
                return true;
            }
            case 32: {
                if (this.mc_valueLength > 0) {
                    this.state = 35;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 34;
                return true;
            }
            case 33: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 32;
                return true;
            }
            case 34: {
                if (out.add(this.set(this.mc_header, this.mc_key, this.mc_value, this.mc_flags, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 35: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 34;
                return true;
            }
            case 36: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int;
                this.state = 37;
            }
            case 37: {
                if (this.mc_extrasLength > 0) {
                    this.state = 39;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 38;
            }
            case 38: {
                if (this.mc_keyLength > 0) {
                    this.state = 41;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 40;
                return true;
            }
            case 39: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 38;
                return true;
            }
            case 40: {
                if (this.mc_valueLength > 0) {
                    this.state = 43;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 42;
                return true;
            }
            case 41: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 40;
                return true;
            }
            case 42: {
                if (out.add(this.set(this.mc_header, this.mc_key, this.mc_value, this.mc_flags, this.mc_expiration, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 43: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 42;
                return true;
            }
            case 44: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int;
                this.state = 45;
            }
            case 45: {
                if (this.mc_extrasLength > 0) {
                    this.state = 47;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 46;
            }
            case 46: {
                if (this.mc_keyLength > 0) {
                    this.state = 49;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 48;
                return true;
            }
            case 47: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 46;
                return true;
            }
            case 48: {
                if (this.mc_valueLength > 0) {
                    this.state = 51;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 50;
                return true;
            }
            case 49: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 48;
                return true;
            }
            case 50: {
                if (out.add(this.add(this.mc_header, this.mc_key, this.mc_value, this.mc_flags, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 51: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 50;
                return true;
            }
            case 52: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int;
                this.state = 53;
            }
            case 53: {
                if (this.mc_extrasLength > 0) {
                    this.state = 55;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 54;
            }
            case 54: {
                if (this.mc_keyLength > 0) {
                    this.state = 57;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 56;
                return true;
            }
            case 55: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 54;
                return true;
            }
            case 56: {
                if (this.mc_valueLength > 0) {
                    this.state = 59;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 58;
                return true;
            }
            case 57: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 56;
                return true;
            }
            case 58: {
                if (out.add(this.add(this.mc_header, this.mc_key, this.mc_value, this.mc_flags, this.mc_expiration, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 59: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 58;
                return true;
            }
            case 60: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int;
                this.state = 61;
            }
            case 61: {
                if (this.mc_extrasLength > 0) {
                    this.state = 63;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 62;
            }
            case 62: {
                if (this.mc_keyLength > 0) {
                    this.state = 65;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 64;
                return true;
            }
            case 63: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 62;
                return true;
            }
        }
        return true;
    }

    private boolean switch1(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 64: {
                if (this.mc_valueLength > 0) {
                    this.state = 67;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 66;
                return true;
            }
            case 65: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 64;
                return true;
            }
            case 66: {
                if (out.add(this.replace(this.mc_header, this.mc_key, this.mc_value, this.mc_flags, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 67: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 66;
                return true;
            }
            case 68: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int;
                this.state = 69;
            }
            case 69: {
                if (this.mc_extrasLength > 0) {
                    this.state = 71;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 70;
            }
            case 70: {
                if (this.mc_keyLength > 0) {
                    this.state = 73;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 72;
                return true;
            }
            case 71: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 70;
                return true;
            }
            case 72: {
                if (this.mc_valueLength > 0) {
                    this.state = 75;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 74;
                return true;
            }
            case 73: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 72;
                return true;
            }
            case 74: {
                if (out.add(this.replace(this.mc_header, this.mc_key, this.mc_value, this.mc_flags, this.mc_expiration, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 75: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 74;
                return true;
            }
            case 76: {
                if (this.mc_keyLength > 0) {
                    this.state = 78;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 77;
            }
            case 77: {
                if (out.add(this.delete(this.mc_header, this.mc_key, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 78: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 77;
                return true;
            }
            case 79: {
                if (this.mc_keyLength > 0) {
                    this.state = 81;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 80;
            }
            case 80: {
                if (out.add(this.delete(this.mc_header, this.mc_key, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 81: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 80;
                return true;
            }
            case 82: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_delta = this.mc_long;
                this.state = 83;
            }
            case 83: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_initial = this.mc_long;
                this.state = 84;
            }
            case 84: {
                if (this.mc_extrasLength > 0) {
                    this.state = 86;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 85;
            }
            case 85: {
                if (this.mc_keyLength > 0) {
                    this.state = 88;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 87;
                return true;
            }
            case 86: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 85;
                return true;
            }
            case 87: {
                if (out.add(this.increment(this.mc_header, this.mc_key, this.mc_delta, this.mc_initial, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 88: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 87;
                return true;
            }
            case 89: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_delta = this.mc_long;
                this.state = 90;
            }
            case 90: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_initial = this.mc_long;
                this.state = 91;
            }
            case 91: {
                if (this.mc_extrasLength > 0) {
                    this.state = 93;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 92;
            }
            case 92: {
                if (this.mc_keyLength > 0) {
                    this.state = 95;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 94;
                return true;
            }
            case 93: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 92;
                return true;
            }
            case 94: {
                if (out.add(this.increment(this.mc_header, this.mc_key, this.mc_delta, this.mc_initial, this.mc_expiration, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 95: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 94;
                return true;
            }
            case 96: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_delta = this.mc_long;
                this.state = 97;
            }
            case 97: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_initial = this.mc_long;
                this.state = 98;
            }
            case 98: {
                if (this.mc_extrasLength > 0) {
                    this.state = 100;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 99;
            }
            case 99: {
                if (this.mc_keyLength > 0) {
                    this.state = 102;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 101;
                return true;
            }
            case 100: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 99;
                return true;
            }
            case 101: {
                if (out.add(this.increment(this.mc_header, this.mc_key, -this.mc_delta, this.mc_initial, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 102: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 101;
                return true;
            }
            case 103: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_delta = this.mc_long;
                this.state = 104;
            }
            case 104: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_initial = this.mc_long;
                this.state = 105;
            }
            case 105: {
                if (this.mc_extrasLength > 0) {
                    this.state = 107;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 106;
            }
            case 106: {
                if (this.mc_keyLength > 0) {
                    this.state = 109;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 108;
                return true;
            }
            case 107: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 106;
                return true;
            }
            case 108: {
                if (out.add(this.increment(this.mc_header, this.mc_key, -this.mc_delta, this.mc_initial, this.mc_expiration, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 109: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 108;
                return true;
            }
            case 110: {
                if (out.add(this.quit(this.mc_header, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 111: {
                this.quit(this.mc_header, true);
                this.state = 0;
                return true;
            }
            case 112: {
                if (this.mc_extrasLength > 0) {
                    this.state = 114;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 113;
            }
            case 113: {
                if (out.add(this.flush(this.mc_header, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 114: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 113;
                return true;
            }
            case 115: {
                if (this.mc_extrasLength > 0) {
                    this.state = 117;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 116;
            }
            case 116: {
                this.flush(this.mc_header, this.mc_expiration, true);
                this.state = 0;
                return true;
            }
            case 117: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 116;
                return true;
            }
            case 118: {
                if (out.add(this.noop(this.mc_header))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 119: {
                if (out.add(this.version(this.mc_header))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 120: {
                if (this.mc_keyLength > 0) {
                    this.state = 122;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 121;
            }
            case 121: {
                if (this.mc_valueLength > 0) {
                    this.state = 124;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 123;
                return true;
            }
            case 122: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 121;
                return true;
            }
            case 123: {
                if (out.add(this.append(this.mc_header, this.mc_key, this.mc_value, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 124: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 123;
                return true;
            }
            case 125: {
                if (this.mc_keyLength > 0) {
                    this.state = 127;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 126;
            }
            case 126: {
                if (this.mc_valueLength > 0) {
                    this.state = 129;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 128;
                return true;
            }
            case 127: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 126;
                return true;
            }
        }
        return true;
    }

    private boolean switch2(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 128: {
                if (out.add(this.append(this.mc_header, this.mc_key, this.mc_value, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 129: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 128;
                return true;
            }
            case 130: {
                if (this.mc_keyLength > 0) {
                    this.state = 132;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 131;
            }
            case 131: {
                if (this.mc_valueLength > 0) {
                    this.state = 134;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 133;
                return true;
            }
            case 132: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 131;
                return true;
            }
            case 133: {
                if (out.add(this.prepend(this.mc_header, this.mc_key, this.mc_value, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 134: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 133;
                return true;
            }
            case 135: {
                if (this.mc_keyLength > 0) {
                    this.state = 137;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 136;
            }
            case 136: {
                if (this.mc_valueLength > 0) {
                    this.state = 139;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 138;
                return true;
            }
            case 137: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 136;
                return true;
            }
            case 138: {
                if (out.add(this.prepend(this.mc_header, this.mc_key, this.mc_value, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 139: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 138;
                return true;
            }
            case 140: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_verbosity = this.mc_int;
                this.state = 141;
            }
            case 141: {
                if (out.add(this.verbosityLevel(this.mc_header, this.mc_verbosity))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 142: {
                if (this.mc_extrasLength > 0) {
                    this.state = 144;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 143;
            }
            case 143: {
                if (this.mc_keyLength > 0) {
                    this.state = 146;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 145;
                return true;
            }
            case 144: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 143;
                return true;
            }
            case 145: {
                if (out.add(this.touch(this.mc_header, this.mc_key, this.mc_expiration))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 146: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 145;
                return true;
            }
            case 147: {
                if (this.mc_extrasLength > 0) {
                    this.state = 149;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 148;
            }
            case 148: {
                if (this.mc_keyLength > 0) {
                    this.state = 151;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 150;
                return true;
            }
            case 149: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 148;
                return true;
            }
            case 150: {
                if (out.add(this.gat(this.mc_header, this.mc_key, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 151: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 150;
                return true;
            }
            case 152: {
                if (this.mc_extrasLength > 0) {
                    this.state = 154;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 153;
            }
            case 153: {
                if (this.mc_keyLength > 0) {
                    this.state = 156;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 155;
                return true;
            }
            case 154: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 153;
                return true;
            }
            case 155: {
                if (out.add(this.gat(this.mc_header, this.mc_key, this.mc_expiration, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 156: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 155;
                return true;
            }
            case 157: {
                if (this.mc_extrasLength > 0) {
                    this.state = 159;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 158;
            }
            case 158: {
                if (this.mc_keyLength > 0) {
                    this.state = 161;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 160;
                return true;
            }
            case 159: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 158;
                return true;
            }
            case 160: {
                if (out.add(this.gat(this.mc_header, this.mc_key, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 161: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 160;
                return true;
            }
            case 162: {
                if (this.mc_extrasLength > 0) {
                    this.state = 164;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 163;
            }
            case 163: {
                if (this.mc_keyLength > 0) {
                    this.state = 166;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 165;
                return true;
            }
            case 164: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 163;
                return true;
            }
            case 165: {
                if (out.add(this.gat(this.mc_header, this.mc_key, this.mc_expiration, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 166: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 165;
                return true;
            }
            case 167: {
                if (this.mc_keyLength > 0) {
                    this.state = 169;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 168;
            }
            case 168: {
                if (out.add(this.stat(this.mc_header, this.mc_key))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 169: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 168;
                return true;
            }
            case 170: {
                if (this.mc_keyLength > 0) {
                    this.state = 172;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 171;
            }
            case 171: {
                if (out.add(this.config(this.mc_header, this.mc_key))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 172: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 171;
                return true;
            }
        }
        return true;
    }

    private void deadEnd() {
        if (!this.deadEnd) {
            log.tracef("Invalid state of parsing", new Object[0]);
            this.exceptionCaught(this.mc_header, new IllegalStateException("Dead end processing request"));
            this.deadEnd = true;
        }
        this.state = 0;
    }

    private void exceptionally(ChannelHandlerContext ctx, Throwable t) throws Exception {
        this.state = 0;
        if (t instanceof TooLongFrameException) {
            TooLongFrameException tlfe = (TooLongFrameException)t;
            log.requestTooLarge(ctx.channel(), tlfe);
            ctx.close();
            return;
        }
        log.trace((Object)"Parsing error", t);
        this.exceptionCaught(this.mc_header, t);
    }

    private void reset() {
        this.requestBytes = 0;
        this.mc_long = 0L;
        this.mc_dataType = 0;
        this.mc_vbucketId = 0;
        this.mc_opaque = 0;
        this.mc_op = null;
        this.mc_totalBodyLength = 0;
        this.mc_int = 0;
        this.mc_verbosity = 0;
        this.mc_expiration = 0;
        this.mc_header = null;
        this.mc_flags = 0;
        this.mc_cas = 0L;
        this.mc_opCode = null;
        this.mc_fixedArray = null;
        this.mc_byte = 0;
        this.mc_initial = 0L;
        this.mc_key = null;
        this.mc_magic = 0;
        this.mc_keyLength = 0;
        this.mc_delta = 0L;
        this.mc_value = null;
        this.mc_short = 0;
        this.mc_valueLength = 0;
        this.mc_extrasLength = 0;
    }

    public int requestBytes() {
        return this.requestBytes;
    }

    private boolean userSwitch15() throws Exception {
        switch (this.mc_op) {
            case GET: {
                this.state = 16;
                return true;
            }
            case GETQ: {
                this.state = 19;
                return true;
            }
            case GETK: {
                this.state = 22;
                return true;
            }
            case GETKQ: {
                this.state = 25;
                return true;
            }
            case SET: {
                this.state = 28;
                return true;
            }
            case SETQ: {
                this.state = 36;
                return true;
            }
            case ADD: {
                this.state = 44;
                return true;
            }
            case ADDQ: {
                this.state = 52;
                return true;
            }
            case REPLACE: {
                this.state = 60;
                return true;
            }
            case REPLACEQ: {
                this.state = 68;
                return true;
            }
            case DELETE: {
                this.state = 76;
                return true;
            }
            case DELETEQ: {
                this.state = 79;
                return true;
            }
            case INCREMENT: {
                this.state = 82;
                return true;
            }
            case INCREMENTQ: {
                this.state = 89;
                return true;
            }
            case DECREMENT: {
                this.state = 96;
                return true;
            }
            case DECREMENTQ: {
                this.state = 103;
                return true;
            }
            case QUIT: {
                this.state = 110;
                return true;
            }
            case QUITQ: {
                this.state = 111;
                return true;
            }
            case FLUSH: {
                this.state = 112;
                return true;
            }
            case FLUSHQ: {
                this.state = 115;
                return true;
            }
            case NO_OP: {
                this.state = 118;
                return true;
            }
            case VERSION: {
                this.state = 119;
                return true;
            }
            case APPEND: {
                this.state = 120;
                return true;
            }
            case APPENDQ: {
                this.state = 125;
                return true;
            }
            case PREPEND: {
                this.state = 130;
                return true;
            }
            case PREPENDQ: {
                this.state = 135;
                return true;
            }
            case VERBOSITY: {
                this.state = 140;
                return true;
            }
            case TOUCH: {
                this.state = 142;
                return true;
            }
            case GAT: {
                this.state = 147;
                return true;
            }
            case GATQ: {
                this.state = 152;
                return true;
            }
            case GATK: {
                this.state = 157;
                return true;
            }
            case GATKQ: {
                this.state = 162;
                return true;
            }
            case STAT: {
                this.state = 167;
                return true;
            }
            case CONFIG_GET: {
                this.state = 170;
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown operation " + String.valueOf((Object)this.mc_op));
    }
}

