/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.text;

import io.netty.buffer.ByteBuf;
import io.netty.util.ByteProcessor;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.infinispan.server.core.transport.ExtendedByteBufJava;
import org.infinispan.server.memcached.text.TextCommand;
import org.infinispan.server.memcached.text.TextConstants;
import org.infinispan.server.memcached.text.TokenReader;

public class TextIntrinsics {
    private static final BitSet NUMBERS = BitSet.valueOf(new long[]{0x3FF000000000000L});
    private static final BitSet LETTERS = BitSet.valueOf(new long[]{0L, 576460745995190270L});
    private static final BitSet TEXT = BitSet.valueOf(new long[]{-4294976513L, -1L, -1L, -1L});

    public static short short_(ByteBuf b) {
        if (b.readableBytes() >= 2) {
            return b.readShort();
        }
        return 0;
    }

    public static byte[] fixedArray(ByteBuf b, int length) {
        b.markReaderIndex();
        return ExtendedByteBufJava.readMaybeRangedBytes((ByteBuf)b, (int)length);
    }

    private static Void consumeLine(ByteBuf buf) {
        buf.markReaderIndex();
        while (buf.isReadable()) {
            byte b = buf.readByte();
            if (b != 10) continue;
            return null;
        }
        buf.resetReaderIndex();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuf token(ByteBuf buf, TokenReader reader) {
        int offset = buf.forEachByte((ByteProcessor)reader);
        if (offset <= 0) {
            return null;
        }
        try {
            ByteBuf byteBuf = reader.output();
            return byteBuf;
        }
        finally {
            buf.skipBytes(reader.readBytesSize());
        }
    }

    public static long long_number(ByteBuf buf, TokenReader reader) {
        ByteBuf s = TextIntrinsics.token(buf, reader.forToken(NUMBERS));
        if (s == null) {
            return 0L;
        }
        if (s.isReadable()) {
            return Long.parseUnsignedLong(s.toString(StandardCharsets.US_ASCII));
        }
        TextIntrinsics.consumeLine(buf);
        throw new IllegalArgumentException("Expected number");
    }

    public static int int_number(ByteBuf buf, TokenReader reader) {
        ByteBuf s = TextIntrinsics.token(buf, reader.forToken(NUMBERS));
        if (s == null) {
            return 0;
        }
        if (s.isReadable()) {
            return TextIntrinsics.parseUnsignedInt(s);
        }
        TextIntrinsics.consumeLine(buf);
        throw new IllegalArgumentException("Expected number");
    }

    public static TextCommand command(ByteBuf buf, TokenReader reader) {
        ByteBuf id = TextIntrinsics.token(buf, reader.forToken(LETTERS));
        try {
            return id == null ? null : TextCommand.valueOf(id);
        }
        catch (IllegalArgumentException e) {
            TextIntrinsics.consumeLine(buf);
            throw new UnsupportedOperationException(id.toString(StandardCharsets.US_ASCII));
        }
    }

    public static byte[] text(ByteBuf buf, TokenReader reader) {
        ByteBuf s = TextIntrinsics.token(buf, reader.forToken(TEXT));
        if (s == null || !s.isReadable()) {
            return null;
        }
        byte[] b = new byte[s.readableBytes()];
        s.readBytes(b);
        return b;
    }

    public static byte[] text_key(ByteBuf buf, TokenReader reader) {
        ByteBuf s = TextIntrinsics.token(buf, reader.forToken(TEXT));
        if (s == null || !s.isReadable()) {
            return null;
        }
        if (s.readableBytes() > 250) {
            TextIntrinsics.consumeLine(buf);
            throw new IllegalArgumentException("Key length over the 250 character limit");
        }
        byte[] b = new byte[s.readableBytes()];
        s.readBytes(b);
        return b;
    }

    public static List<byte[]> text_list(ByteBuf buf, TokenReader reader) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        byte[] b = TextIntrinsics.text(buf, reader);
        while (b != null) {
            list.add(b);
            b = TextIntrinsics.text(buf, reader);
        }
        return list;
    }

    public static List<byte[]> text_key_list(ByteBuf buf, TokenReader reader) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        byte[] b = TextIntrinsics.text_key(buf, reader);
        while (b != null) {
            list.add(b);
            b = TextIntrinsics.text_key(buf, reader);
        }
        return list;
    }

    public static boolean eowc(ByteBuf buf) {
        buf.markReaderIndex();
        if (buf.readableBytes() > 1) {
            short b = buf.readUnsignedByte();
            if (b == 13) {
                buf.readByte();
                return false;
            }
            if (b == TextConstants.NOREPLY[0]) {
                int pos = 1;
                while (buf.readableBytes() > 0) {
                    b = buf.readUnsignedByte();
                    if (b != TextConstants.NOREPLY[pos]) {
                        TextIntrinsics.consumeLine(buf);
                        throw new IllegalArgumentException();
                    }
                    if (++pos != TextConstants.NOREPLY.length) continue;
                    return true;
                }
            } else {
                TextIntrinsics.consumeLine(buf);
                throw new IllegalArgumentException();
            }
        }
        buf.resetReaderIndex();
        return false;
    }

    public static long parseLong(ByteBuf s) {
        long result;
        byte first = s.readByte();
        long l = result = first == 43 ? 0L : (long)(first - 48);
        while (s.isReadable()) {
            byte b = s.readByte();
            if (b < 48 || b > 57) {
                throw new NumberFormatException("Invalid character: " + b);
            }
            result = (result << 3) + (result << 1) + (long)(b - 48);
        }
        return result;
    }

    public static int parseUnsignedInt(ByteBuf s) {
        long v = TextIntrinsics.parseLong(s);
        if ((v & 0xFFFFFFFF00000000L) != 0L) {
            throw new NumberFormatException("Value exceeds range of unsigned int: " + v);
        }
        return (int)v;
    }
}

