package org.infinispan.server.memcached.text;
import java.util.List;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.time.Instant;
import java.time.temporal.Temporal;
import org.infinispan.server.memcached.MemcachedServer;

public class TextAuthDecoderImpl extends TextAuthDecoder {
	private int state;
	private int requestBytes;

	private long mc_long_number;
	private int mc_parseUnsignedInt;
	private long mc_exptime;
	private byte[] mc_text_key;
	private long mc_parseLong;
	private int mc_flags;
	private Void mc_consumeLine;
	private ByteBuf mc_token;
	private byte[] mc_fixedArray;
	private TextCommand mc_command_name;
	private int mc_int_number;
	private byte[] mc_text;
	private TextCommand mc_command;
	private int mc_vsize;
	private List<byte[]> mc_text_key_list;
	private byte[] mc_key;
	private byte[] mc_value;
	private short mc_eol;
	private short mc_short;
	private List<byte[]> mc_text_list;
	private boolean mc_eowc;

	private boolean deadEnd = false;
	public TextAuthDecoderImpl(MemcachedServer server) {
		super(server);
	}

	@Override
	public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
		int pos = buf.readerIndex();
		try {
			while (switch0(buf, out));
		} catch (Throwable t) {
			exceptionally(t);
		} finally {
			requestBytes += buf.readerIndex() - pos;
		}
	}

	private boolean switch0(ByteBuf buf, List<Object> out) throws Exception {
		byte b;
		int pos;
		switch (state) {
		case 0: 
			// 
			reset(); 
			state = 1;
			// fallthrough
		case 1: 
			// 
			pos = buf.readerIndex();
			mc_command = org.infinispan.server.memcached.text.TextIntrinsics.command(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_command_name = mc_command;
			state = 2;
			// fallthrough
		case 2: 
			// mc.request
			requestStart = Instant.now();
			
			state = 3;
			// fallthrough
		case 3: 
			// mc.request
			switch (mc_command_name) {
			case set: 
				state = 4;
				return true;
			default: 
				throw new IllegalArgumentException("Unknown command " + mc_command_name);
				
			}
		case 4: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_key = org.infinispan.server.memcached.text.TextIntrinsics.text_key(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_text_key;
			state = 5;
			// fallthrough
		case 5: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_flags = mc_int_number;
			state = 6;
			// fallthrough
		case 6: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_long_number = org.infinispan.server.memcached.text.TextIntrinsics.long_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_exptime = mc_long_number;
			state = 7;
			// fallthrough
		case 7: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_vsize = mc_int_number;
			state = 8;
			// fallthrough
		case 8: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_short = org.infinispan.server.memcached.text.TextIntrinsics.short_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_eol = mc_short;
			state = 9;
			// fallthrough
		case 9: 
			// mc.request/mc.parameters
			if (mc_vsize > 0) {
				state = 11;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 10;
			// fallthrough
		case 10: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_short = org.infinispan.server.memcached.text.TextIntrinsics.short_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_eol = mc_short;
			state = 12;
			return true;
		case 11: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.text.TextIntrinsics.fixedArray(buf, mc_vsize);
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 10;
			return true;
		case 12: 
			// mc.request/mc.parameters
			auth(mc_value);
			
			state = 0;
			return true;
		}
		return true;
	}

	private void deadEnd() {
		if (! deadEnd) {
			log.tracef("Invalid state of parsing");
			deadEnd = true;
		}
		state = 0;
	}

	private void exceptionally(Throwable t) throws Exception {
		log.trace("Parsing error", t);
		state = 0;
	}

	private void reset() {
		requestBytes = 0;
		mc_long_number = 0;
		mc_parseUnsignedInt = 0;
		mc_exptime = 0;
		mc_text_key = null;
		mc_parseLong = 0;
		mc_flags = 0;
		mc_consumeLine = null;
		mc_token = null;
		mc_fixedArray = null;
		mc_command_name = null;
		mc_int_number = 0;
		mc_text = null;
		mc_command = null;
		mc_vsize = 0;
		mc_text_key_list = null;
		mc_key = null;
		mc_value = null;
		mc_eol = 0;
		mc_short = 0;
		mc_text_list = null;
		mc_eowc = false;
	}

	public int requestBytes() {
		return requestBytes;
	}
}
